/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.client.rendering;

import com.google.common.collect.Lists;
import java.util.List;
import net.deadlydiamond98.familiar_friends.common.entities.PlayerCompanion;
import net.deadlydiamond98.familiar_friends.common.entities.base.MockLivingEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;

public abstract class CompanionRenderer<T extends PlayerCompanion, M extends class_583<T>>
extends class_897<T>
implements class_3883<T, M> {
    protected M model;
    protected final List<class_3887<T, M>> features = Lists.newArrayList();

    public CompanionRenderer(class_5617.class_5618 ctx, M model) {
        super(ctx);
        this.model = model;
    }

    protected final boolean addFeature(class_3887<T, M> feature) {
        return this.features.add(feature);
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumerProvider, int i) {
        matrices.method_22903();
        if (this.doBobbingAnimation() && !((PlayerCompanion)((Object)entity)).isBookRender()) {
            matrices.method_22904(0.0, Math.sin((double)((float)((PlayerCompanion)((Object)entity)).field_6012 + tickDelta) * 0.1) * 0.1, 0.0);
        }
        matrices.method_22903();
        ((class_583)this.model).field_3447 = this.getHandSwingProgress(entity, tickDelta);
        float bodyYaw = class_3532.method_17821((float)tickDelta, (float)((PlayerCompanion)((Object)entity)).prevBodyYaw, (float)((PlayerCompanion)((Object)entity)).bodyYaw);
        float headYaw = class_3532.method_17821((float)tickDelta, (float)((PlayerCompanion)((Object)entity)).prevHeadYaw, (float)((PlayerCompanion)((Object)entity)).headYaw);
        float netHeadYaw = headYaw - bodyYaw;
        netHeadYaw = class_3532.method_15393((float)netHeadYaw);
        float animationProgress = this.getAnimationProgress(entity, tickDelta);
        this.setupTransforms(entity, matrices, animationProgress, bodyYaw, tickDelta, 0);
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
        this.scale(entity, matrices);
        matrices.method_46416(0.0f, -1.501f, 0.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(((PlayerCompanion)((Object)entity)).bodyYaw + 180.0f));
        float limbSwing = ((PlayerCompanion)((Object)entity)).limbAnimator.method_48570(tickDelta);
        float limbSwingAmount = ((PlayerCompanion)((Object)entity)).limbAnimator.method_48572(tickDelta);
        if (limbSwing > 1.0f) {
            limbSwing = 1.0f;
        }
        this.model.method_2816(entity, limbSwingAmount, limbSwing, tickDelta);
        this.model.method_2819(entity, limbSwingAmount, limbSwing, animationProgress, netHeadYaw, 0.0f);
        class_310 minecraftClient = class_310.method_1551();
        boolean bl = !entity.method_5767();
        boolean bl2 = entity.method_5756((class_1657)minecraftClient.field_1724);
        boolean bl3 = minecraftClient.method_27022(entity);
        class_1921 renderLayer = this.getRenderLayer(entity, bl, bl2, bl3);
        if (renderLayer != null) {
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(renderLayer);
            int q = this.getOverlay(entity, 0.0f);
            this.model.method_2828(matrices, vertexConsumer, i, q, 1.0f, 1.0f, 1.0f, bl2 ? 0.15f : 1.0f);
        }
        if (!entity.method_7325()) {
            for (class_3887<T, M> feature : this.features) {
                feature.method_4199(matrices, vertexConsumerProvider, i, entity, limbSwingAmount, limbSwing, tickDelta, animationProgress, netHeadYaw, 0.0f);
            }
        }
        matrices.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrices, vertexConsumerProvider, i);
        this.otherModelParts(entity, matrices, vertexConsumerProvider, tickDelta);
        matrices.method_22909();
    }

    protected void otherModelParts(T entity, class_4587 matrices, class_4597 vertexConsumerProvider, float tickDelta) {
    }

    protected boolean doBobbingAnimation() {
        return true;
    }

    protected void setupTransforms(T entity, class_4587 matrices, float animationProgress, float bodyYaw, float tickDelta, int i) {
    }

    public M method_4038() {
        return this.model;
    }

    protected void scale(T entity, class_4587 matrices) {
        if (((PlayerCompanion)((Object)entity)).isBookRender()) {
            this.guiScale(matrices);
        } else {
            this.worldScale(matrices);
        }
    }

    protected void scale(class_4587 matrices, float i) {
        matrices.method_22905(i, i, i);
    }

    protected abstract void guiScale(class_4587 var1);

    protected abstract void worldScale(class_4587 var1);

    @Nullable
    protected class_1921 getRenderLayer(T entity, boolean showBody, boolean translucent, boolean showOutline) {
        class_2960 identifier = this.method_3931((class_1297)entity);
        if (translucent) {
            return class_1921.method_29379((class_2960)identifier);
        }
        if (showBody) {
            return this.model.method_23500(identifier);
        }
        return showOutline ? class_1921.method_23287((class_2960)identifier) : null;
    }

    public int getOverlay(T entity, float whiteOverlayProgress) {
        return class_4608.method_23625((int)class_4608.method_23210((float)whiteOverlayProgress), (int)class_4608.method_23212((boolean)false));
    }

    protected float getAnimationProgress(T entity, float tickDelta) {
        return (float)((PlayerCompanion)((Object)entity)).field_6012 + tickDelta;
    }

    private float getHandSwingProgress(T entity, float tickDelta) {
        return ((MockLivingEntity)((Object)entity)).getHandSwingProgress(tickDelta);
    }
}

