/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.client.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.deadlydiamond98.familiar_friends.FamiliarFriends;
import net.deadlydiamond98.familiar_friends.client.screens.widgets.CompanionBookButton;
import net.deadlydiamond98.familiar_friends.client.screens.widgets.CompanionHomeButton;
import net.deadlydiamond98.familiar_friends.client.screens.widgets.CompanionIconButton;
import net.deadlydiamond98.familiar_friends.common.entities.PlayerCompanion;
import net.deadlydiamond98.familiar_friends.init.client.CompanionKeybindings;
import net.deadlydiamond98.familiar_friends.networking.c2s.EquipCompanionC2SPacket;
import net.deadlydiamond98.familiar_friends.networking.c2s.RequestCompanionC2SPacket;
import net.deadlydiamond98.familiar_friends.networking.c2s.UnequipCompanionC2SPacket;
import net.deadlydiamond98.familiar_friends.networking.c2s.UnlockCompanionC2SPacket;
import net.deadlydiamond98.familiar_friends.util.CompanionRegistry;
import net.deadlydiamond98.familiar_friends.util.TimeUnitHelper;
import net.deadlydiamond98.familiar_friends.util.screen.CompanionGuiDrawMethods;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_474;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class CompanionBookScreen
extends class_437 {
    private static final int SCROLL_STEP = 10;
    private static final class_2960 BOOK_TEXTURE = class_2960.method_43902((String)"familiar_friends", (String)"textures/gui/companion_book.png");
    private final List<PlayerCompanion> renderedCompanions = new ArrayList<PlayerCompanion>();
    private final List<CompanionIconButton> legendButtons = new ArrayList<CompanionIconButton>();
    private final List<class_4068> drawables = Lists.newArrayList();
    private int pageIndex;
    private class_474 nextPageButton;
    private class_474 previousPageButton;
    private CompanionBookButton unlockButton;
    private CompanionBookButton equipButton;
    private CompanionBookButton unequipButton;
    private CompanionHomeButton homeButton;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int indexOffset = 0;
    private boolean listLoaded = false;

    public CompanionBookScreen(class_2561 title) {
        super(title);
    }

    protected void method_25426() {
        this.init(true);
    }

    private void init(boolean createCompanionList) {
        this.method_37067();
        this.legendButtons.clear();
        this.drawables.clear();
        this.maxScroll = 0;
        if (createCompanionList) {
            this.addCompanions();
        }
        this.addLegendButtons();
        this.addPageButtons();
        this.addEntityButtons();
        this.updateButtons();
    }

    private void addCompanions() {
        if (this.field_22787.field_1724 == null) {
            FamiliarFriends.LOGGER.info("Tried to add Companions to book, but player was null");
            return;
        }
        this.renderedCompanions.clear();
        this.addCompanionsToBook((class_1657)this.field_22787.field_1724);
    }

    public void renderBackground(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        this.drawBackground(context, delta, mouseX, mouseY);
    }

    protected void drawBackground(class_332 context, float delta, int mouseX, int mouseY) {
        this.updateEntityButtons();
        this.updatePageButtons();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)BOOK_TEXTURE);
        class_4587 matrices = context.method_51448();
        int guiX = this.field_22789 / 2;
        int guiY = 2;
        context.method_25290(BOOK_TEXTURE, (this.field_22789 - 320) / 2, guiY, 8.0f, 2.0f, 320, 200, 512, 512);
        if (this.renderedCompanions.isEmpty()) {
            return;
        }
        if (this.pageIndex == 0) {
            this.drawFirstPage(context, delta, mouseX, mouseY, guiX, guiY);
            return;
        }
        PlayerCompanion companion = this.renderedCompanions.get(this.pageIndex - 1);
        int companionX = guiX - 80;
        int companionY = guiY + 110;
        if (companion.isLocked((class_1657)this.field_22787.field_1724)) {
            context.method_25290(BOOK_TEXTURE, (this.field_22789 - 11) / 2 - 140, companionY - 100, 12.0f, 246.0f, 11, 15, 512, 512);
            xpCost = companion.getCostLang(companion.getCostClient()).method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
            CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY - 95, (class_2561)xpCost, 1.0f, 4689479, false);
        } else {
            xpCost = class_2561.method_43471((String)"gui.familiar_friends.unlocked").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_36139(4689479));
            CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY - 95, (class_2561)xpCost, 1.0f, 4689479, false);
        }
        context.method_25290(BOOK_TEXTURE, (this.field_22789 - 106) / 2 - 80, companionY - 83, 329.0f, 2.0f, 106, 106, 512, 512);
        CompanionGuiDrawMethods.drawEntity(context, companionX, companionY, 40, 0.0625f, companion, companion.isLocked((class_1657)this.field_22787.field_1724));
        class_5250 name = companion.method_5477().method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY += 25, (class_2561)name, 1.25f, 5719094, false);
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY += 15, companion.getAuthor(), 0.55f, 9798506, true);
        int descriptionX = guiX + 80;
        int descriptionY = guiY + 15;
        class_5250 descriptionTitle = class_2561.method_43471((String)"gui.familiar_friends.desc").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, descriptionX, descriptionY, (class_2561)descriptionTitle, 1.0f, 5719094, false);
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, descriptionX, descriptionY += 15, companion.getDescription(CompanionKeybindings.getKeyLang()), 0.75f, 7758928, false);
    }

    private void drawFirstPage(class_332 context, float delta, int mouseX, int mouseY, int guiX, int guiY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrices = context.method_51448();
        int companionX = guiX - 80;
        int companionY = guiY + 108;
        class_746 player = this.field_22787.field_1724;
        PlayerCompanion playerCompanion = CompanionRegistry.createCompanion(player.currentCompanion(), (class_1657)player, true);
        class_5250 currentText = class_2561.method_43471((String)"gui.familiar_friends.current_companion").method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY - 95, (class_2561)currentText, 1.25f, 5719094, false);
        context.method_25290(BOOK_TEXTURE, (this.field_22789 - 106) / 2 - 80, companionY - 83, 329.0f, 2.0f, 106, 106, 512, 512);
        if (playerCompanion != null) {
            this.showCurrentCompanionGUI(context, delta, mouseX, mouseY, companionX, companionY, playerCompanion, matrices);
        }
        context.method_25290(BOOK_TEXTURE, (this.field_22789 - 106) / 2 + 65, companionY - 98, 56.0f, 266.0f, 126, 160, 512, 512);
        this.drawScrollBar(context, guiX + 138, companionY - 98, 158);
    }

    private void showCurrentCompanionGUI(class_332 context, float delta, int mouseX, int mouseY, int companionX, int companionY, PlayerCompanion playerCompanion, class_4587 matrices) {
        CompanionGuiDrawMethods.drawEntity(context, companionX, companionY, 40, 0.0625f, playerCompanion, playerCompanion.isLocked((class_1657)this.field_22787.field_1724));
        class_5250 name = playerCompanion.method_5477().method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY += 25, (class_2561)name, 1.25f, 5719094, false);
        CompanionGuiDrawMethods.drawResizeableCenteredText(this.field_22793, context, matrices, companionX, companionY += 15, playerCompanion.getAuthor(), 0.55f, 9798506, true);
    }

    protected void drawForeground(class_332 context, int mouseX, int mouseY) {
        if (this.pageIndex == 0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)BOOK_TEXTURE);
        PlayerCompanion companion = this.renderedCompanions.get(this.pageIndex - 1);
        if (companion.isLocked((class_1657)this.field_22787.field_1724)) {
            context.method_25293(BOOK_TEXTURE, (this.field_22789 - 106) / 2 - 82, 27, 110, 110, 57.0f, 204.0f, 56, 56, 512, 512);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (amount < 0.0) {
            this.scrollOffset = Math.min(this.scrollOffset + 10, this.maxScroll);
        } else if (amount > 0.0) {
            this.scrollOffset = Math.max(this.scrollOffset - 10, 0);
        }
        this.legendButtons.forEach(button -> button.scroll(-this.scrollOffset));
        this.updateLegendButtons();
        return true;
    }

    private void drawScrollBar(class_332 context, int guiX, int guiY, int height) {
        int scrollBarHeight = height;
        int barWidth = 5;
        context.method_25294(guiX, guiY, guiX + barWidth, guiY + scrollBarHeight, -11058122);
        if (this.maxScroll > 0) {
            int scrollBarThumbHeight = Math.max(20, scrollBarHeight * scrollBarHeight / (scrollBarHeight + this.maxScroll));
            int scrollThumbY = guiY + this.scrollOffset * (scrollBarHeight - scrollBarThumbHeight) / this.maxScroll;
            context.method_25294(guiX, scrollThumbY, guiX + barWidth, scrollThumbY + scrollBarThumbHeight, -6978710);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.listLoaded) {
            return;
        }
        this.renderBackground(context, mouseX, mouseY, delta);
        Iterator<class_4068> var5 = this.drawables.iterator();
        ArrayList<CompanionIconButton> iconButtons = new ArrayList<CompanionIconButton>();
        while (var5.hasNext()) {
            class_4068 drawable = var5.next();
            if (drawable instanceof CompanionIconButton) {
                CompanionIconButton iconButton2 = (CompanionIconButton)drawable;
                int guiX = this.field_22789 / 2;
                int guiY = 2;
                context.method_44379(guiX, guiY + 14, guiX + 160, guiY + 164);
                drawable.method_25394(context, mouseX, mouseY, delta);
                context.method_44380();
                iconButtons.add(iconButton2);
                continue;
            }
            drawable.method_25394(context, mouseX, mouseY, delta);
        }
        iconButtons.forEach(iconButton -> {
            if (iconButton.field_22764) {
                iconButton.renderTooltip(context, this.field_22793, mouseX, mouseY);
            }
        });
        RenderSystem.disableDepthTest();
        this.drawForeground(context, mouseX, mouseY);
        RenderSystem.enableDepthTest();
    }

    protected void addPageButtons() {
        int i = (this.field_22789 - 320) / 2;
        this.nextPageButton = this.method_37063(new class_474(i + 280, 170, true, button -> this.goToNextPage(), true));
        this.previousPageButton = this.method_37063(new class_474(i + 16, 170, false, button -> this.goToPreviousPage(), true));
    }

    private void addEntityButtons() {
        int i = this.field_22789 / 2;
        this.unlockButton = this.method_37063(new CompanionBookButton(i + 80, 150, 100, 15, (class_2561)class_2561.method_43471((String)"gui.familiar_friends.unlock"), button -> this.unlockFamiliar()));
        this.equipButton = this.method_37063(new CompanionBookButton(i + 80, 150, 100, 15, (class_2561)class_2561.method_43471((String)"gui.familiar_friends.equip"), button -> this.equipFamiliar()));
        this.unequipButton = this.method_37063(new CompanionBookButton(i - 80, 176, 100, 15, (class_2561)class_2561.method_43471((String)"gui.familiar_friends.unequip"), button -> this.unequipFamiliar()));
        this.homeButton = this.method_37063(new CompanionHomeButton(i + 80, 175, 12, 12, button -> this.goHome()));
    }

    private void addLegendButtons() {
        if (this.field_22787.field_1724 == null) {
            FamiliarFriends.LOGGER.info("Tried to render legend book, but player was null");
            return;
        }
        int guiX = this.field_22789 / 2 + 30;
        int guiY = 30;
        int buttonWidth = 25;
        int buttonHeight = 25;
        int spacing = 5;
        int buttonsPerRow = 4;
        for (int i = 0; i < this.renderedCompanions.size(); ++i) {
            int row = i / buttonsPerRow;
            int col = i % buttonsPerRow;
            if (row >= 5 && col == 0) {
                this.maxScroll += buttonHeight + spacing;
            }
            int buttonX = guiX + col * (buttonWidth + spacing);
            int buttonY = guiY + row * (buttonHeight + spacing);
            CompanionIconButton legendButton = new CompanionIconButton(buttonX, buttonY, buttonWidth, buttonHeight, i, this.renderedCompanions.get(i).isLocked((class_1657)this.field_22787.field_1724), this.renderedCompanions.get(i), button -> this.onLegendButtonClicked((CompanionIconButton)button));
            this.legendButtons.add(this.method_37063(legendButton));
        }
    }

    private void onLegendButtonClicked(CompanionIconButton button) {
        this.pageIndex = button.getEntityIndex() + 1;
        this.updateButtons();
    }

    private void unlockFamiliar() {
        PlayerCompanion companion = this.renderedCompanions.get(this.pageIndex - 1);
        UnlockCompanionC2SPacket.send(companion.method_5864().method_5882());
        this.unlockButton.field_22764 = false;
        this.equipButton.field_22764 = true;
    }

    private void equipFamiliar() {
        PlayerCompanion companion = this.renderedCompanions.get(this.pageIndex - 1);
        EquipCompanionC2SPacket.send(companion.method_5864().method_5882());
        this.equipButton.field_22763 = false;
        this.updateEntityButtons();
    }

    private void unequipFamiliar() {
        UnequipCompanionC2SPacket.send();
        this.unequipButton.field_22763 = false;
        this.updateEntityButtons();
    }

    protected void goToPreviousPage() {
        if (this.pageIndex > 0) {
            --this.pageIndex;
        }
        this.updateButtons();
    }

    protected void goToNextPage() {
        if (this.pageIndex < this.getPageCount() - 1) {
            ++this.pageIndex;
        }
        this.updateButtons();
    }

    private void goHome() {
        this.pageIndex = 0;
        this.updateButtons();
    }

    private void updateEntityButtons() {
        boolean pastFirstPage = this.pageIndex > 0;
        class_746 player = this.field_22787.field_1724;
        PlayerCompanion companion = pastFirstPage ? this.renderedCompanions.get(this.pageIndex - 1) : null;
        boolean companionExists = companion != null;
        boolean companionLocked = companionExists && companion.isLocked((class_1657)player);
        boolean hasCompanion = player.getCompanion() != null;
        boolean hasDifferentCompanion = companionExists && !companion.method_5864().method_5882().equals(player.currentCompanion());
        this.unlockButton.field_22764 = pastFirstPage && companionLocked;
        this.equipButton.field_22764 = pastFirstPage && !companionLocked;
        this.unequipButton.field_22764 = !pastFirstPage;
        this.homeButton.field_22764 = pastFirstPage;
        this.equipButton.field_22763 = hasDifferentCompanion && player.getCompanionCooldown() <= 0;
        this.unequipButton.field_22763 = hasCompanion;
        boolean bl = this.unlockButton.field_22763 = pastFirstPage && companionExists && player.field_7520 >= companion.getCostClient();
        if (player.getCompanionCooldown() > 0) {
            this.equipButton.method_25355((class_2561)class_2561.method_43470((String)(TimeUnitHelper.calculateCooldownUnit(player.getCompanionCooldown()) + " ")).method_10852((class_2561)class_2561.method_43471((String)("cooldown.familiar_friends." + TimeUnitHelper.getCooldownUnitText(player.getCompanionCooldown())))));
        } else {
            this.equipButton.method_25355((class_2561)class_2561.method_43471((String)"gui.familiar_friends.equip"));
        }
    }

    private void updatePageButtons() {
        this.nextPageButton.field_22764 = this.pageIndex < this.getPageCount() - 1;
        this.previousPageButton.field_22764 = this.pageIndex > 0;
    }

    private void updateButtons() {
        this.updatePageButtons();
        this.updateEntityButtons();
        this.updateLegendButtons();
    }

    private void updateLegendButtons() {
        this.legendButtons.forEach(button -> {
            button.field_22764 = this.pageIndex < 1 && button.getYScrolled() > 0 && button.getYScrolled() < 180;
            button.locked = this.renderedCompanions.get(button.getEntityIndex()).isLocked((class_1657)this.field_22787.field_1724);
        });
    }

    private int getPageCount() {
        return this.renderedCompanions.size() + 1;
    }

    protected <T extends class_364 & class_4068> T method_37063(T drawableElement) {
        this.drawables.add(drawableElement);
        return (T)super.method_37063(drawableElement);
    }

    public void addCompanionsToBook(class_1657 player) {
        CompanionRegistry.COMPANIONS.forEach((key, companionClass) -> {
            PlayerCompanion companion = CompanionRegistry.createCompanion(key, player, true);
            if (companion != null) {
                this.renderedCompanions.add(companion);
            }
        });
        if (this.renderedCompanions.isEmpty()) {
            FamiliarFriends.LOGGER.info("No Companions added to the book :<");
        }
        this.renderedCompanions.sort((o1, o2) -> {
            String name1 = o1.method_5477().getString();
            String name2 = o2.method_5477().getString();
            return name1.compareToIgnoreCase(name2);
        });
        for (int i = 0; i < this.renderedCompanions.size(); ++i) {
            RequestCompanionC2SPacket.send(this.renderedCompanions.get(i).method_5864().method_5882(), i);
        }
    }

    public void syncCompanionData(int cost, boolean enabled, int index) {
        int i = index - this.indexOffset;
        this.renderedCompanions.get(i).syncClientData(cost, enabled);
        if (!enabled) {
            this.renderedCompanions.remove(i);
            this.init(false);
            ++this.indexOffset;
        }
        this.listLoaded = true;
    }

    public boolean method_25421() {
        return false;
    }
}

