/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.common.entities;

import java.util.Comparator;
import java.util.List;
import net.deadlydiamond98.familiar_friends.common.entities.base.MockLivingEntity;
import net.deadlydiamond98.familiar_friends.util.TimeUnitHelper;
import net.deadlydiamond98.koalalib.init.KoalaLibSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerCompanion
extends MockLivingEntity {
    private int cooldown;
    private int costClient;
    private boolean enabledClient;
    protected boolean bookRender;

    public PlayerCompanion(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public PlayerCompanion(class_1299<?> type, class_1937 world, class_1657 owner, boolean gui) {
        this(type, world);
        this.setOwner((class_1297)owner);
        this.method_33574(owner.method_19538());
        this.costClient = 0;
        this.enabledClient = false;
        this.cooldown = 0;
        this.field_5960 = true;
        this.bookRender = gui;
    }

    public void doPassiveAction(class_1657 player, class_1309 nearestHostile) {
    }

    public void doKeyEvent(class_1657 player) {
    }

    public void onAttack(class_1657 player, class_1309 target, float amount) {
    }

    public void onPlayerDeath(class_1657 player) {
    }

    public boolean onDamaged(class_1282 source, float amount, class_1657 player) {
        return false;
    }

    public boolean canClimbWalls() {
        return false;
    }

    @Nullable
    public class_6862<class_3611> walkableFluids() {
        return null;
    }

    public boolean canWalkOnPowderSnow() {
        return false;
    }

    public class_1309 findNearestHostile(class_1657 player) {
        List nearbyEntities = player.method_37908().method_8390(class_1309.class, player.method_5829().method_1014(10.0), entity -> entity instanceof class_1569 && entity.method_5805());
        return nearbyEntities.stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)player))).orElse(null);
    }

    public class_1297 findNearestEntity(class_1657 player) {
        List nearbyEntities = player.method_37908().method_8390(class_1297.class, player.method_5829().method_1014(10.0), class_1297::method_5805);
        return nearbyEntities.stream().min(Comparator.comparingDouble(entity -> entity.method_5858((class_1297)player))).orElse(null);
    }

    public abstract int getCost();

    public abstract boolean isEnabled();

    public boolean hasNoHealthLimitation(class_1657 player, int minimum) {
        return this.hasNoLimitationOf(player.method_6032(), minimum, player, (class_2561)class_2561.method_43469((String)"cooldown.familiar_friends.lowstat", (Object[])new Object[]{class_2561.method_43471((String)"cooldown.familiar_friends.health").getString()}), true);
    }

    public boolean hasNoHungerLimitation(class_1657 player, int minimum) {
        return this.hasNoLimitationOf(player.method_7344().method_7586(), minimum, player, (class_2561)class_2561.method_43469((String)"cooldown.familiar_friends.lowstat", (Object[])new Object[]{class_2561.method_43471((String)"cooldown.familiar_friends.hunger").getString()}), true);
    }

    public boolean hasNoLimitationOf(float currentValue, float threshold, class_1657 player, class_2561 translation, boolean trueIfCreative) {
        if (trueIfCreative && (player.method_7337() || player.method_7325())) {
            return true;
        }
        if (currentValue <= threshold) {
            player.method_37908().method_8396(null, player.method_24515(), KoalaLibSounds.CONSOLE_CRAFT_FAIL, class_3419.field_15248, 0.5f, 1.0f);
            player.method_7353(translation, true);
        }
        return !(currentValue <= threshold);
    }

    public boolean hasNoCooldown(class_1657 player) {
        String cooldownUnit = TimeUnitHelper.getCooldownUnitText(this.cooldown);
        int time = TimeUnitHelper.calculateCooldownUnit(this.cooldown);
        return this.hasNoLimitationOf(1.0f, this.cooldown, player, (class_2561)class_2561.method_43469((String)"cooldown.familiar_friends.cooldown", (Object[])new Object[]{time, class_2561.method_43471((String)("cooldown.familiar_friends." + cooldownUnit)).getString()}), false);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public void setCooldownSeconds(int cooldown) {
        this.cooldown = cooldown * 20;
    }

    public void setCooldownMinutes(int cooldown) {
        this.cooldown = cooldown * 20 * 60;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public class_2561 getDescription(String keybinding) {
        return class_2561.method_43469((String)(this.method_5864().method_5882() + ".description"), (Object[])new Object[]{keybinding});
    }

    public class_2561 getAuthor() {
        return class_2561.method_43471((String)"gui.familiar_friends.author").method_10852((class_2561)class_2561.method_43471((String)(this.method_5864().method_5882() + ".author")));
    }

    public class_2561 getCostLang(int cost) {
        return class_2561.method_43469((String)"gui.familiar_friends.cost", (Object[])new Object[]{cost}).method_10862(class_2583.field_24360.method_36139(4689479));
    }

    public boolean isBookRender() {
        return this.bookRender;
    }

    public boolean isLocked(class_1657 player) {
        return !player.isCompanionUnlocked(this);
    }

    public void syncClientData(int cost, boolean enabledClient) {
        this.costClient = cost;
        this.enabledClient = enabledClient;
    }

    public boolean getEnabledClient() {
        return this.enabledClient;
    }

    public int getCostClient() {
        return this.costClient;
    }
}

