/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.common.entities.base;

import java.util.UUID;
import net.deadlydiamond98.familiar_friends.common.entities.base.LookAroundRandomlyBehavior;
import net.deadlydiamond98.familiar_friends.common.entities.base.NonLivingLookControl;
import net.deadlydiamond98.koalalib.common.entity.LerpedMovmentEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_8046;
import net.minecraft.class_8080;
import org.jetbrains.annotations.Nullable;

public class MockLivingEntity
extends LerpedMovmentEntity
implements class_8046 {
    public final class_8080 limbAnimator = new class_8080();
    public float lastHandSwingProgress;
    public float handSwingProgress;
    public float bodyYaw;
    public float prevBodyYaw;
    public float headYaw;
    public float prevHeadYaw;
    protected float lookDirection;
    protected float prevLookDirection;
    private int headSteps;
    private float serverHeadYaw;
    protected NonLivingLookControl lookControl = new NonLivingLookControl(this);
    private LookAroundRandomlyBehavior currentLookBehavior;
    private int idlingTime;
    private float orbitArc;
    @Nullable
    private UUID ownerUuid;
    @Nullable
    private class_1297 owner;

    public MockLivingEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public void updateLimbs() {
        float f = (float)class_3532.method_33825((double)(this.method_23317() - this.field_6014), (double)0.0, (double)(this.method_23321() - this.field_5969));
        this.updateLimbs(f * 0.5f);
    }

    protected void updateLimbs(float posDelta) {
        float f = Math.min(posDelta * 4.0f, 1.0f);
        this.limbAnimator.method_48568(f, 0.4f);
    }

    public float getHandSwingProgress(float tickDelta) {
        float f = this.handSwingProgress - this.lastHandSwingProgress;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.lastHandSwingProgress + f * tickDelta;
    }

    public void method_5670() {
        super.method_5670();
        this.lastHandSwingProgress = this.handSwingProgress;
        this.prevLookDirection = this.lookDirection;
        this.prevBodyYaw = this.bodyYaw;
        this.prevHeadYaw = this.headYaw;
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.method_37908().method_16107().method_15407();
    }

    protected float turnHead(float bodyRotation, float headRotation) {
        boolean bl;
        float f = class_3532.method_15393((float)(bodyRotation - this.bodyYaw));
        this.bodyYaw += f * 0.3f;
        float g = class_3532.method_15393((float)(this.method_36454() - this.bodyYaw));
        float h = 50.0f;
        if (Math.abs(g) > h) {
            this.bodyYaw += g - (float)class_3532.method_17822((double)g) * h;
        }
        boolean bl2 = bl = g < -90.0f || g >= 90.0f;
        if (bl) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    public void method_5773() {
        super.method_5773();
        double d = this.method_23317() - this.field_6014;
        double e = this.method_23321() - this.field_5969;
        float f = (float)(d * d + e * e);
        float g = this.bodyYaw;
        float h = 0.0f;
        if (f > 0.0025000002f) {
            h = (float)Math.sqrt(f) * 3.0f;
            float l = (float)class_3532.method_15349((double)e, (double)d) * 57.295776f - 90.0f;
            float m = class_3532.method_15379((float)(class_3532.method_15393((float)this.method_36454()) - l));
            float f2 = g = 95.0f < m && m < 265.0f ? l - 180.0f : l;
        }
        if (this.handSwingProgress > 0.0f) {
            g = this.method_36454();
        }
        this.method_37908().method_16107().method_15396("headTurn");
        h = this.turnHead(g, h);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("rangeChecks");
        while (this.method_36454() - this.field_5982 < -180.0f) {
            this.field_5982 -= 360.0f;
        }
        while (this.method_36454() - this.field_5982 >= 180.0f) {
            this.field_5982 += 360.0f;
        }
        while (this.bodyYaw - this.prevBodyYaw < -180.0f) {
            this.prevBodyYaw -= 360.0f;
        }
        while (this.bodyYaw - this.prevBodyYaw >= 180.0f) {
            this.prevBodyYaw += 360.0f;
        }
        while (this.method_36455() - this.field_6004 < -180.0f) {
            this.field_6004 -= 360.0f;
        }
        while (this.method_36455() - this.field_6004 >= 180.0f) {
            this.field_6004 += 360.0f;
        }
        while (this.headYaw - this.prevHeadYaw < -180.0f) {
            this.prevHeadYaw -= 360.0f;
        }
        while (this.headYaw - this.prevHeadYaw >= 180.0f) {
            this.prevHeadYaw += 360.0f;
        }
        this.lookDirection += h;
        this.method_37908().method_16107().method_15407();
        this.lookBehavior();
        if (!this.method_37908().method_8608()) {
            class_1297 class_12972;
            if (this.method_24921() != null && (class_12972 = this.method_24921()) instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (!player.method_5805() || player.method_37908() != this.method_37908()) {
                    this.method_31472();
                    return;
                }
                if (player.getCurrentCompanion() == this) {
                    this.handleMovement(player);
                    this.field_6007 = true;
                } else {
                    this.method_31472();
                }
            } else {
                this.method_31472();
            }
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.lookControl.tick();
        this.updateLimbs();
    }

    protected void tickSyncedMovement() {
        if (this.headSteps > 0) {
            this.headYaw += (float)class_3532.method_15338((double)((double)this.serverHeadYaw - (double)this.headYaw)) / (float)this.headSteps;
            --this.headSteps;
        }
        super.tickSyncedMovement();
    }

    public void method_5683(float yaw, int interpolationSteps) {
        this.serverHeadYaw = yaw;
        this.headSteps = interpolationSteps;
    }

    protected void handleMovement(class_1657 owner) {
        double distanceToTarget = this.method_19538().method_1022(owner.method_19538());
        if (distanceToTarget > 20.0) {
            this.method_33574(owner.method_19538());
        }
        if (this.idlingTime++ <= 500) {
            this.method_18799(this.method_18798().method_1021((double)0.8f));
            class_243 getPlayerShoulderPos = this.getTargetPosition(owner, -0.6, 1.0);
            class_243 direction = getPlayerShoulderPos.method_1020(this.method_19538()).method_1029();
            double distance = getPlayerShoulderPos.method_1022(this.method_19538());
            if (distance > 0.5) {
                double multiplier = distance > 2.0 ? 0.05 : 0.025;
                this.method_18799(this.method_18798().method_1019(direction.method_1021(multiplier * distance)));
                this.idlingTime = 0;
            }
        } else if (distanceToTarget > 5.0) {
            this.idlingTime = 0;
        } else {
            this.circleAround((class_1297)owner, 2.5, 0.1);
        }
    }

    protected class_243 getTargetPosition(class_1657 player, double front, double side) {
        class_243 lookDirection = player.method_5720().method_1029();
        float rad = (float)Math.toRadians(player.method_5791());
        double offsetX = front * Math.cos(rad) + side * Math.sin(rad);
        double offsetZ = front * Math.sin(rad) - side * Math.cos(rad);
        return player.method_33571().method_1031(offsetX, 0.0, offsetZ).method_1031(lookDirection.field_1352, 0.0, lookDirection.field_1350);
    }

    public void circleAround(class_1297 entity, double radius, double speed) {
        double angleVariance = 0.01;
        double positionVariance = 0.01;
        double angleIncrement = 0.5 * speed + (Math.random() * angleVariance - angleVariance / 2.0);
        this.orbitArc = (float)((double)this.orbitArc + angleIncrement);
        if ((double)this.orbitArc > Math.PI * 2) {
            this.orbitArc = (float)((double)this.orbitArc - Math.PI * 2);
        }
        double randomRadiusX = radius + (Math.random() * positionVariance - positionVariance / 2.0);
        double randomRadiusZ = radius + (Math.random() * positionVariance - positionVariance / 2.0);
        double targetX = entity.method_23317() + randomRadiusX * Math.cos(this.orbitArc);
        double targetZ = entity.method_23321() + randomRadiusZ * Math.sin(this.orbitArc);
        double targetY = class_3532.method_16436((double)0.1, (double)this.method_23318(), (double)(entity.method_23320() - 0.75));
        class_243 targetPosition = new class_243(targetX, targetY, targetZ);
        this.setVelocityTowards(targetPosition, speed);
        this.getLookControl().lookAt(targetPosition.method_10216(), targetPosition.method_10214(), targetPosition.method_10215());
    }

    public void setVelocityTowards(class_243 targetPosition, double speed) {
        class_243 direction = targetPosition.method_1020(this.method_19538()).method_1029();
        class_243 desiredVelocity = direction.method_1021(speed);
        class_243 currentVelocity = this.method_18798();
        class_243 interpolatedVelocity = currentVelocity.method_35590(desiredVelocity, 0.1);
        this.method_18799(interpolatedVelocity);
    }

    protected void lookBehavior() {
        if (this.idlingTime <= 500) {
            if (this.currentLookBehavior == null || this.currentLookBehavior.isFinished()) {
                this.currentLookBehavior = new LookAroundRandomlyBehavior(this);
                this.currentLookBehavior.start();
            }
            this.currentLookBehavior.tick();
        }
    }

    @Nullable
    public class_1297 method_24921() {
        if (this.owner != null && !this.owner.method_31481()) {
            return this.owner;
        }
        if (this.ownerUuid != null && this.method_37908() instanceof class_3218) {
            this.owner = ((class_3218)this.method_37908()).method_14190(this.ownerUuid);
            return this.owner;
        }
        return null;
    }

    public void setOwner(@Nullable class_1297 entity) {
        if (entity != null) {
            this.ownerUuid = entity.method_5667();
            this.owner = entity;
        }
    }

    protected void method_5693() {
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_25928("Owner")) {
            this.ownerUuid = nbt.method_25926("Owner");
            this.owner = null;
        }
    }

    protected void method_5652(class_2487 nbt) {
        if (this.ownerUuid != null) {
            nbt.method_25927("Owner", this.ownerUuid);
        }
    }

    public NonLivingLookControl getLookControl() {
        return this.lookControl;
    }

    public int getMaxLookYawChange() {
        return 10;
    }

    public int getMaxLookPitchChange() {
        return 40;
    }

    public int getMaxHeadRotation() {
        return 75;
    }
}

