/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.common.entities.base;

import java.util.Optional;
import net.deadlydiamond98.familiar_friends.common.entities.base.MockLivingEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_6035;

public class NonLivingLookControl
implements class_6035 {
    protected final MockLivingEntity entity;
    protected float maxYawChange;
    protected float maxPitchChange;
    protected int lookAtTimer;
    protected double x;
    protected double y;
    protected double z;

    public NonLivingLookControl(MockLivingEntity entity) {
        this.entity = entity;
    }

    public void lookAt(class_243 direction) {
        this.lookAt(direction.field_1352, direction.field_1351, direction.field_1350);
    }

    public void lookAt(class_1297 entity) {
        this.lookAt(entity.method_23317(), NonLivingLookControl.getLookingHeightFor(entity), entity.method_23321());
    }

    public void lookAt(class_1297 entity, float maxYawChange, float maxPitchChange) {
        this.lookAt(entity.method_23317(), NonLivingLookControl.getLookingHeightFor(entity), entity.method_23321(), maxYawChange, maxPitchChange);
    }

    public void lookAt(double x, double y, double z) {
        this.lookAt(x, y, z, this.entity.getMaxLookYawChange(), this.entity.getMaxLookPitchChange());
    }

    public void lookAt(double x, double y, double z, float maxYawChange, float maxPitchChange) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.maxYawChange = maxYawChange;
        this.maxPitchChange = maxPitchChange;
        this.lookAtTimer = 2;
    }

    public void tick() {
        if (this.shouldStayHorizontal()) {
            this.entity.method_36457(0.0f);
        }
        if (this.lookAtTimer > 0) {
            --this.lookAtTimer;
            this.getTargetYaw().ifPresent(targetYaw -> {
                float maxHeadRotation = this.entity.getMaxHeadRotation();
                float headYawDifference = class_3532.method_15381((float)this.entity.bodyYaw, (float)targetYaw.floatValue());
                if (Math.abs(headYawDifference) <= maxHeadRotation) {
                    this.entity.headYaw = this.changeAngle(this.entity.headYaw, targetYaw.floatValue(), this.maxYawChange);
                } else {
                    this.entity.bodyYaw = this.changeAngle(this.entity.bodyYaw, targetYaw.floatValue(), this.maxYawChange);
                    float clampedHeadYaw = class_3532.method_20306((float)targetYaw.floatValue(), (float)this.entity.bodyYaw, (float)maxHeadRotation);
                    this.entity.headYaw = this.changeAngle(this.entity.headYaw, clampedHeadYaw, this.maxYawChange);
                }
            });
            this.getTargetPitch().ifPresent(pitch -> this.entity.method_36457(this.changeAngle(this.entity.method_36455(), pitch.floatValue(), this.maxPitchChange)));
        } else {
            this.entity.headYaw = this.changeAngle(this.entity.headYaw, this.entity.bodyYaw, 10.0f);
        }
        this.clampHeadYaw();
    }

    protected void clampHeadYaw() {
        this.entity.headYaw = class_3532.method_20306((float)this.entity.headYaw, (float)this.entity.bodyYaw, (float)this.entity.getMaxHeadRotation());
    }

    protected boolean shouldStayHorizontal() {
        return true;
    }

    public boolean isLookingAtSpecificPosition() {
        return this.lookAtTimer > 0;
    }

    public double getLookX() {
        return this.x;
    }

    public double getLookY() {
        return this.y;
    }

    public double getLookZ() {
        return this.z;
    }

    protected Optional<Float> getTargetPitch() {
        double d = this.x - this.entity.method_23317();
        double e = this.y - this.entity.method_23320();
        double f = this.z - this.entity.method_23321();
        double g = Math.sqrt(d * d + f * f);
        return !(Math.abs(e) > (double)1.0E-5f) && !(Math.abs(g) > (double)1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(-(class_3532.method_15349((double)e, (double)g) * 57.2957763671875))));
    }

    protected Optional<Float> getTargetYaw() {
        double d = this.x - this.entity.method_23317();
        double e = this.z - this.entity.method_23321();
        return !(Math.abs(e) > (double)1.0E-5f) && !(Math.abs(d) > (double)1.0E-5f) ? Optional.empty() : Optional.of(Float.valueOf((float)(class_3532.method_15349((double)e, (double)d) * 57.2957763671875) - 90.0f));
    }

    protected float changeAngle(float from, float to, float max) {
        float f = class_3532.method_15381((float)from, (float)to);
        float g = class_3532.method_15363((float)f, (float)(-max), (float)max);
        return from + g;
    }

    private static double getLookingHeightFor(class_1297 entity) {
        return entity instanceof class_1309 ? entity.method_23320() : (entity.method_5829().field_1322 + entity.method_5829().field_1325) / 2.0;
    }
}

