/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.client;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.deadlydiamond98.koalalib.KoalaLib;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class PostProcessingRegistry {
    private static final List<class_2960> REGISTRY = new ArrayList<class_2960>();
    private static final Map<class_2960, PostEffect> POST_EFFECTS = new HashMap<class_2960, PostEffect>();

    public static void clear() {
        for (PostEffect postEffect : POST_EFFECTS.values()) {
            postEffect.close();
        }
        POST_EFFECTS.clear();
    }

    public static void registerEffect(class_2960 id) {
        REGISTRY.add(id);
    }

    public static void onInitializeOutline() {
        PostProcessingRegistry.clear();
        class_310 minecraft = class_310.method_1551();
        for (class_2960 id : REGISTRY) {
            class_276 buffer;
            class_279 postProcessor;
            try {
                postProcessor = new class_279(minecraft.method_1531(), minecraft.method_1478(), minecraft.method_1522(), id);
                postProcessor.method_1259(minecraft.method_22683().method_4480(), minecraft.method_22683().method_4507());
                buffer = postProcessor.method_1264("final");
            }
            catch (IOException ioexception) {
                KoalaLib.LOGGER.warn("Failed to load shader: {}", (Object)id, (Object)ioexception);
                postProcessor = null;
                buffer = null;
            }
            catch (JsonSyntaxException jsonsyntaxexception) {
                KoalaLib.LOGGER.warn("Failed to parse shader: {}", (Object)id, (Object)jsonsyntaxexception);
                postProcessor = null;
                buffer = null;
            }
            POST_EFFECTS.put(id, new PostEffect(postProcessor, buffer, false));
        }
    }

    public static void resize(int x, int y) {
        for (PostEffect postEffect : POST_EFFECTS.values()) {
            postEffect.resize(x, y);
        }
    }

    public static class_279 getPostChainFor(class_2960 id) {
        PostEffect effect = POST_EFFECTS.get(id);
        return effect == null ? null : effect.getPostProcessor();
    }

    public static class_276 getRenderTargetFor(class_2960 id) {
        PostEffect effect = POST_EFFECTS.get(id);
        return effect == null ? null : effect.getBuffer();
    }

    public static void renderEffectForNextTick(class_2960 id) {
        PostEffect effect = POST_EFFECTS.get(id);
        if (effect != null) {
            effect.setEnabled(true);
        }
    }

    public static void blitEffects() {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        for (PostEffect postEffect : POST_EFFECTS.values()) {
            if (postEffect.getPostProcessor() == null || !postEffect.isEnabled()) continue;
            postEffect.getBuffer().method_22594(class_310.method_1551().method_22683().method_4480(), class_310.method_1551().method_22683().method_4507(), false);
            postEffect.setEnabled(false);
            postEffect.getBuffer().method_1230(class_310.field_1703);
            class_310.method_1551().method_1522().method_1235(false);
        }
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void copyDepth(class_276 mainTarget) {
        for (PostEffect postEffect : POST_EFFECTS.values()) {
            if (postEffect.getPostProcessor() == null || !postEffect.isEnabled()) continue;
            postEffect.getBuffer().method_1230(class_310.field_1703);
            postEffect.getBuffer().method_29329(mainTarget);
        }
    }

    public static void processEffects(class_276 mainTarget, float f) {
        for (PostEffect postEffect : POST_EFFECTS.values()) {
            if (!postEffect.isEnabled() || postEffect.postProcessor == null) continue;
            postEffect.postProcessor.method_1258(class_310.method_1551().method_1488());
            mainTarget.method_1235(false);
        }
    }

    private static class PostEffect {
        private final class_279 postProcessor;
        private final class_276 buffer;
        private boolean enabled;

        public PostEffect(class_279 postChain, class_276 renderTarget, boolean enabled) {
            this.postProcessor = postChain;
            this.buffer = renderTarget;
            this.enabled = enabled;
        }

        public class_279 getPostProcessor() {
            return this.postProcessor;
        }

        public class_276 getBuffer() {
            return this.buffer;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void close() {
            if (this.postProcessor != null) {
                this.postProcessor.close();
            }
        }

        public void resize(int x, int y) {
            if (this.postProcessor != null) {
                this.postProcessor.method_1259(x, y);
            }
        }
    }
}

