/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.koalalib.common.items.vanillamodified;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.deadlydiamond98.koalalib.util.KoalaNbtHelper;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class CustomBundleItem
extends class_1792 {
    public final Predicate<class_1799> stackPredicate;
    public final boolean insertOnPickup;
    public final int maxStorage;

    public CustomBundleItem(class_1792.class_1793 settings, int maxStorage, boolean insertOnPickup, class_6862<class_1792> acceptedItems) {
        this(settings, maxStorage, insertOnPickup, (class_1799 stack) -> stack.method_31573(acceptedItems));
    }

    public CustomBundleItem(class_1792.class_1793 settings, int maxStorage, boolean insertOnPickup, Predicate<class_1799> stackPredicate) {
        super(settings);
        this.maxStorage = maxStorage;
        this.stackPredicate = stackPredicate;
        this.insertOnPickup = insertOnPickup;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014) {
            class_1799 slotStack = slot.method_7677();
            if (slotStack.method_7960()) {
                class_1799 removedStack = CustomBundleItem.removeFromBundle(stack);
                if (!removedStack.method_7960()) {
                    slot.method_48931(removedStack);
                    this.playRemoveSound((class_1297)player);
                }
            } else if (CustomBundleItem.addToBundle(stack, slotStack)) {
                this.playInsertSound((class_1297)player);
            }
            return true;
        }
        return super.method_31565(stack, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && slot.method_32754(player)) {
            if (otherStack.method_7960()) {
                class_1799 removedStack = CustomBundleItem.removeFromBundle(stack);
                if (!removedStack.method_7960()) {
                    this.playRemoveSound((class_1297)player);
                    cursorStackReference.method_32332(removedStack);
                }
            } else if (CustomBundleItem.addToBundle(stack, otherStack)) {
                this.playInsertSound((class_1297)player);
            }
            return true;
        }
        return false;
    }

    public boolean canInsertOnPickup() {
        return this.insertOnPickup;
    }

    public static boolean addToBundle(class_1799 bundle, class_1799 putStack) {
        CustomBundleItem bundleItem;
        class_1792 class_17922 = bundle.method_7909();
        if (class_17922 instanceof CustomBundleItem && (bundleItem = (CustomBundleItem)class_17922).canInsertItem(bundle, putStack)) {
            List<class_1799> stacks = CustomBundleItem.getItemStacks(bundle);
            int putMax = Math.min(putStack.method_7947(), bundleItem.getMaxInsertables(bundle) / Math.max(1, bundleItem.getItemOccupancy(putStack)));
            if (putMax <= 0) {
                return false;
            }
            for (class_1799 bundleStack : stacks) {
                if (!class_1799.method_31577((class_1799)bundleStack, (class_1799)putStack)) continue;
                bundleStack.method_7933(putMax);
                putStack.method_7934(putMax);
                CustomBundleItem.putItemStacks(bundle, stacks);
                return true;
            }
            if (!putStack.method_7960()) {
                class_1799 putStackCopy = new class_1799((class_1935)putStack.method_7909(), putMax);
                putStackCopy.method_7980(putStack.method_7969());
                stacks.add(putStackCopy);
                putStack.method_7934(putMax);
                CustomBundleItem.putItemStacks(bundle, stacks);
                return true;
            }
        }
        return false;
    }

    public static class_1799 removeFromBundle(class_1799 bundle) {
        class_1799 stack = CustomBundleItem.getFirstStack(bundle);
        return CustomBundleItem.removeFromBundle(bundle, stack, stack.method_7947(), true);
    }

    public static class_1799 removeFromBundle(class_1799 bundle, int count, boolean updateContents) {
        return CustomBundleItem.removeFromBundle(bundle, CustomBundleItem.getFirstStack(bundle), count, updateContents);
    }

    public static class_1799 removeFromBundle(class_1799 bundle, class_1799 getStack, int count, boolean updateContents) {
        count = Math.max(0, Math.min(count, getStack.method_7914()));
        if (bundle.method_7909() instanceof CustomBundleItem) {
            List<class_1799> stacks = CustomBundleItem.getItemStacks(bundle);
            for (class_1799 bundleStack : stacks) {
                if (!class_1799.method_31577((class_1799)bundleStack, (class_1799)getStack) || bundleStack.method_7947() < count) continue;
                class_1799 removedStack = new class_1799((class_1935)bundleStack.method_7909(), count);
                removedStack.method_7980(bundleStack.method_7969());
                bundleStack.method_7934(count);
                if (updateContents) {
                    CustomBundleItem.putItemStacks(bundle, stacks);
                }
                return removedStack;
            }
        }
        return class_1799.field_8037;
    }

    public static class_1799 getFirstStack(class_1799 bundle) {
        List<class_1799> stacks = CustomBundleItem.getItemStacks(bundle);
        if (!stacks.isEmpty()) {
            return stacks.get(0);
        }
        return class_1799.field_8037;
    }

    public static void cycleInventory(class_1799 bundle) {
        CustomBundleItem.cycleInventory(bundle, 1);
    }

    public static void cycleInventory(class_1799 bundle, int shift) {
        List<class_1799> stacks = CustomBundleItem.getItemStacks(bundle);
        Collections.rotate(stacks, shift);
        CustomBundleItem.putItemStacks(bundle, stacks);
    }

    public boolean canInsertItem(class_1799 bundle, class_1799 putStack) {
        if (!this.isFull(bundle) && putStack.method_7909().method_31568() && !(putStack.method_7909() instanceof CustomBundleItem)) {
            return this.stackPredicate != null && this.stackPredicate.test(putStack);
        }
        return false;
    }

    public int getMaxInsertables(class_1799 bundle) {
        return this.maxStorage - this.getOccupancy(bundle);
    }

    public boolean isFull(class_1799 bundle) {
        return this.getOccupancy(bundle) >= this.maxStorage;
    }

    public int getOccupancy(class_1799 bundle) {
        int count = 0;
        for (class_1799 stack : CustomBundleItem.getItemStacks(bundle)) {
            count += Math.min(this.maxStorage, Math.max(this.getItemOccupancy(stack), 1)) * stack.method_7947();
        }
        return count;
    }

    public int getItemOccupancy(class_1799 stack) {
        return 1;
    }

    public static List<class_1799> getItemStacks(class_1799 bundle) {
        class_2499 nbtList = CustomBundleItem.getOrCreateInventory(bundle);
        if (!nbtList.isEmpty()) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_2520 nbt : nbtList) {
                stacks.add(KoalaNbtHelper.largeItemStackFromNBT((class_2487)nbt));
            }
            return stacks;
        }
        return new ArrayList<class_1799>();
    }

    public static void putItemStacks(class_1799 bundle, List<class_1799> stacks) {
        class_2499 nbtList = new class_2499();
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            nbtList.add((Object)KoalaNbtHelper.largeItemStackToNBT(stack));
        }
        CustomBundleItem.putInventory(nbtList, bundle);
    }

    protected static class_2499 getOrCreateInventory(class_1799 bundle) {
        class_2499 inventory = CustomBundleItem.getInventory(bundle);
        if (inventory == null) {
            class_2499 nbtList = new class_2499();
            CustomBundleItem.putInventory(nbtList, bundle);
            return nbtList;
        }
        return inventory;
    }

    @Nullable
    protected static class_2499 getInventory(class_1799 bundle) {
        class_2487 nbtCompound = bundle.method_7948();
        if (nbtCompound.method_10545("Items")) {
            return nbtCompound.method_10554("Items", 10);
        }
        return null;
    }

    protected static void putInventory(class_2499 nbtList, class_1799 bundle) {
        class_2487 nbtCompound = bundle.method_7948();
        nbtCompound.method_10566("Items", (class_2520)nbtList);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{this.getOccupancy(stack), this.maxStorage}).method_27692(class_124.field_1080));
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 bundledItems = class_2371.method_10211();
        bundledItems.addAll(CustomBundleItem.getItemStacks(stack));
        return Optional.of(new class_5631(bundledItems, this.isFull(stack) ? 64 : 0));
    }

    public boolean method_31567(class_1799 stack) {
        return this.getOccupancy(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + 12 * this.getOccupancy(stack) / this.maxStorage, 13);
    }

    public int method_31571(class_1799 stack) {
        return 0x6666FF;
    }

    public void playRemoveSound(class_1297 entity) {
        this.playSound(entity, class_3417.field_34377);
    }

    public void playInsertSound(class_1297 entity) {
        this.playSound(entity, class_3417.field_34376);
    }

    public void playDropContentsSound(class_1297 entity) {
        this.playSound(entity, class_3417.field_34375);
    }

    private void playSound(class_1297 entity, class_3414 sound) {
        entity.method_5783(sound, 0.8f, 0.8f + entity.method_37908().method_8409().method_43057() * 0.4f);
    }
}

