/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectedWoodPanelBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<ConnectionType> CONNECTION = EnumProperty.m_61587_((String)"connection", ConnectionType.class);

    public ConnectedWoodPanelBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(CONNECTION, (Comparable)((Object)ConnectionType.SINGLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTION});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_().m_122424_();
        ConnectionType connection = this.getConnectionType((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), facing);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(CONNECTION, (Comparable)((Object)connection));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        ConnectionType connection = this.getConnectionType(level, pos, facing);
        return (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionType getConnectionType(LevelAccessor level, BlockPos pos, Direction facing) {
        boolean hasBelow;
        BlockState above = level.m_8055_(pos.m_7494_());
        BlockState below = level.m_8055_(pos.m_7495_());
        boolean hasAbove = above.m_60734_() instanceof ConnectedWoodPanelBlock && above.m_61143_((Property)FACING) == facing;
        boolean bl = hasBelow = below.m_60734_() instanceof ConnectedWoodPanelBlock && below.m_61143_((Property)FACING) == facing;
        if (hasAbove && hasBelow) {
            return ConnectionType.MIDDLE;
        }
        if (hasBelow) {
            return ConnectionType.TOP;
        }
        if (hasAbove) {
            return ConnectionType.BOTTOM;
        }
        return ConnectionType.SINGLE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return this.rotateShape(facing, this.makeShape());
    }

    private VoxelShape makeShape() {
        return Block.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    }

    private VoxelShape rotateShape(Direction direction, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = direction.m_122416_() % 4;
        for (int i = 0; i < times; ++i) {
            VoxelShape current = buffer[0];
            buffer[1] = Shapes.m_83040_();
            current.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83113_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
        }
        return buffer[0];
    }

    public static enum ConnectionType implements StringRepresentable
    {
        SINGLE("single"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

