/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampWallHeigh
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty CLICKED = BooleanProperty.m_61465_((String)"clicked");

    public LampWallHeigh(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)CLICKED) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CLICKED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction clickedFace = ctx.m_43719_();
        BlockPos wallPos = ctx.m_8083_().m_121945_(clickedFace.m_122424_());
        Level level = ctx.m_43725_();
        if (clickedFace.m_122434_().m_122479_() && level.m_8055_(wallPos).m_280296_()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clickedFace)).m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            boolean current = (Boolean)state.m_61143_((Property)CLICKED);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(!current)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return this.rotateShape(facing, this.makeShape());
    }

    private VoxelShape rotateShape(Direction direction, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            switch (direction) {
                case EAST: {
                    buffer[1] = Shapes.m_83113_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minZ, (double)minY, (double)(1.0 - maxX), (double)maxZ, (double)maxY, (double)(1.0 - minX)), (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case WEST: {
                    buffer[1] = Shapes.m_83113_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case SOUTH: {
                    buffer[1] = Shapes.m_83113_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ), (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                default: {
                    buffer[1] = Shapes.m_83113_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxX), (double)minY, (double)(1.0 - maxZ), (double)(1.0 - minX), (double)maxY, (double)(1.0 - minZ)), (BooleanOp)BooleanOp.f_82695_);
                }
            }
        });
        return buffer[1];
    }

    private VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.1875, (double)0.0625, (double)0.625, (double)0.25, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.75, (double)0.0625, (double)0.625, (double)0.8125, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.25, (double)0.0625, (double)0.6875, (double)0.75, (double)0.375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }
}

