/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampWallHistoric
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty CLICKED = BooleanProperty.m_61465_((String)"clicked");
    public static final EnumProperty<PlacementHeight> PLACED = EnumProperty.m_61587_((String)"placed", PlacementHeight.class);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_MIDDLE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)3.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)3.0);

    public LampWallHistoric(BlockBehaviour.Properties props) {
        super(props.m_60953_(state -> (Boolean)state.m_61143_((Property)CLICKED) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(false))).m_61124_(PLACED, (Comparable)((Object)PlacementHeight.MIDDLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CLICKED, PLACED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction face = ctx.m_43719_();
        if (face.m_122434_().m_122478_()) {
            return null;
        }
        double yHit = ctx.m_43720_().f_82480_ - (double)ctx.m_8083_().m_123342_();
        PlacementHeight height = yHit < 0.33 ? PlacementHeight.DOWN : (yHit < 0.66 ? PlacementHeight.MIDDLE : PlacementHeight.UP);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face)).m_61124_(PLACED, (Comparable)((Object)height))).m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            boolean cur = (Boolean)state.m_61143_((Property)CLICKED);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(!cur)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static VoxelShape rotateShape(Direction dir, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape};
        int rotations = (dir.m_122416_() + 4) % 4;
        for (int i = 0; i < rotations; ++i) {
            VoxelShape[] newBuffer = new VoxelShape[]{Shapes.m_83040_()};
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                newBuffer[0] = Shapes.m_83110_((VoxelShape)newBuffer[0], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = newBuffer[0];
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        PlacementHeight h = (PlacementHeight)((Object)state.m_61143_(PLACED));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        VoxelShape base = switch (h) {
            default -> throw new IncompatibleClassChangeError();
            case PlacementHeight.UP -> SHAPE_UP;
            case PlacementHeight.MIDDLE -> SHAPE_MIDDLE;
            case PlacementHeight.DOWN -> SHAPE_DOWN;
        };
        return LampWallHistoric.rotateShape(facing, base);
    }

    public static enum PlacementHeight implements StringRepresentable
    {
        DOWN("down"),
        MIDDLE("middle"),
        UP("up");

        private final String id;

        private PlacementHeight(String name) {
            this.id = name;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

