/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LanternBigBlock
extends Block {
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    private static final VoxelShape SHAPE_LOWER = LanternBigBlock.makeLowerShape();
    private static final VoxelShape SHAPE_LOWER_MIDDLE = LanternBigBlock.makeLowerMiddleShape();
    private static final VoxelShape SHAPE_UPPER_MIDDLE = LanternBigBlock.makeUpperMiddleShape();
    private static final VoxelShape SHAPE_UPPER = LanternBigBlock.makeUpperShape();

    private static VoxelShape makeLowerShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.3125, (double)0.375, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeLowerMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeUpperMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeUpperShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.4375, (double)0.0625, (double)0.4375, (double)0.5625, (double)0.75, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.0625, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.375, (double)0.0625, (double)0.375, (double)0.625, (double)0.125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.3125, (double)0.875, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_166049_((double)0.375, (double)0.75, (double)0.375, (double)0.625, (double)0.875, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public LanternBigBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)Part.LOWER)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return switch ((Part)((Object)state.m_61143_(PART))) {
            default -> throw new IncompatibleClassChangeError();
            case Part.LOWER -> SHAPE_LOWER;
            case Part.LOWER_MIDDLE -> SHAPE_LOWER_MIDDLE;
            case Part.UPPER_MIDDLE -> SHAPE_UPPER_MIDDLE;
            case Part.UPPER -> SHAPE_UPPER;
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        for (int i = 0; i < 4; ++i) {
            if (level.m_8055_(pos.m_6630_(i)).m_247087_()) continue;
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.LOWER));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.LOWER)), 3);
        level.m_7731_(pos.m_6630_(1), (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.LOWER_MIDDLE)), 3);
        level.m_7731_(pos.m_6630_(2), (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.UPPER_MIDDLE)), 3);
        level.m_7731_(pos.m_6630_(3), (BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.UPPER)), 3);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos base = pos;
        switch ((Part)((Object)state.m_61143_(PART))) {
            case LOWER_MIDDLE: {
                base = pos.m_6625_(1);
                break;
            }
            case UPPER_MIDDLE: {
                base = pos.m_6625_(2);
                break;
            }
            case UPPER: {
                base = pos.m_6625_(3);
            }
        }
        level.m_5898_(player, 2001, base, Block.m_49956_((BlockState)state));
        for (int i = 0; i < 4; ++i) {
            BlockPos partPos = base.m_6630_(i);
            BlockState s = level.m_8055_(partPos);
            if (s.m_60734_() != this) continue;
            level.m_7731_(partPos, Blocks.f_50016_.m_49966_(), 11);
        }
        if (!player.m_7500_()) {
            LanternBigBlock.m_49840_((Level)level, (BlockPos)base, (ItemStack)new ItemStack((ItemLike)this));
        }
        super.m_5707_(level, pos, state, player);
    }

    public static enum Part implements StringRepresentable
    {
        LOWER("lower"),
        LOWER_MIDDLE("lower_middle"),
        UPPER_MIDDLE("upper_middle"),
        UPPER("upper");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

