/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import java.util.List;
import net.lini.createbuildid.entity.ModEntities;
import net.lini.createbuildid.entity.custom.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaOne
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<CouchPart> PART = EnumProperty.m_61587_((String)"part", CouchPart.class);

    public SofaOne(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)CouchPart.SINGLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_().m_122424_();
        CouchPart part = this.getCouchPart((LevelAccessor)ctx.m_43725_(), ctx.m_8083_(), facing);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)part));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        CouchPart part = this.getCouchPart(level, pos, (Direction)state.m_61143_((Property)FACING));
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)part));
    }

    private CouchPart getCouchPart(LevelAccessor level, BlockPos pos, Direction facing) {
        boolean left = this.isSameSofa(level, pos.m_121945_(facing.m_122428_()), facing);
        boolean right = this.isSameSofa(level, pos.m_121945_(facing.m_122427_()), facing);
        if (left && right) {
            return CouchPart.MIDDLE;
        }
        if (left) {
            return CouchPart.RIGHT;
        }
        if (right) {
            return CouchPart.LEFT;
        }
        return CouchPart.SINGLE;
    }

    private boolean isSameSofa(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof SofaOne && state.m_61143_((Property)FACING) == facing;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            Entity seatEntity = null;
            List chairs = level.m_6443_(SeatEntity.class, new AABB(pos), e -> true);
            if (chairs.isEmpty()) {
                SeatEntity chair = (SeatEntity)((EntityType)ModEntities.SEAT.get()).m_20615_(level);
                if (chair != null) {
                    chair.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.75);
                    level.m_7967_((Entity)chair);
                    seatEntity = chair;
                }
            } else {
                seatEntity = (Entity)chairs.get(0);
            }
            if (seatEntity != null) {
                player.m_20329_(seatEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.rotateShape((Direction)state.m_61143_((Property)FACING), switch ((CouchPart)((Object)state.m_61143_(PART))) {
            case CouchPart.LEFT -> this.makeLeftShape();
            case CouchPart.RIGHT -> this.makeRightShape();
            case CouchPart.MIDDLE -> this.makeMiddleShape();
            default -> this.makeSingleShape();
        });
    }

    private VoxelShape makeSingleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.5625, (double)0.125, (double)1.125, (double)0.75, (double)1.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.125, (double)0.5625, (double)0.125, (double)0.0625, (double)0.75, (double)1.0625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)1.1177, (double)1.1226, (double)0.9375, (double)1.3052, (double)1.2476), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.2917, (double)0.7836, (double)0.9375, (double)0.5417, (double)1.0336), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5417, (double)0.9086, (double)0.9375, (double)0.7917, (double)1.1586), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.7917, (double)0.9711, (double)0.9375, (double)1.0417, (double)1.2211), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makeLeftShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)1.1177, (double)1.1226, (double)1.0, (double)1.3052, (double)1.2476), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.2917, (double)0.7836, (double)1.0, (double)0.5417, (double)1.0336), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5417, (double)0.9086, (double)1.0, (double)0.7917, (double)1.1586), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.7917, (double)0.9711, (double)1.0, (double)1.0417, (double)1.2211), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.125, (double)0.5625, (double)0.125, (double)0.0625, (double)0.75, (double)1.0625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makeRightShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.9375, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)1.1177, (double)1.1226, (double)0.9375, (double)1.3052, (double)1.2476), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.2917, (double)0.7836, (double)0.9375, (double)0.5417, (double)1.0336), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5417, (double)0.9086, (double)0.9375, (double)0.7917, (double)1.1586), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.7917, (double)0.9711, (double)0.9375, (double)1.0417, (double)1.2211), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.5625, (double)0.125, (double)1.125, (double)0.75, (double)1.0625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape makeMiddleShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)1.1177, (double)1.1226, (double)1.0, (double)1.3052, (double)1.2476), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.2917, (double)0.7836, (double)1.0, (double)0.5417, (double)1.0336), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5417, (double)0.9086, (double)1.0, (double)0.7917, (double)1.1586), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.7917, (double)0.9711, (double)1.0, (double)1.0417, (double)1.2211), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private VoxelShape rotateShape(Direction direction, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (direction.m_122416_() + 2) % 4;
        for (int i = 0; i < times; ++i) {
            VoxelShape current = buffer[0];
            buffer[1] = Shapes.m_83040_();
            current.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                VoxelShape rotated = Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX);
                buffer[1] = Shapes.m_83113_((VoxelShape)buffer[1], (VoxelShape)rotated, (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
        }
        return buffer[0];
    }

    public static enum CouchPart implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String name;

        private CouchPart(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

