/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrainLamp
extends Block {
    public static final BooleanProperty CLICKED = BooleanProperty.m_61465_((String)"clicked");
    public static final BooleanProperty BARS = BooleanProperty.m_61465_((String)"bars");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape BASE_SHAPE = TrainLamp.makeBaseShape();

    public TrainLamp(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)BARS, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CLICKED, FACING, BARS});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        if (side == Direction.UP || side == Direction.DOWN) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)side)).m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BARS, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            boolean currentClicked = (Boolean)state.m_61143_((Property)CLICKED);
            BlockState newState = (BlockState)state.m_61124_((Property)CLICKED, (Comparable)Boolean.valueOf(!currentClicked));
            if (player.m_21120_(hand).m_41720_() == Items.f_42025_) {
                boolean currentBars = (Boolean)state.m_61143_((Property)BARS);
                newState = (BlockState)newState.m_61124_((Property)BARS, (Comparable)Boolean.valueOf(!currentBars));
            }
            level.m_7731_(pos, newState, 3);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)CLICKED) != false ? 15 : 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return TrainLamp.rotateShape(BASE_SHAPE, facing);
    }

    private static VoxelShape makeBaseShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.8125, (double)0.0, (double)0.8125, (double)0.875, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.1875, (double)0.0, (double)0.875, (double)0.8125, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.0, (double)0.8125, (double)0.1875, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.625, (double)0.125, (double)0.1875, (double)0.8125, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.5, (double)0.125, (double)0.875, (double)0.625, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.625, (double)0.125, (double)0.875, (double)0.8125, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.125, (double)0.1875, (double)0.625, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.8125, (double)0.125, (double)0.8125, (double)0.875, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.125, (double)0.75, (double)0.75, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.1875, (double)0.6875, (double)0.6875, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction facing) {
        VoxelShape[] rotated = new VoxelShape[]{Shapes.m_83040_()};
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            double nx1 = x1;
            double nz1 = z1;
            double nx2 = x2;
            double nz2 = z2;
            switch (facing) {
                case NORTH: {
                    nx1 = 1.0 - x2;
                    nx2 = 1.0 - x1;
                    nz1 = 1.0 - z2;
                    nz2 = 1.0 - z1;
                    break;
                }
                case EAST: {
                    nx1 = z1;
                    nx2 = z2;
                    nz1 = 1.0 - x2;
                    nz2 = 1.0 - x1;
                    break;
                }
                case WEST: {
                    nx1 = 1.0 - z2;
                    nx2 = 1.0 - z1;
                    nz1 = x1;
                    nz2 = x2;
                    break;
                }
            }
            rotated[0] = Shapes.m_83110_((VoxelShape)rotated[0], (VoxelShape)Shapes.m_83048_((double)nx1, (double)y1, (double)nz1, (double)nx2, (double)y2, (double)nz2));
        });
        return rotated[0];
    }
}

