/*
 * Decompiled with CFR 0.152.
 */
package net.lini.createbuildid.block.custom;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class XStructureBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    private static final Map<Part, VoxelShape> SHAPES = new EnumMap<Part, VoxelShape>(Part.class);

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        Part part = (Part)((Object)state.m_61143_(PART));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return XStructureBlock.rotateShape(SHAPES.get((Object)part), facing);
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction facing) {
        if (facing == Direction.NORTH) {
            return shape;
        }
        int rotations = facing == Direction.EAST ? 1 : (facing == Direction.SOUTH ? 2 : (facing == Direction.WEST ? 3 : 0));
        VoxelShape rotated = shape;
        for (int i = 0; i < rotations; ++i) {
            VoxelShape temp = Shapes.m_83040_();
            for (AABB box : rotated.m_83299_()) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)Shapes.m_83048_((double)(1.0 - box.f_82293_), (double)box.f_82289_, (double)box.f_82288_, (double)(1.0 - box.f_82290_), (double)box.f_82292_, (double)box.f_82291_));
            }
            rotated = temp;
        }
        return rotated;
    }

    public XStructureBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.CENTER)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos[] p;
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction facing = ctx.m_8125_().m_122424_();
        for (BlockPos check : p = this.getStructurePositions(pos, facing)) {
            if (level.m_8055_(check).m_247087_()) continue;
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(PART, (Comparable)((Object)Part.CENTER));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos[] p = this.getStructurePositions(pos, facing);
        this.set(level, p[0], Part.CENTER, facing);
        this.set(level, p[1], Part.CROSS_LEFT, facing);
        this.set(level, p[2], Part.CROSS_CENTER, facing);
        this.set(level, p[3], Part.CROSS_RIGHT, facing);
        this.set(level, p[4], Part.COLUMN_2, facing);
        this.set(level, p[5], Part.COLUMN_3, facing);
        this.set(level, p[6], Part.COLUMN_4, facing);
        this.set(level, p[7], Part.COLUMN_5, facing);
    }

    private void set(Level level, BlockPos pos, Part part, Direction facing) {
        level.m_7731_(pos, (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)part))).m_61124_((Property)FACING, (Comparable)facing), 3);
    }

    private BlockPos[] getStructurePositions(BlockPos origin, Direction facing) {
        BlockPos[] pos = new BlockPos[8];
        Direction right = facing.m_122427_();
        pos[0] = origin;
        pos[4] = origin.m_6630_(1);
        pos[5] = origin.m_6630_(2);
        pos[6] = origin.m_6630_(3);
        pos[1] = origin.m_6630_(4).m_5484_(right, -1);
        pos[2] = origin.m_6630_(4);
        pos[3] = origin.m_6630_(4).m_5484_(right, -2);
        pos[7] = origin.m_6630_(5);
        return pos;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos center = this.findCenter(level, pos, state);
        Direction facing = (Direction)level.m_8055_(center).m_61143_((Property)FACING);
        for (BlockPos partPos : this.getStructurePositions(center, facing)) {
            if (level.m_8055_(partPos).m_60734_() != this) continue;
            level.m_7731_(partPos, Blocks.f_50016_.m_49966_(), 11);
        }
        if (!player.m_7500_()) {
            XStructureBlock.m_49840_((Level)level, (BlockPos)center, (ItemStack)new ItemStack((ItemLike)this));
        }
        super.m_5707_(level, pos, state, player);
    }

    private BlockPos findCenter(Level level, BlockPos pos, BlockState state) {
        BlockPos[] offsets;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        for (BlockPos offset : offsets = this.getStructureOffsets(facing)) {
            BlockPos possibleCenter = pos.m_121996_((Vec3i)offset);
            BlockState s = level.m_8055_(possibleCenter);
            if (s.m_60734_() != this || s.m_61143_(PART) != Part.CENTER) continue;
            boolean valid = true;
            for (BlockPos off : offsets) {
                BlockPos checkPos = possibleCenter.m_121955_((Vec3i)off);
                BlockState st = level.m_8055_(checkPos);
                if (st.m_60734_() == this) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            return possibleCenter;
        }
        return pos;
    }

    private BlockPos[] getStructureOffsets(Direction facing) {
        BlockPos[] offsets = new BlockPos[8];
        Direction right = facing.m_122427_();
        offsets[0] = new BlockPos(0, 0, 0);
        offsets[4] = new BlockPos(0, 1, 0);
        offsets[5] = new BlockPos(0, 2, 0);
        offsets[6] = new BlockPos(0, 3, 0);
        offsets[1] = new BlockPos(right.m_122429_() * -1, 4, right.m_122431_() * -1);
        offsets[2] = new BlockPos(0, 4, 0);
        offsets[3] = new BlockPos(right.m_122429_() * -2, 4, right.m_122431_() * -2);
        offsets[7] = new BlockPos(0, 5, 0);
        return offsets;
    }

    static {
        SHAPES.put(Part.CENTER, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape[])new VoxelShape[0]));
        SHAPES.put(Part.CROSS_LEFT, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0)}));
        SHAPES.put(Part.CROSS_CENTER, Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0)));
        SHAPES.put(Part.CROSS_RIGHT, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)}));
        SHAPES.put(Part.COLUMN_2, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]));
        SHAPES.put(Part.COLUMN_3, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]));
        SHAPES.put(Part.COLUMN_4, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]));
        SHAPES.put(Part.COLUMN_5, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), (VoxelShape[])new VoxelShape[0]));
    }

    public static enum Part implements StringRepresentable
    {
        CENTER,
        CROSS_LEFT,
        CROSS_CENTER,
        CROSS_RIGHT,
        COLUMN_2,
        COLUMN_3,
        COLUMN_4,
        COLUMN_5;

        private final String name = this.name().toLowerCase();

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

