/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.yourname.gayy.ModConfig;
import com.yourname.gayy.SmartZombiesMod;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BloodMoonHandler {
    private static final Random RANDOM = new Random();
    private static final long NORMAL_DAY_LENGTH = 24000L;
    private long nextBloodMoonDay = -1L;
    private boolean isBloodMoonActive = false;
    private long bloodMoonStartTime = 0L;
    private boolean warningMessageSent = false;
    private boolean startMessageSent = false;

    public BloodMoonHandler() {
        this.scheduleNextBloodMoon(0L);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(event.world instanceof ServerWorld)) {
            return;
        }
        if (!ModConfig.ENABLE_BLOOD_MOON) {
            return;
        }
        ServerWorld world = (ServerWorld)event.world;
        long currentDay = world.func_72820_D() / 24000L;
        long timeOfDay = world.func_72820_D() % 24000L;
        if (!this.isBloodMoonActive && currentDay >= this.nextBloodMoonDay) {
            if (!this.warningMessageSent && timeOfDay >= 0L && timeOfDay < 100L) {
                this.sendWarningMessage(world);
                this.warningMessageSent = true;
            }
            if (this.isNightTime(timeOfDay) && !this.startMessageSent) {
                this.startBloodMoon(world);
                this.startMessageSent = true;
            }
        }
        if (this.isBloodMoonActive) {
            long elapsed = world.func_82737_E() - this.bloodMoonStartTime;
            if (elapsed >= (long)ModConfig.BLOOD_MOON_DURATION) {
                this.endBloodMoon(world);
            } else {
                this.updateBloodMoonZombies(world);
                if (elapsed % 2400L == 0L) {
                    this.sendBloodMoonProgressMessage(world, elapsed);
                }
            }
        }
    }

    private void scheduleNextBloodMoon(long currentDay) {
        int daysUntilNext = ModConfig.BLOOD_MOON_MIN_DAYS + RANDOM.nextInt(ModConfig.BLOOD_MOON_MAX_DAYS - ModConfig.BLOOD_MOON_MIN_DAYS + 1);
        this.nextBloodMoonDay = currentDay + (long)daysUntilNext;
        this.warningMessageSent = false;
        this.startMessageSent = false;
        SmartZombiesMod.LOGGER.info("Next Blood Moon scheduled for day {}", (Object)this.nextBloodMoonDay);
    }

    private void startBloodMoon(ServerWorld world) {
        this.isBloodMoonActive = true;
        this.bloodMoonStartTime = world.func_82737_E();
        world.func_241113_a_(0, ModConfig.BLOOD_MOON_DURATION, true, true);
        String message = "\u00a74\u00a7l\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n\u00a74\u00a7l\u2551       BLOOD MOON RISES!       \u2551\n\u00a7c\u00a7l\u2551  The horde is coming for you! \u2551\n\u00a74\u00a7l\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d";
        for (ServerPlayerEntity player : world.func_217369_A()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
            player.func_184185_a(SoundEvents.field_187855_gD, 1.0f, 0.5f);
        }
        SmartZombiesMod.LOGGER.info("\u00a74BLOOD MOON STARTED! Duration: {} ticks", (Object)ModConfig.BLOOD_MOON_DURATION);
    }

    private void endBloodMoon(ServerWorld world) {
        this.isBloodMoonActive = false;
        world.func_241113_a_(6000, 0, false, false);
        String message = "\u00a7a\u00a7l\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n\u00a7a\u00a7l\u2551   The Blood Moon has ended    \u2551\n\u00a72\u00a7l\u2551    You survived... for now    \u2551\n\u00a7a\u00a7l\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d";
        for (ServerPlayerEntity player : world.func_217369_A()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
            player.func_184185_a(SoundEvents.field_194228_if, 1.0f, 1.0f);
        }
        long currentDay = world.func_72820_D() / 24000L;
        this.scheduleNextBloodMoon(currentDay);
        SmartZombiesMod.LOGGER.info("\u00a7aBLOOD MOON ENDED! Next one on day {}", (Object)this.nextBloodMoonDay);
    }

    private void sendWarningMessage(ServerWorld world) {
        int daysLeft = (int)(this.nextBloodMoonDay - world.func_72820_D() / 24000L);
        String message = "\u00a76\u00a7l\u26a0 WARNING \u26a0\n\u00a7c\u00a7lThe air feels heavy...\n\u00a7e\u00a7lA Blood Moon rises tomorrow night!\n\u00a77Prepare yourself for the horde...";
        for (ServerPlayerEntity player : world.func_217369_A()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
            player.func_184185_a(SoundEvents.field_187674_a, 1.0f, 0.5f);
        }
        SmartZombiesMod.LOGGER.info("Blood Moon warning sent! Blood Moon starts tomorrow.");
    }

    private void sendBloodMoonProgressMessage(ServerWorld world, long elapsed) {
        long remaining = (long)ModConfig.BLOOD_MOON_DURATION - elapsed;
        int minutesRemaining = (int)(remaining / 1200L);
        String message = String.format("\u00a7c\u00a7l[BLOOD MOON] \u00a7c%d minutes remaining! Stay alert!", minutesRemaining);
        for (ServerPlayerEntity player : world.func_217369_A()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
        }
    }

    private void updateBloodMoonZombies(ServerWorld world) {
        List zombies = world.func_217357_a(ZombieEntity.class, world.func_175723_af().func_222521_a().func_197752_a());
        for (ZombieEntity zombie : zombies) {
            if (zombie.getPersistentData().func_74767_n("BloodMoonBuffed")) continue;
            if (ModConfig.BLOOD_MOON_SPEED_AMPLIFIER > 0) {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, ModConfig.BLOOD_MOON_SPEED_AMPLIFIER - 1, false, false));
            }
            if (ModConfig.BLOOD_MOON_DAMAGE_AMPLIFIER > 0) {
                zombie.func_195064_c(new EffectInstance(Effects.field_76420_g, Integer.MAX_VALUE, ModConfig.BLOOD_MOON_DAMAGE_AMPLIFIER - 1, false, false));
            }
            zombie.func_184195_f(true);
            zombie.getPersistentData().func_74757_a("BloodMoonBuffed", true);
        }
    }

    private boolean isNightTime(long timeOfDay) {
        return timeOfDay >= 12542L && timeOfDay <= 23459L;
    }

    public static boolean isBloodMoonActive(ServerWorld world) {
        return ((GameRules.BooleanValue)world.func_73046_m().func_241755_D_().func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223572_a();
    }

    public boolean isActive() {
        return this.isBloodMoonActive;
    }

    public long getNextBloodMoonDay() {
        return this.nextBloodMoonDay;
    }

    public void forceStartBloodMoon(ServerWorld world) {
        if (!this.isBloodMoonActive) {
            this.startBloodMoon(world);
        }
    }

    public void forceEndBloodMoon(ServerWorld world) {
        if (this.isBloodMoonActive) {
            this.endBloodMoon(world);
        }
    }

    public void setNextBloodMoonDay(long day) {
        this.nextBloodMoonDay = day;
        this.warningMessageSent = false;
        this.startMessageSent = false;
    }

    public static String getBloodMoonInfo(ServerWorld world, BloodMoonHandler handler) {
        long currentDay = world.func_72820_D() / 24000L;
        if (handler.isBloodMoonActive) {
            long elapsed = world.func_82737_E() - handler.bloodMoonStartTime;
            long remaining = (long)ModConfig.BLOOD_MOON_DURATION - elapsed;
            int minutesRemaining = (int)(remaining / 1200L);
            return String.format("\u00a7c\u00a7lBLOOD MOON ACTIVE! \u00a7c%d minutes remaining", minutesRemaining);
        }
        long daysUntil = handler.nextBloodMoonDay - currentDay;
        return String.format("\u00a7eNext Blood Moon in \u00a76%d days \u00a7e(Day %d)", daysUntil, handler.nextBloodMoonDay);
    }
}

