/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.yourname.gayy.ModConfig;
import com.yourname.gayy.SmartZombiesMod;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DayNightHandler {
    private static final long NORMAL_DAY_LENGTH = 24000L;
    private static final long NIGHT_EXTENSION_PER_CYCLE = 2400L;
    private static final int DAYS_PER_CYCLE = 10;
    private static final int MAX_PROGRESSION_DAY = 50;
    private long lastCheckedDay = -1L;
    private int nightExtensionTicks = 0;
    private boolean messageSent = false;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        long timeOfDay;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(event.world instanceof ServerWorld)) {
            return;
        }
        if (!ModConfig.ENABLE_PROGRESSIVE_NIGHTS) {
            return;
        }
        ServerWorld world = (ServerWorld)event.world;
        long totalTime = world.func_72820_D();
        long currentDay = totalTime / 24000L;
        if (currentDay != this.lastCheckedDay) {
            this.lastCheckedDay = currentDay;
            int oldExtension = this.nightExtensionTicks;
            this.calculateNightExtension(currentDay);
            if (currentDay % 10L == 0L && currentDay > 0L && currentDay <= 50L && this.nightExtensionTicks > oldExtension) {
                this.sendProgressMessage(world, currentDay, this.nightExtensionTicks);
            }
            this.messageSent = false;
        }
        if (this.isNightTime(timeOfDay = world.func_72820_D() % 24000L) && this.nightExtensionTicks > 0) {
            if (!this.messageSent && timeOfDay >= 12542L && timeOfDay <= 12600L) {
                this.sendNightStartMessage(world, currentDay, this.nightExtensionTicks);
                this.messageSent = true;
            }
            this.extendNight(world, timeOfDay);
        }
    }

    private void calculateNightExtension(long currentDay) {
        if (currentDay > 50L) {
            currentDay = 50L;
        }
        int completedCycles = (int)(currentDay / 10L);
        this.nightExtensionTicks = completedCycles * 2400;
    }

    private boolean isNightTime(long timeOfDay) {
        return timeOfDay >= 12542L && timeOfDay <= 23459L;
    }

    private void extendNight(ServerWorld world, long timeOfDay) {
        long ticksToSubtract;
        float slowdownFactor = this.calculateSlowdownFactor();
        if (world.func_82737_E() % 20L == 0L && (ticksToSubtract = (long)(slowdownFactor * 5.0f)) > 0L) {
            world.func_241114_a_(world.func_72820_D() - ticksToSubtract);
        }
    }

    private float calculateSlowdownFactor() {
        if (this.nightExtensionTicks <= 0) {
            return 0.0f;
        }
        float normalNightDuration = 10917.0f;
        float targetNightDuration = normalNightDuration + (float)this.nightExtensionTicks;
        return (targetNightDuration - normalNightDuration) / normalNightDuration;
    }

    private void sendProgressMessage(ServerWorld world, long currentDay, int extensionTicks) {
        String message;
        double extensionMinutes = (double)extensionTicks / 1200.0;
        if (currentDay >= 50L) {
            message = String.format("\u00a7c\u00a7l[NIGHT SYSTEM] \u00a7cDay %d: Night progression MAXED at +%.1f minutes!", currentDay, extensionMinutes);
        } else {
            int daysUntilNext = 10;
            message = String.format("\u00a7e\u00a7l[NIGHT SYSTEM] \u00a7eDay %d: Night is now +%.1f minutes longer! (next increase in %d days)", currentDay, extensionMinutes, daysUntilNext);
        }
        for (ServerPlayerEntity player : world.func_217369_A()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
        }
        SmartZombiesMod.LOGGER.info("Night progression: Day {}, Night is now +{} ticks ({} minutes) longer", (Object)currentDay, (Object)extensionTicks, (Object)extensionMinutes);
    }

    private void sendNightStartMessage(ServerWorld world, long currentDay, int extensionTicks) {
        if (extensionTicks <= 0) {
            return;
        }
        double extensionMinutes = (double)extensionTicks / 1200.0;
        String message = String.format("\u00a76\u00a7l[NIGHT] \u00a76Tonight will be %.1f minutes longer than normal. Prepare yourself!", extensionMinutes);
        for (ServerPlayerEntity player : world.func_217369_A()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
        }
    }

    public static String getProgressInfo(ServerWorld world) {
        long currentDay = world.func_72820_D() / 24000L;
        if (currentDay > 50L) {
            currentDay = 50L;
        }
        int completedCycles = (int)(currentDay / 10L);
        int extensionTicks = completedCycles * 2400;
        double extensionMinutes = (double)extensionTicks / 1200.0;
        int daysUntilNext = 10 - (int)(currentDay % 10L);
        if (currentDay >= 50L) {
            return String.format("\u00a7cDay %d: Night progression MAXED at +%.1f minutes", currentDay, extensionMinutes);
        }
        return String.format("\u00a7eDay %d: Night is +%.1f minutes longer (next increase in %d days)", currentDay, extensionMinutes, daysUntilNext);
    }
}

