/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.mojang.brigadier.CommandDispatcher;
import com.yourname.gayy.BloodMoonHandler;
import com.yourname.gayy.DayNightHandler;
import com.yourname.gayy.ModCommand;
import com.yourname.gayy.ModConfig;
import com.yourname.gayy.PlayerDeathHandler;
import com.yourname.gayy.ZombieAIHandler;
import com.yourname.gayy.ZombieSpawnHandler;
import com.yourname.gayy.ZombieSpecialHandler;
import com.yourname.gayy.ZombieTrapHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="smartzombies")
public class SmartZombiesMod {
    public static final String MOD_ID = "smartzombies";
    public static final Logger LOGGER = LogManager.getLogger();
    private int cleanupTimer = 0;
    public static BloodMoonHandler bloodMoonHandler;

    public SmartZombiesMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ZombieSpawnHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ZombieAIHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerDeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ZombieSpecialHandler());
        MinecraftForge.EVENT_BUS.register((Object)new DayNightHandler());
        bloodMoonHandler = new BloodMoonHandler();
        MinecraftForge.EVENT_BUS.register((Object)bloodMoonHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ZombieTrapHandler());
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Smart Zombies Mod is loading!");
        LOGGER.info("Features: Scout, Healer, Explosive, Trapper zombies and more!");
        LOGGER.info("Progressive night system: Night gets 2 minutes longer every 10 days!");
        LOGGER.info("\u00a74BLOOD MOON SYSTEM: Random hordes every 7-15 days!");
        LOGGER.info("\u00a75TRAPPER ZOMBIES: Watch out for deadly traps!");
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        LOGGER.info("Smart Zombies commands registered!");
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ZombieEntity) {
            ZombieAIHandler.enhanceZombieAI((ZombieEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.cleanupTimer;
            ZombieAIHandler.cleanupOldBlocksGradual(event.world, ModConfig.CLEANUP_BLOCKS_PER_TICK);
            if (this.cleanupTimer >= 1200) {
                this.cleanupTimer = 0;
            }
        }
    }
}

