/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.yourname.gayy.ModConfig;
import com.yourname.gayy.SmartZombiesMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ZombieAIHandler {
    private static final Map<BlockPos, UUID> ZOMBIE_PLACED_BLOCKS = new HashMap<BlockPos, UUID>();
    private static Iterator<Map.Entry<BlockPos, UUID>> cleanupIterator = null;

    public static void enhanceZombieAI(ZombieEntity zombie) {
        zombie.field_70714_bg.func_220888_c().forEach(goal -> zombie.field_70714_bg.func_85156_a(goal.func_220772_j()));
        zombie.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)zombie));
        zombie.field_70714_bg.func_75776_a(1, (Goal)new ZombiePickupItemGoal(zombie));
        if (ModConfig.ENABLE_CLIMBING) {
            zombie.field_70714_bg.func_75776_a(2, (Goal)new ZombieClimbGoal(zombie));
        }
        if (ModConfig.ENABLE_CHEST_BREAKING) {
            zombie.field_70714_bg.func_75776_a(3, (Goal)new ZombieBreakChestGoal(zombie));
        }
        if (ModConfig.ENABLE_TUNNELING) {
            zombie.field_70714_bg.func_75776_a(4, (Goal)new ZombieTunnelingGoal(zombie));
        }
        zombie.field_70714_bg.func_75776_a(5, (Goal)new ZombieBreakBlockGoal(zombie));
        zombie.field_70714_bg.func_75776_a(6, (Goal)new ZombiePlaceBlockGoal(zombie));
        zombie.field_70714_bg.func_75776_a(7, (Goal)new ZombieAttackGoal(zombie, 1.0, false));
        if (ModConfig.ENABLE_MEMORY_SYSTEM) {
            zombie.field_70714_bg.func_75776_a(8, (Goal)new ZombieMemoryGoal(zombie));
        }
        if (ModConfig.ENABLE_SMART_NAVIGATION) {
            zombie.field_70714_bg.func_75776_a(9, (Goal)new ZombieSmartNavigationGoal(zombie));
        }
        zombie.field_70714_bg.func_75776_a(10, (Goal)new LongRangeTargetGoal(zombie, ModConfig.DETECTION_RANGE));
        zombie.field_70714_bg.func_75776_a(11, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)zombie, 1.0));
        zombie.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)zombie, PlayerEntity.class, 8.0f));
        zombie.field_70714_bg.func_75776_a(13, (Goal)new LookRandomlyGoal((MobEntity)zombie));
        zombie.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)zombie, PlayerEntity.class, true));
        if (ModConfig.ENABLE_ANIMAL_ATTACKS) {
            zombie.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)zombie, AnimalEntity.class, true));
        }
    }

    public static void cleanupOldBlocksGradual(World world, int maxBlocksPerTick) {
        if (ZOMBIE_PLACED_BLOCKS.size() > ModConfig.MAX_STORED_BLOCKS) {
            int toRemove = ZOMBIE_PLACED_BLOCKS.size() / 5;
            Iterator<Map.Entry<BlockPos, UUID>> iterator = ZOMBIE_PLACED_BLOCKS.entrySet().iterator();
            for (int i = 0; i < toRemove && iterator.hasNext(); ++i) {
                iterator.next();
                iterator.remove();
            }
        }
        if (cleanupIterator == null || !cleanupIterator.hasNext()) {
            cleanupIterator = ZOMBIE_PLACED_BLOCKS.entrySet().iterator();
        }
        for (int checked = 0; cleanupIterator.hasNext() && checked < maxBlocksPerTick; ++checked) {
            Map.Entry<BlockPos, UUID> entry = cleanupIterator.next();
            BlockPos pos = entry.getKey();
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block == Blocks.field_150346_d || block == Blocks.field_150347_e || block == Blocks.field_150348_b || block == Blocks.field_150351_n || block == Blocks.field_150354_m || block == Blocks.field_196660_k || block == Blocks.field_196662_n || block == Blocks.field_196664_o || block == Blocks.field_196626_Q || block == Blocks.field_150424_aL) continue;
            cleanupIterator.remove();
        }
    }

    public static void cleanupOldBlocks(World world) {
        ZOMBIE_PLACED_BLOCKS.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            Block block = world.func_180495_p(pos).func_177230_c();
            return block != Blocks.field_150346_d && block != Blocks.field_150347_e && block != Blocks.field_150348_b && block != Blocks.field_150351_n && block != Blocks.field_150354_m && block != Blocks.field_196660_k && block != Blocks.field_196662_n && block != Blocks.field_196664_o && block != Blocks.field_196626_Q && block != Blocks.field_150424_aL;
        });
    }

    static class ZombiePlaceBlockGoal
    extends Goal {
        private final ZombieEntity zombie;
        private int placeDelay;
        private int checkDelay;
        private int jumpTicks;
        private boolean hasJumped;
        private int consecutivePlacements;
        private static final Random RANDOM = new Random();
        private static final Block[] PLACEABLE_BLOCKS = new Block[]{Blocks.field_150346_d, Blocks.field_150346_d, Blocks.field_150346_d, Blocks.field_150347_e, Blocks.field_150347_e, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_196660_k, Blocks.field_196662_n, Blocks.field_196664_o, Blocks.field_196626_Q, Blocks.field_150424_aL};

        public ZombiePlaceBlockGoal(ZombieEntity zombie) {
            this.zombie = zombie;
            this.consecutivePlacements = 0;
        }

        public boolean func_75250_a() {
            if (!ModConfig.ENABLE_BLOCK_BUILDING) {
                return false;
            }
            if (this.zombie.func_70638_az() == null) {
                return false;
            }
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            BlockPos targetPos = this.zombie.func_70638_az().func_233580_cy_();
            int heightDiff = targetPos.func_177956_o() - zombiePos.func_177956_o();
            if (ModConfig.ENABLE_HEIGHT_AGGRESSION && heightDiff >= ModConfig.HEIGHT_BUILD_THRESHOLD) {
                return true;
            }
            return targetPos.func_177956_o() > zombiePos.func_177956_o() + 1 || this.hasObstacleInFront();
        }

        public void func_75249_e() {
            this.placeDelay = 0;
            this.checkDelay = 0;
            this.jumpTicks = 0;
            this.hasJumped = false;
            this.consecutivePlacements = 0;
        }

        public void func_75246_d() {
            if (this.zombie.func_70638_az() == null) {
                return;
            }
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            BlockPos targetPos = this.zombie.func_70638_az().func_233580_cy_();
            World world = this.zombie.field_70170_p;
            int heightDiff = targetPos.func_177956_o() - zombiePos.func_177956_o();
            if (this.hasJumped) {
                ++this.jumpTicks;
                if (this.jumpTicks >= 6) {
                    boolean anotherZombieBelow;
                    BlockPos placePos = zombiePos.func_177977_b();
                    if (ModConfig.ENABLE_HEIGHT_AGGRESSION && heightDiff >= 3 && this.consecutivePlacements < 15) {
                        placePos = zombiePos.func_177977_b();
                        ++this.consecutivePlacements;
                    } else if (this.shouldBuildBridge()) {
                        Vector3d lookVec = this.zombie.func_70040_Z();
                        placePos = zombiePos.func_177982_a((int)Math.round(lookVec.field_72450_a), -1, (int)Math.round(lookVec.field_72449_c));
                        this.consecutivePlacements = 0;
                    } else {
                        this.consecutivePlacements = 0;
                    }
                    boolean bl = anotherZombieBelow = world.func_175647_a(ZombieEntity.class, new AxisAlignedBB(placePos), z -> z != this.zombie).size() > 0;
                    if (anotherZombieBelow) {
                        placePos = this.findNearbyPlacePosition(world, zombiePos);
                    }
                    if (placePos != null && !this.anotherZombieBelow(world, placePos, this.zombie) && world.func_180495_p(placePos).func_185904_a() == Material.field_151579_a && ZOMBIE_PLACED_BLOCKS.size() < ModConfig.MAX_STORED_BLOCKS) {
                        Block blockToPlace = PLACEABLE_BLOCKS[RANDOM.nextInt(PLACEABLE_BLOCKS.length)];
                        world.func_180501_a(placePos, blockToPlace.func_176223_P(), 3);
                        ZOMBIE_PLACED_BLOCKS.put(placePos, this.zombie.func_110124_au());
                        if (blockToPlace == Blocks.field_150347_e || blockToPlace == Blocks.field_150348_b) {
                            this.zombie.func_184185_a(SoundEvents.field_187845_fY, 1.0f, 1.0f);
                        } else if (blockToPlace == Blocks.field_150354_m) {
                            this.zombie.func_184185_a(SoundEvents.field_187753_eE, 1.0f, 1.0f);
                        } else if (blockToPlace == Blocks.field_150351_n) {
                            this.zombie.func_184185_a(SoundEvents.field_187587_bZ, 1.0f, 1.0f);
                        } else if (blockToPlace == Blocks.field_196662_n || blockToPlace == Blocks.field_196664_o || blockToPlace == Blocks.field_196626_Q) {
                            this.zombie.func_184185_a(SoundEvents.field_187891_gV, 1.0f, 1.0f);
                        } else if (blockToPlace == Blocks.field_150424_aL) {
                            this.zombie.func_184185_a(SoundEvents.field_232782_jm_, 1.0f, 1.0f);
                        } else {
                            this.zombie.func_184185_a(SoundEvents.field_187587_bZ, 1.0f, 1.0f);
                        }
                    }
                    this.hasJumped = false;
                    this.jumpTicks = 0;
                    this.placeDelay = 0;
                }
                return;
            }
            ++this.checkDelay;
            if (this.checkDelay < 20) {
                return;
            }
            this.checkDelay = 0;
            if (!this.zombie.func_233570_aj_()) {
                return;
            }
            Vector3d lookVec = this.zombie.func_70040_Z();
            BlockPos frontPos = zombiePos.func_177982_a((int)Math.round(lookVec.field_72450_a), 0, (int)Math.round(lookVec.field_72449_c));
            BlockPos frontPosAbove = frontPos.func_177984_a();
            boolean wallInFront = world.func_180495_p(frontPos).func_185904_a().func_76220_a() || world.func_180495_p(frontPosAbove).func_185904_a().func_76220_a();
            boolean shouldBuild = false;
            if (ModConfig.ENABLE_HEIGHT_AGGRESSION && heightDiff >= ModConfig.HEIGHT_BUILD_THRESHOLD) {
                shouldBuild = true;
            } else if (wallInFront || this.shouldBuildBridge()) {
                boolean bl = shouldBuild = targetPos.func_177956_o() >= zombiePos.func_177956_o();
            }
            if (shouldBuild) {
                ++this.placeDelay;
                int requiredDelay = ModConfig.PLACE_DELAY;
                if (ModConfig.ENABLE_HEIGHT_AGGRESSION && heightDiff >= ModConfig.HEIGHT_SPEED_BOOST_THRESHOLD) {
                    requiredDelay = Math.max(1, ModConfig.PLACE_DELAY - 2);
                }
                if (this.placeDelay >= requiredDelay) {
                    this.zombie.func_213293_j(this.zombie.func_213322_ci().field_72450_a, 0.42, this.zombie.func_213322_ci().field_72449_c);
                    this.hasJumped = true;
                    this.jumpTicks = 0;
                    this.placeDelay = 0;
                }
            } else {
                this.placeDelay = 0;
                this.consecutivePlacements = 0;
            }
        }

        private boolean shouldBuildBridge() {
            if (this.zombie.func_70638_az() == null) {
                return false;
            }
            World world = this.zombie.field_70170_p;
            Vector3d lookVec = this.zombie.func_70040_Z();
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            BlockPos checkPos = zombiePos.func_177982_a((int)Math.round(lookVec.field_72450_a * 2.0), -1, (int)Math.round(lookVec.field_72449_c * 2.0));
            return world.func_180495_p(checkPos).func_185904_a() == Material.field_151579_a;
        }

        private boolean hasObstacleInFront() {
            World world = this.zombie.field_70170_p;
            Vector3d lookVec = this.zombie.func_70040_Z();
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            BlockPos frontPos = zombiePos.func_177982_a((int)Math.round(lookVec.field_72450_a), 0, (int)Math.round(lookVec.field_72449_c));
            return world.func_180495_p(frontPos).func_185904_a().func_76220_a();
        }

        private BlockPos findNearbyPlacePosition(World world, BlockPos center) {
            int radius = ModConfig.CROWD_BUILD_RADIUS;
            for (int r = 1; r <= radius; ++r) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        BlockPos testPos;
                        if (Math.abs(x) != r && Math.abs(z) != r || world.func_180495_p(testPos = center.func_177982_a(x, -1, z)).func_185904_a() != Material.field_151579_a || this.anotherZombieBelow(world, testPos, this.zombie)) continue;
                        return testPos;
                    }
                }
            }
            return null;
        }

        private boolean anotherZombieBelow(World world, BlockPos pos, ZombieEntity exclude) {
            return world.func_175647_a(ZombieEntity.class, new AxisAlignedBB(pos), z -> z != exclude).size() > 0;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || this.hasJumped;
        }
    }

    static class ZombieTunnelingGoal
    extends Goal {
        private final ZombieEntity zombie;
        private BlockPos tunnelTarget;
        private int breakProgress;
        private List<BlockPos> tunnelPath;
        private int currentPathIndex;
        private int checkDelay;
        private static final int CHECK_INTERVAL = 60;

        public ZombieTunnelingGoal(ZombieEntity zombie) {
            this.zombie = zombie;
            this.checkDelay = 0;
        }

        public boolean func_75250_a() {
            BlockPos targetPos;
            ++this.checkDelay;
            if (this.checkDelay < 60) {
                return false;
            }
            this.checkDelay = 0;
            if (this.zombie.func_70638_az() == null) {
                return false;
            }
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            double distance = zombiePos.func_177951_i((Vector3i)(targetPos = this.zombie.func_70638_az().func_233580_cy_()));
            if (distance > ModConfig.TUNNEL_MAX_DISTANCE * ModConfig.TUNNEL_MAX_DISTANCE) {
                return false;
            }
            int heightDiff = Math.abs(targetPos.func_177956_o() - zombiePos.func_177956_o());
            if (heightDiff >= ModConfig.TUNNEL_HEIGHT_DIFFERENCE || this.isPathBlocked(zombiePos, targetPos)) {
                this.tunnelPath = this.calculateTunnelPath(zombiePos, targetPos);
                if (this.tunnelPath != null && !this.tunnelPath.isEmpty()) {
                    this.currentPathIndex = 0;
                    this.tunnelTarget = this.tunnelPath.get(0);
                    return true;
                }
            }
            return false;
        }

        public void func_75249_e() {
            this.breakProgress = 0;
        }

        public void func_75246_d() {
            if (this.zombie.func_70638_az() == null) {
                return;
            }
            if (this.tunnelTarget == null || this.tunnelPath == null) {
                return;
            }
            World world = this.zombie.field_70170_p;
            this.zombie.func_70671_ap().func_220679_a((double)this.tunnelTarget.func_177958_n() + 0.5, (double)this.tunnelTarget.func_177956_o() + 0.5, (double)this.tunnelTarget.func_177952_p() + 0.5);
            if (this.zombie.func_70092_e((double)this.tunnelTarget.func_177958_n(), (double)this.tunnelTarget.func_177956_o(), (double)this.tunnelTarget.func_177952_p()) < 9.0) {
                Block block = world.func_180495_p(this.tunnelTarget).func_177230_c();
                if (ModConfig.TUNNEL_AVOID_LAVA && block == Blocks.field_150353_l) {
                    this.tunnelTarget = null;
                    this.tunnelPath = null;
                    return;
                }
                if (this.canTunnelThrough(block) && !this.isZombiePlacedBlock(this.tunnelTarget)) {
                    ++this.breakProgress;
                    if (this.breakProgress % 10 == 0) {
                        this.zombie.func_184185_a(SoundEvents.field_187927_ha, 0.5f, 0.8f);
                    }
                    if (this.breakProgress > ModConfig.TUNNEL_BREAK_TIME) {
                        BlockPos torchPos;
                        world.func_175655_b(this.tunnelTarget, true);
                        this.zombie.func_184185_a(SoundEvents.field_187835_fT, 1.0f, 1.0f);
                        if (ModConfig.TUNNEL_PLACE_TORCHES && new Random().nextInt(5) == 0 && world.func_180495_p(torchPos = this.tunnelTarget.func_177982_a(0, 0, 1)).func_185904_a() == Material.field_151579_a) {
                            world.func_180501_a(torchPos, Blocks.field_150478_aa.func_176223_P(), 3);
                        }
                        this.breakProgress = 0;
                        ++this.currentPathIndex;
                        if (this.currentPathIndex < this.tunnelPath.size()) {
                            this.tunnelTarget = this.tunnelPath.get(this.currentPathIndex);
                        } else {
                            this.tunnelTarget = null;
                            this.tunnelPath = null;
                        }
                    }
                } else {
                    this.breakProgress = 0;
                    ++this.currentPathIndex;
                    if (this.currentPathIndex < this.tunnelPath.size()) {
                        this.tunnelTarget = this.tunnelPath.get(this.currentPathIndex);
                    } else {
                        this.tunnelTarget = null;
                        this.tunnelPath = null;
                    }
                }
            }
        }

        private List<BlockPos> calculateTunnelPath(BlockPos start, BlockPos end) {
            int dz;
            int dy;
            ArrayList<BlockPos> path = new ArrayList<BlockPos>();
            World world = this.zombie.field_70170_p;
            int dx = end.func_177958_n() - start.func_177958_n();
            double distance = Math.sqrt(dx * dx + (dy = end.func_177956_o() - start.func_177956_o()) * dy + (dz = end.func_177952_p() - start.func_177952_p()) * dz);
            if (distance == 0.0) {
                return null;
            }
            double stepX = (double)dx / distance;
            double stepY = (double)dy / distance;
            double stepZ = (double)dz / distance;
            for (int i = 1; i <= 20 && (double)i < distance; ++i) {
                int z;
                int y;
                int x = start.func_177958_n() + (int)(stepX * (double)i);
                BlockPos pos = new BlockPos(x, y = start.func_177956_o() + (int)(stepY * (double)i), z = start.func_177952_p() + (int)(stepZ * (double)i));
                Block block = world.func_180495_p(pos).func_177230_c();
                if (!block.func_176223_P().func_185904_a().func_76220_a() || !this.canTunnelThrough(block)) continue;
                path.add(pos);
                BlockPos above = pos.func_177984_a();
                if (!world.func_180495_p(above).func_185904_a().func_76220_a()) continue;
                path.add(above);
            }
            return path.isEmpty() ? null : path;
        }

        private boolean isPathBlocked(BlockPos start, BlockPos end) {
            World world = this.zombie.field_70170_p;
            int solidBlocks = 0;
            int totalChecks = 0;
            double dx = end.func_177958_n() - start.func_177958_n();
            double dy = end.func_177956_o() - start.func_177956_o();
            double dz = end.func_177952_p() - start.func_177952_p();
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            for (double i = 0.0; i < dist; i += 1.0) {
                int z;
                int y;
                double ratio = i / dist;
                int x = (int)((double)start.func_177958_n() + dx * ratio);
                BlockPos checkPos = new BlockPos(x, y = (int)((double)start.func_177956_o() + dy * ratio), z = (int)((double)start.func_177952_p() + dz * ratio));
                if (world.func_180495_p(checkPos).func_185904_a().func_76220_a()) {
                    ++solidBlocks;
                }
                ++totalChecks;
            }
            return (double)solidBlocks > (double)totalChecks * 0.3;
        }

        private boolean canTunnelThrough(Block block) {
            return block != Blocks.field_150357_h && block != Blocks.field_150384_bq && block != Blocks.field_150378_br && block != Blocks.field_150483_bI && block != Blocks.field_180401_cv && block != Blocks.field_150350_a && block != Blocks.field_150355_j;
        }

        private boolean isZombiePlacedBlock(BlockPos pos) {
            return ZOMBIE_PLACED_BLOCKS.containsKey(pos);
        }

        public boolean func_75253_b() {
            return this.tunnelTarget != null && this.zombie.func_70638_az() != null;
        }
    }

    static class ZombieBreakChestGoal
    extends Goal {
        private final ZombieEntity zombie;
        private BlockPos targetChest;
        private int breakProgress;
        private int searchDelay;
        private static final int SEARCH_INTERVAL = 100;
        private static final Random RANDOM = new Random();

        public ZombieBreakChestGoal(ZombieEntity zombie) {
            this.zombie = zombie;
            this.searchDelay = 0;
        }

        public boolean func_75250_a() {
            ++this.searchDelay;
            if (this.searchDelay < 100) {
                return false;
            }
            this.searchDelay = 0;
            this.targetChest = this.findNearbyChest();
            if (this.targetChest != null) {
                this.zombie.func_184185_a(SoundEvents.field_187899_gZ, 0.5f, 1.5f);
                return true;
            }
            return false;
        }

        public void func_75249_e() {
            this.breakProgress = 0;
        }

        public void func_75246_d() {
            if (this.targetChest == null) {
                return;
            }
            this.zombie.func_70671_ap().func_220679_a((double)this.targetChest.func_177958_n() + 0.5, (double)this.targetChest.func_177956_o() + 0.5, (double)this.targetChest.func_177952_p() + 0.5);
            this.zombie.func_70661_as().func_75492_a((double)this.targetChest.func_177958_n() + 0.5, (double)this.targetChest.func_177956_o(), (double)this.targetChest.func_177952_p() + 0.5, 1.0);
            double distance = this.zombie.func_70092_e((double)this.targetChest.func_177958_n() + 0.5, (double)this.targetChest.func_177956_o(), (double)this.targetChest.func_177952_p() + 0.5);
            if (distance < 9.0) {
                ++this.breakProgress;
                if (this.breakProgress % 10 == 0) {
                    this.zombie.func_184185_a(SoundEvents.field_187927_ha, 0.5f, 1.0f);
                }
                if (this.breakProgress > ModConfig.CHEST_BREAK_TIME) {
                    World world = this.zombie.field_70170_p;
                    Block block = world.func_180495_p(this.targetChest).func_177230_c();
                    if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_222422_lK) {
                        ChestTileEntity chest;
                        if (world.func_175625_s(this.targetChest) instanceof ChestTileEntity && (chest = (ChestTileEntity)world.func_175625_s(this.targetChest)) != null && RANDOM.nextDouble() < ModConfig.CHEST_EQUIP_CHANCE) {
                            this.equipFromChest(chest);
                        }
                        world.func_175655_b(this.targetChest, true);
                        this.zombie.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, 1.0f);
                        SmartZombiesMod.LOGGER.info("Zombie broke chest at {}", (Object)this.targetChest);
                    }
                    this.breakProgress = 0;
                    this.targetChest = null;
                }
            }
        }

        private BlockPos findNearbyChest() {
            World world = this.zombie.field_70170_p;
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            int range = (int)ModConfig.CHEST_SEARCH_RANGE;
            for (int x = -range; x <= range; ++x) {
                for (int y = -3; y <= 3; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = zombiePos.func_177982_a(x, y, z);
                        Block block = world.func_180495_p(pos).func_177230_c();
                        if (block != Blocks.field_150486_ae && block != Blocks.field_150447_bR && block != Blocks.field_222422_lK) continue;
                        if (world.func_175625_s(pos) instanceof ChestTileEntity) {
                            ChestTileEntity chest = (ChestTileEntity)world.func_175625_s(pos);
                            if (chest == null || this.isChestEmpty(chest)) continue;
                            SmartZombiesMod.LOGGER.info("Zombie found chest at {}", (Object)pos);
                            return pos;
                        }
                        return pos;
                    }
                }
            }
            return null;
        }

        private boolean isChestEmpty(ChestTileEntity chest) {
            for (int i = 0; i < chest.func_70302_i_(); ++i) {
                if (chest.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        private void equipFromChest(ChestTileEntity chest) {
            ItemStack stack;
            int i;
            for (i = 0; i < chest.func_70302_i_(); ++i) {
                stack = chest.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof SwordItem) && !(stack.func_77973_b() instanceof AxeItem) && !(stack.func_77973_b() instanceof PickaxeItem) && !(stack.func_77973_b() instanceof ShovelItem)) continue;
                this.zombie.func_184201_a(EquipmentSlotType.MAINHAND, stack.func_77946_l());
                chest.func_70299_a(i, ItemStack.field_190927_a);
                this.zombie.func_184185_a(SoundEvents.field_187725_r, 1.0f, 1.0f);
                SmartZombiesMod.LOGGER.info("Zombie equipped weapon from chest");
                return;
            }
            for (i = 0; i < chest.func_70302_i_(); ++i) {
                stack = chest.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArmorItem)) continue;
                ArmorItem armor = (ArmorItem)stack.func_77973_b();
                this.zombie.func_184201_a(armor.func_185083_B_(), stack.func_77946_l());
                chest.func_70299_a(i, ItemStack.field_190927_a);
                this.zombie.func_184185_a(SoundEvents.field_187725_r, 1.0f, 1.0f);
                SmartZombiesMod.LOGGER.info("Zombie equipped armor from chest");
                return;
            }
        }

        public boolean func_75253_b() {
            return this.targetChest != null && this.zombie.field_70170_p.func_180495_p(this.targetChest).func_177230_c() != Blocks.field_150350_a;
        }
    }

    static class ZombieBreakBlockGoal
    extends Goal {
        private final ZombieEntity zombie;
        private BlockPos targetPos;
        private int breakProgress;

        public ZombieBreakBlockGoal(ZombieEntity zombie) {
            this.zombie = zombie;
        }

        public boolean func_75250_a() {
            BlockPos targetPos;
            if (this.zombie.func_70638_az() == null) {
                return false;
            }
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            double distance = zombiePos.func_177951_i((Vector3i)(targetPos = this.zombie.func_70638_az().func_233580_cy_()));
            if (distance > 100.0) {
                return false;
            }
            this.targetPos = this.findBlockToBreak(zombiePos, targetPos);
            return this.targetPos != null;
        }

        public void func_75246_d() {
            if (this.zombie.func_70638_az() == null) {
                return;
            }
            if (this.targetPos != null) {
                this.zombie.func_70671_ap().func_220679_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p());
                if (this.zombie.func_70092_e((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p()) < 4.0) {
                    ++this.breakProgress;
                    if (this.breakProgress > ModConfig.BREAK_TIME) {
                        World world = this.zombie.field_70170_p;
                        Block block = world.func_180495_p(this.targetPos).func_177230_c();
                        if (this.canBreak(block) && !this.isZombiePlacedBlock(this.targetPos)) {
                            world.func_175655_b(this.targetPos, true);
                            this.zombie.func_184185_a(SoundEvents.field_187929_hc, 1.0f, 1.0f);
                        }
                        this.breakProgress = 0;
                        this.targetPos = null;
                    }
                }
            }
        }

        private BlockPos findBlockToBreak(BlockPos start, BlockPos target) {
            BlockPos pos;
            Block block;
            int z;
            int y;
            int x;
            World world = this.zombie.field_70170_p;
            for (x = -1; x <= 1; ++x) {
                for (y = 0; y <= 2; ++y) {
                    for (z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0 || !this.canBreak(block = world.func_180495_p(pos = start.func_177982_a(x, y, z)).func_177230_c()) || this.isZombiePlacedBlock(pos) || y > 1) continue;
                        return pos;
                    }
                }
            }
            for (x = -2; x <= 2; ++x) {
                for (y = -1; y <= 2; ++y) {
                    for (z = -2; z <= 2; ++z) {
                        pos = start.func_177982_a(x, y, z);
                        block = world.func_180495_p(pos).func_177230_c();
                        if (!this.canBreak(block) || !this.isBlockingPath(pos, start, target) || this.isZombiePlacedBlock(pos)) continue;
                        return pos;
                    }
                }
            }
            return null;
        }

        private boolean canBreak(Block block) {
            return block == Blocks.field_180413_ao || block == Blocks.field_180414_ap || block == Blocks.field_180412_aq || block == Blocks.field_180411_ar || block == Blocks.field_180410_as || block == Blocks.field_180409_at || block == Blocks.field_196662_n || block == Blocks.field_196664_o || block == Blocks.field_196666_p || block == Blocks.field_196668_q || block == Blocks.field_196670_r || block == Blocks.field_196672_s || block == Blocks.field_150347_e || block == Blocks.field_150348_b || block == Blocks.field_150341_Y || block == Blocks.field_196698_dj || block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_196807_gj || block == Blocks.field_196808_gk || block == Blocks.field_196809_gl || block == Blocks.field_196810_gm || block == Blocks.field_196811_gn || block == Blocks.field_196812_go || block == Blocks.field_196813_gp || block == Blocks.field_196815_gq || block == Blocks.field_196816_gr || block == Blocks.field_196818_gs || block == Blocks.field_196819_gt || block == Blocks.field_196820_gu || block == Blocks.field_196821_gv || block == Blocks.field_196822_gw || block == Blocks.field_196823_gx || block == Blocks.field_196824_gy || block == Blocks.field_196617_K || block == Blocks.field_196618_L || block == Blocks.field_196619_M || block == Blocks.field_196620_N || block == Blocks.field_196621_O || block == Blocks.field_196623_P || block == Blocks.field_196626_Q || block == Blocks.field_196629_R || block == Blocks.field_196631_S || block == Blocks.field_196634_T || block == Blocks.field_196637_U || block == Blocks.field_196639_V;
        }

        private boolean isBlockingPath(BlockPos pos, BlockPos start, BlockPos target) {
            return pos.func_177951_i((Vector3i)start) < pos.func_177951_i((Vector3i)target);
        }

        private boolean isZombiePlacedBlock(BlockPos pos) {
            return ZOMBIE_PLACED_BLOCKS.containsKey(pos);
        }
    }

    static class LongRangeTargetGoal
    extends Goal {
        private final ZombieEntity zombie;
        private final double range;
        private int retargetDelay;
        private static final int RETARGET_INTERVAL = 80;

        public LongRangeTargetGoal(ZombieEntity zombie, double range) {
            this.zombie = zombie;
            this.range = range;
            this.retargetDelay = 0;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ++this.retargetDelay;
            if (this.retargetDelay < 80) {
                return;
            }
            this.retargetDelay = 0;
            World world = this.zombie.field_70170_p;
            if (ModConfig.ALWAYS_SEE_PLAYER) {
                List allPlayers = world.func_175647_a(PlayerEntity.class, this.zombie.func_174813_aQ().func_186662_g(256.0), player -> !player.func_184812_l_() && !player.func_175149_v());
                PlayerEntity closestPlayer = null;
                double closestDistance = Double.MAX_VALUE;
                for (PlayerEntity player2 : allPlayers) {
                    double distance = this.zombie.func_70032_d((Entity)player2);
                    if (!(distance < closestDistance)) continue;
                    closestDistance = distance;
                    closestPlayer = player2;
                }
                if (closestPlayer != null) {
                    this.zombie.func_70624_b(closestPlayer);
                }
                return;
            }
            List players = world.func_175647_a(PlayerEntity.class, this.zombie.func_174813_aQ().func_186662_g(this.range), player -> !player.func_184812_l_() && !player.func_175149_v());
            PlayerEntity closestPlayer = null;
            double closestDistance = Double.MAX_VALUE;
            for (PlayerEntity player3 : players) {
                double distance = this.zombie.func_70032_d((Entity)player3);
                if (distance <= this.range && this.hasLineOfSight(this.zombie, player3) && distance < closestDistance) {
                    closestDistance = distance;
                    closestPlayer = player3;
                }
                if (!(distance <= ModConfig.SOUND_DETECTION_RANGE) || !player3.func_70051_ag() && !player3.func_184587_cr() || !(distance < closestDistance)) continue;
                closestDistance = distance;
                closestPlayer = player3;
            }
            if (closestPlayer != null) {
                this.zombie.func_70624_b(closestPlayer);
            }
        }

        private boolean hasLineOfSight(ZombieEntity zombie, PlayerEntity player) {
            BlockPos zombiePos = zombie.func_233580_cy_();
            BlockPos playerPos = player.func_233580_cy_();
            int checksCount = 0;
            int solidBlocks = 0;
            double dx = playerPos.func_177958_n() - zombiePos.func_177958_n();
            double dy = playerPos.func_177956_o() - zombiePos.func_177956_o();
            double dz = playerPos.func_177952_p() - zombiePos.func_177952_p();
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            for (double i = 0.0; i < distance; i += 2.0) {
                int z;
                int y;
                double ratio = i / distance;
                int x = (int)((double)zombiePos.func_177958_n() + dx * ratio);
                BlockPos checkPos = new BlockPos(x, y = (int)((double)zombiePos.func_177956_o() + dy * ratio + 1.0), z = (int)((double)zombiePos.func_177952_p() + dz * ratio));
                if (!zombie.field_70170_p.func_180495_p(checkPos).func_185904_a().func_76220_a()) {
                    ++checksCount;
                    continue;
                }
                ++solidBlocks;
            }
            return checksCount > 0 && (double)solidBlocks < (double)checksCount * 0.3;
        }
    }

    static class ZombieSmartNavigationGoal
    extends Goal {
        private final ZombieEntity zombie;
        private BlockPos lastPosition;
        private int stuckTimer;
        private int retryTimer;

        public ZombieSmartNavigationGoal(ZombieEntity zombie) {
            this.zombie = zombie;
            this.lastPosition = zombie.func_233580_cy_();
        }

        public boolean func_75250_a() {
            return this.zombie.func_70638_az() != null;
        }

        public void func_75246_d() {
            ++this.stuckTimer;
            if (this.stuckTimer >= ModConfig.STUCK_CHECK_DELAY) {
                BlockPos currentPos = this.zombie.func_233580_cy_();
                double distanceMoved = currentPos.func_177951_i((Vector3i)this.lastPosition);
                if (distanceMoved < ModConfig.STUCK_DISTANCE_THRESHOLD) {
                    ++this.retryTimer;
                    if (this.zombie.func_233570_aj_() && this.retryTimer % 20 == 0) {
                        this.zombie.func_213293_j(this.zombie.func_213322_ci().field_72450_a, 0.42, this.zombie.func_213322_ci().field_72449_c);
                    }
                    if (this.retryTimer > ModConfig.PATHFINDING_RETRY_DELAY) {
                        BlockPos[] offsets;
                        if (this.zombie.func_70638_az() == null) {
                            this.retryTimer = 0;
                            return;
                        }
                        BlockPos targetPos = this.zombie.func_70638_az().func_233580_cy_();
                        for (BlockPos offset : offsets = new BlockPos[]{targetPos.func_177982_a(2, 0, 0), targetPos.func_177982_a(-2, 0, 0), targetPos.func_177982_a(0, 0, 2), targetPos.func_177982_a(0, 0, -2)}) {
                            if (this.zombie.func_70661_as().func_75492_a((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), 1.0)) break;
                        }
                        this.retryTimer = 0;
                    }
                } else {
                    this.retryTimer = 0;
                }
                this.lastPosition = currentPos;
                this.stuckTimer = 0;
            }
        }
    }

    static class ZombieMemoryGoal
    extends Goal {
        private final ZombieEntity zombie;
        private BlockPos lastKnownPosition;
        private int memoryTimer;
        private int searchTimer;

        public ZombieMemoryGoal(ZombieEntity zombie) {
            this.zombie = zombie;
        }

        public boolean func_75250_a() {
            return this.zombie.func_70638_az() == null && this.lastKnownPosition != null && this.memoryTimer > 0;
        }

        public void func_75249_e() {
            this.searchTimer = 0;
        }

        public void func_75246_d() {
            --this.memoryTimer;
            ++this.searchTimer;
            if (this.memoryTimer <= 0) {
                this.lastKnownPosition = null;
                return;
            }
            if (this.searchTimer % 20 == 0) {
                List nearbyPlayers;
                this.zombie.func_70661_as().func_75492_a((double)this.lastKnownPosition.func_177958_n(), (double)this.lastKnownPosition.func_177956_o(), (double)this.lastKnownPosition.func_177952_p(), 1.0);
                double distance = this.zombie.func_213303_ch().func_72438_d(new Vector3d((double)this.lastKnownPosition.func_177958_n(), (double)this.lastKnownPosition.func_177956_o(), (double)this.lastKnownPosition.func_177952_p()));
                if (distance < ModConfig.MEMORY_SEARCH_RADIUS && !(nearbyPlayers = this.zombie.field_70170_p.func_175647_a(PlayerEntity.class, this.zombie.func_174813_aQ().func_186662_g(ModConfig.MEMORY_SEARCH_RADIUS), p -> !p.func_184812_l_() && !p.func_175149_v())).isEmpty()) {
                    this.zombie.func_70624_b((LivingEntity)nearbyPlayers.get(0));
                    this.lastKnownPosition = null;
                    this.memoryTimer = 0;
                }
            }
        }

        public void rememberPosition(BlockPos pos) {
            this.lastKnownPosition = pos;
            this.memoryTimer = ModConfig.MEMORY_DURATION;
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }
    }

    static class ZombieClimbGoal
    extends Goal {
        private final ZombieEntity zombie;
        private int checkDelay;

        public ZombieClimbGoal(ZombieEntity zombie) {
            this.zombie = zombie;
        }

        public boolean func_75250_a() {
            return this.zombie.func_70638_az() != null && this.zombie.field_70123_F;
        }

        public void func_75246_d() {
            if (this.zombie.func_70638_az() == null) {
                return;
            }
            ++this.checkDelay;
            if (this.checkDelay < ModConfig.CLIMB_CHECK_DELAY) {
                return;
            }
            this.checkDelay = 0;
            BlockPos zombiePos = this.zombie.func_233580_cy_();
            BlockPos targetPos = this.zombie.func_70638_az().func_233580_cy_();
            if (targetPos.func_177956_o() <= zombiePos.func_177956_o()) {
                return;
            }
            Block blockInFront = this.zombie.field_70170_p.func_180495_p(zombiePos.func_177982_a((int)Math.round(this.zombie.func_70040_Z().field_72450_a), 0, (int)Math.round(this.zombie.func_70040_Z().field_72449_c))).func_177230_c();
            Block blockAbove = this.zombie.field_70170_p.func_180495_p(zombiePos.func_177984_a()).func_177230_c();
            if (blockInFront == Blocks.field_150468_ap || blockInFront == Blocks.field_150395_bd || blockAbove == Blocks.field_150468_ap || blockAbove == Blocks.field_150395_bd) {
                this.zombie.func_213293_j(this.zombie.func_213322_ci().field_72450_a, ModConfig.CLIMB_SPEED, this.zombie.func_213322_ci().field_72449_c);
            }
        }
    }

    static class ZombiePickupItemGoal
    extends Goal {
        private final ZombieEntity zombie;
        private ItemEntity targetItem;
        private int searchDelay;
        private static final int SEARCH_INTERVAL = 60;

        public ZombiePickupItemGoal(ZombieEntity zombie) {
            this.zombie = zombie;
            this.searchDelay = 0;
        }

        public boolean func_75250_a() {
            ++this.searchDelay;
            if (this.searchDelay < 60) {
                return false;
            }
            this.searchDelay = 0;
            List items = this.zombie.field_70170_p.func_175647_a(ItemEntity.class, this.zombie.func_174813_aQ().func_186662_g(8.0), item -> this.isUsefulItem(item.func_92059_d()));
            if (!items.isEmpty()) {
                this.targetItem = (ItemEntity)items.get(0);
                return true;
            }
            return false;
        }

        public void func_75246_d() {
            if (this.targetItem == null || !this.targetItem.func_70089_S()) {
                this.targetItem = null;
                return;
            }
            this.zombie.func_70661_as().func_75497_a((Entity)this.targetItem, 1.2);
            if ((double)this.zombie.func_70032_d((Entity)this.targetItem) < 2.0) {
                ArmorItem armor;
                ItemStack currentArmor;
                ItemStack stack = this.targetItem.func_92059_d();
                if (stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof AxeItem || stack.func_77973_b() instanceof PickaxeItem || stack.func_77973_b() instanceof ShovelItem) {
                    ItemStack currentWeapon = this.zombie.func_184582_a(EquipmentSlotType.MAINHAND);
                    if (this.isBetterWeapon(stack, currentWeapon)) {
                        this.zombie.func_184201_a(EquipmentSlotType.MAINHAND, stack.func_77946_l());
                        this.zombie.func_184185_a(SoundEvents.field_187638_cR, 0.8f, 1.0f);
                        SmartZombiesMod.LOGGER.info("Zombie picked up weapon: {}", (Object)stack.func_77973_b());
                    }
                } else if (stack.func_77973_b() instanceof ArmorItem && this.isBetterArmor(stack, currentArmor = this.zombie.func_184582_a((armor = (ArmorItem)stack.func_77973_b()).func_185083_B_()))) {
                    this.zombie.func_184201_a(armor.func_185083_B_(), stack.func_77946_l());
                    this.zombie.func_184185_a(SoundEvents.field_187725_r, 0.8f, 1.0f);
                    SmartZombiesMod.LOGGER.info("Zombie picked up armor: {}", (Object)stack.func_77973_b());
                }
                this.targetItem.func_70106_y();
                this.targetItem = null;
            }
        }

        private boolean isUsefulItem(ItemStack stack) {
            Item item = stack.func_77973_b();
            return item instanceof SwordItem || item instanceof AxeItem || item instanceof PickaxeItem || item instanceof ShovelItem || item instanceof ArmorItem;
        }

        private boolean isBetterWeapon(ItemStack newWeapon, ItemStack current) {
            TieredItem tiered;
            if (current.func_190926_b()) {
                return true;
            }
            float newDamage = 0.0f;
            float currentDamage = 0.0f;
            if (newWeapon.func_77973_b() instanceof TieredItem) {
                tiered = (TieredItem)newWeapon.func_77973_b();
                newDamage = tiered.func_200891_e().func_200929_c();
            }
            if (current.func_77973_b() instanceof TieredItem) {
                tiered = (TieredItem)current.func_77973_b();
                currentDamage = tiered.func_200891_e().func_200929_c();
            }
            return newDamage > currentDamage;
        }

        private boolean isBetterArmor(ItemStack newArmor, ItemStack current) {
            if (current.func_190926_b()) {
                return true;
            }
            if (newArmor.func_77973_b() instanceof ArmorItem && current.func_77973_b() instanceof ArmorItem) {
                ArmorItem newArmorItem = (ArmorItem)newArmor.func_77973_b();
                ArmorItem currentArmorItem = (ArmorItem)current.func_77973_b();
                return newArmorItem.func_200881_e() > currentArmorItem.func_200881_e();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.targetItem != null && this.targetItem.func_70089_S();
        }
    }
}

