/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.yourname.gayy.ModConfig;
import com.yourname.gayy.SmartZombiesMod;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZombieSpawnHandler {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntityLiving().func_200600_R() == EntityType.field_200725_aD) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d().func_82705_e()) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.WATER_CREATURE || event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.WATER_AMBIENT) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.AMBIENT) {
            return;
        }
        if (event.getEntityLiving().func_200600_R() == EntityType.field_204724_o || event.getEntityLiving().func_200600_R() == EntityType.field_200761_A || event.getEntityLiving().func_200600_R() == EntityType.field_200800_n) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d() != EntityClassification.MONSTER) {
            return;
        }
        if (RANDOM.nextDouble() < ModConfig.ZOMBIE_SPAWN_CHANCE) {
            ServerWorld serverWorld;
            ZombieEntity zombie;
            event.setResult(Event.Result.DENY);
            if (event.getWorld() instanceof ServerWorld && (zombie = (ZombieEntity)EntityType.field_200725_aD.func_200721_a((World)(serverWorld = (ServerWorld)event.getWorld()))) != null) {
                zombie.func_70012_b(event.getX(), event.getY(), event.getZ(), 0.0f, 0.0f);
                serverWorld.func_217376_c((Entity)zombie);
            }
        }
    }

    @SubscribeEvent
    public void onZombieSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntityLiving() instanceof ZombieEntity) {
            ZombieEntity zombie = (ZombieEntity)event.getEntityLiving();
            if (RANDOM.nextDouble() < ModConfig.EQUIPMENT_CHANCE) {
                this.equipZombie(zombie);
            }
            if (ModConfig.ENABLE_ELITE_ZOMBIES && RANDOM.nextDouble() < ModConfig.ELITE_ZOMBIE_CHANCE) {
                this.applyBuffs(zombie);
            }
        }
    }

    private void equipZombie(ZombieEntity zombie) {
        ItemStack weapon = this.getRandomWeapon();
        zombie.func_184201_a(EquipmentSlotType.MAINHAND, weapon);
        if (RANDOM.nextBoolean()) {
            zombie.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)this.getRandomArmorPiece("head")));
        }
        if (RANDOM.nextBoolean()) {
            zombie.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)this.getRandomArmorPiece("chest")));
        }
        if (RANDOM.nextBoolean()) {
            zombie.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)this.getRandomArmorPiece("legs")));
        }
        if (RANDOM.nextBoolean()) {
            zombie.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)this.getRandomArmorPiece("feet")));
        }
        zombie.func_184642_a(EquipmentSlotType.MAINHAND, 0.5f);
        zombie.func_184642_a(EquipmentSlotType.HEAD, 0.5f);
        zombie.func_184642_a(EquipmentSlotType.CHEST, 0.5f);
        zombie.func_184642_a(EquipmentSlotType.LEGS, 0.5f);
        zombie.func_184642_a(EquipmentSlotType.FEET, 0.5f);
    }

    private void applyBuffs(ZombieEntity zombie) {
        int buffType = RANDOM.nextInt(11);
        switch (buffType) {
            case 0: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 2, false, false));
                zombie.func_195064_c(new EffectInstance(Effects.field_76441_p, Integer.MAX_VALUE, 0, false, false));
                zombie.func_70606_j(zombie.func_110138_aP() * 0.7f);
                zombie.getPersistentData().func_74757_a("IsScout", true);
                zombie.getPersistentData().func_74768_a("ScoutCooldown", 0);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a77\u00a7lSCOUT ZOMBIE"));
                    zombie.func_174805_g(true);
                }
                SmartZombiesMod.LOGGER.info("Spawned Scout Zombie!");
                break;
            }
            case 1: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 1, false, false));
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a7cFast Zombie"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 2: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76429_m, Integer.MAX_VALUE, 1, false, false));
                zombie.func_70606_j(zombie.func_110138_aP() * ModConfig.TANK_HEALTH_MULTIPLIER);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a76Tank Zombie"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 3: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76420_g, Integer.MAX_VALUE, 1, false, false));
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a74Berserker Zombie"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 4: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76428_l, Integer.MAX_VALUE, 0, false, false));
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a7aRegenerating Zombie"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 5: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 0, false, false));
                zombie.func_195064_c(new EffectInstance(Effects.field_76420_g, Integer.MAX_VALUE, 0, false, false));
                zombie.func_195064_c(new EffectInstance(Effects.field_76429_m, Integer.MAX_VALUE, 0, false, false));
                zombie.func_70606_j(zombie.func_110138_aP() * ModConfig.ALPHA_HEALTH_MULTIPLIER);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a75\u00a7lALPHA ZOMBIE"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 6: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76429_m, Integer.MAX_VALUE, 2, false, false));
                zombie.func_195064_c(new EffectInstance(Effects.field_76421_d, Integer.MAX_VALUE, 0, false, false));
                zombie.func_70606_j(zombie.func_110138_aP() * 3.0f);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a78\u00a7lJUGGERNAUT"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 7: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 2, false, false));
                zombie.func_195064_c(new EffectInstance(Effects.field_76420_g, Integer.MAX_VALUE, 2, false, false));
                zombie.func_70606_j(zombie.func_110138_aP() * 0.5f);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a7c\u00a7lASSASSIN"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 8: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76428_l, Integer.MAX_VALUE, 1, false, false));
                zombie.getPersistentData().func_74757_a("IsHealer", true);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a7d\u00a7lHEALER"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 9: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 0, false, false));
                zombie.getPersistentData().func_74757_a("IsExplosive", true);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a7e\u00a7lEXPLOSIVE"));
                    zombie.func_174805_g(true);
                }
                zombie.func_184195_f(true);
                break;
            }
            case 10: {
                zombie.func_195064_c(new EffectInstance(Effects.field_76424_c, Integer.MAX_VALUE, 0, false, false));
                zombie.func_195064_c(new EffectInstance(Effects.field_76441_p, Integer.MAX_VALUE, 0, false, false));
                zombie.func_70606_j(zombie.func_110138_aP() * ModConfig.TRAPPER_HEALTH_MULTIPLIER);
                zombie.getPersistentData().func_74757_a("IsTrapper", true);
                zombie.getPersistentData().func_74768_a("TrapSearchTimer", 0);
                if (ModConfig.SHOW_ELITE_NAMES) {
                    zombie.func_200203_b((ITextComponent)new StringTextComponent("\u00a75\u00a7lTRAPPER"));
                    zombie.func_174805_g(true);
                }
                SmartZombiesMod.LOGGER.info("Spawned Trapper Zombie!");
            }
        }
        SmartZombiesMod.LOGGER.info("Spawned elite zombie: {}", (Object)zombie.func_200201_e());
    }

    private ItemStack getRandomWeapon() {
        int choice = RANDOM.nextInt(5);
        switch (choice) {
            case 0: {
                return new ItemStack((IItemProvider)Items.field_151041_m);
            }
            case 1: {
                return new ItemStack((IItemProvider)Items.field_151052_q);
            }
            case 2: {
                return new ItemStack((IItemProvider)Items.field_151040_l);
            }
            case 3: {
                return new ItemStack((IItemProvider)Items.field_151036_c);
            }
            case 4: {
                return new ItemStack((IItemProvider)Items.field_151048_u);
            }
            case 5: {
                return new ItemStack((IItemProvider)Items.field_151006_E);
            }
            case 6: {
                return new ItemStack((IItemProvider)Items.field_151010_B);
            }
        }
        return new ItemStack((IItemProvider)Items.field_151049_t);
    }

    private Item getRandomArmorPiece(String slot) {
        String[] materials = new String[]{"leather", "chainmail", "iron", "golden"};
        String material = materials[RANDOM.nextInt(materials.length)];
        switch (slot) {
            case "head": {
                return this.getHelmet(material);
            }
            case "chest": {
                return this.getChestplate(material);
            }
            case "legs": {
                return this.getLeggings(material);
            }
            case "feet": {
                return this.getBoots(material);
            }
        }
        return Items.field_151024_Q;
    }

    private Item getHelmet(String material) {
        switch (material) {
            case "leather": {
                return Items.field_151024_Q;
            }
            case "chainmail": {
                return Items.field_151020_U;
            }
            case "iron": {
                return Items.field_151028_Y;
            }
            case "golden": {
                return Items.field_151169_ag;
            }
            case "diamond": {
                return Items.field_151161_ac;
            }
        }
        return Items.field_151024_Q;
    }

    private Item getChestplate(String material) {
        switch (material) {
            case "leather": {
                return Items.field_151027_R;
            }
            case "chainmail": {
                return Items.field_151023_V;
            }
            case "iron": {
                return Items.field_151030_Z;
            }
            case "golden": {
                return Items.field_151171_ah;
            }
            case "diamond": {
                return Items.field_151163_ad;
            }
        }
        return Items.field_151027_R;
    }

    private Item getLeggings(String material) {
        switch (material) {
            case "leather": {
                return Items.field_151026_S;
            }
            case "chainmail": {
                return Items.field_151022_W;
            }
            case "iron": {
                return Items.field_151165_aa;
            }
            case "golden": {
                return Items.field_151149_ai;
            }
            case "diamond": {
                return Items.field_151173_ae;
            }
        }
        return Items.field_151026_S;
    }

    private Item getBoots(String material) {
        switch (material) {
            case "leather": {
                return Items.field_151021_T;
            }
            case "chainmail": {
                return Items.field_151029_X;
            }
            case "iron": {
                return Items.field_151167_ab;
            }
            case "golden": {
                return Items.field_151151_aj;
            }
            case "diamond": {
                return Items.field_151175_af;
            }
        }
        return Items.field_151021_T;
    }
}

