/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.yourname.gayy.ModConfig;
import com.yourname.gayy.SmartZombiesMod;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZombieSpecialHandler {
    private static final Map<UUID, PlayerLocationInfo> PLAYER_LOCATIONS = new HashMap<UUID, PlayerLocationInfo>();
    private static final Map<UUID, Long> LAST_FAKE_SOUND = new HashMap<UUID, Long>();
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        List zombies = event.world.func_217357_a(ZombieEntity.class, event.world.func_175723_af().func_222521_a().func_197752_a());
        for (ZombieEntity zombie : zombies) {
            if (zombie.getPersistentData().func_74767_n("IsScout")) {
                this.handleScout(zombie);
            }
            if (zombie.getPersistentData().func_74767_n("IsHealer")) {
                this.handleHealer(zombie);
            }
            this.detectPlayerSounds(zombie);
            this.createFakeSoundsNearPlayers(zombie);
        }
        PLAYER_LOCATIONS.entrySet().removeIf(entry -> ((PlayerLocationInfo)entry.getValue()).isExpired());
    }

    private void detectPlayerSounds(ZombieEntity zombie) {
        if (zombie.func_70638_az() != null) {
            return;
        }
        List nearbyPlayers = zombie.field_70170_p.func_175647_a(PlayerEntity.class, zombie.func_174813_aQ().func_186662_g(ModConfig.SOUND_DETECTION_RANGE), p -> !p.func_184812_l_() && !p.func_175149_v());
        for (PlayerEntity player : nearbyPlayers) {
            double distance;
            double speed;
            boolean heardSound = false;
            BlockPos soundSource = player.func_233580_cy_();
            if (player.func_70051_ag()) {
                heardSound = true;
            }
            if (player.func_184587_cr() || player.field_82175_bq) {
                heardSound = true;
            }
            if (!player.func_233570_aj_() && player.func_213322_ci().field_72448_b > 0.1) {
                heardSound = true;
            }
            if ((speed = Math.sqrt(player.func_213322_ci().field_72450_a * player.func_213322_ci().field_72450_a + player.func_213322_ci().field_72449_c * player.func_213322_ci().field_72449_c)) > 0.05) {
                heardSound = true;
            }
            if (!heardSound && (distance = (double)zombie.func_70032_d((Entity)player)) < 20.0 && RANDOM.nextDouble() < 0.05) {
                heardSound = true;
            }
            if (!heardSound) continue;
            zombie.func_70624_b((LivingEntity)player);
            zombie.getPersistentData().func_74768_a("LastKnownX", soundSource.func_177958_n());
            zombie.getPersistentData().func_74768_a("LastKnownY", soundSource.func_177956_o());
            zombie.getPersistentData().func_74768_a("LastKnownZ", soundSource.func_177952_p());
            zombie.getPersistentData().func_74772_a("LastKnownTime", System.currentTimeMillis());
            zombie.func_70661_as().func_75492_a((double)soundSource.func_177958_n(), (double)soundSource.func_177956_o(), (double)soundSource.func_177952_p(), 1.2);
            break;
        }
    }

    private void createFakeSoundsNearPlayers(ZombieEntity zombie) {
        long lastSound;
        if (zombie.func_70638_az() == null) {
            return;
        }
        if (!(zombie.func_70638_az() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)zombie.func_70638_az();
        UUID playerId = player.func_110124_au();
        long currentTime = System.currentTimeMillis();
        if (LAST_FAKE_SOUND.containsKey(playerId) && currentTime - (lastSound = LAST_FAKE_SOUND.get(playerId).longValue()) < 8000L) {
            return;
        }
        if (RANDOM.nextDouble() < 0.02) {
            double lookX = -Math.sin(Math.toRadians(player.field_70177_z));
            double lookZ = Math.cos(Math.toRadians(player.field_70177_z));
            double distance = 5.0 + RANDOM.nextDouble() * 5.0;
            double offsetX = lookX * distance + (RANDOM.nextDouble() - 0.5) * 3.0;
            double offsetZ = lookZ * distance + (RANDOM.nextDouble() - 0.5) * 3.0;
            BlockPos soundPos = player.func_233580_cy_().func_177982_a((int)offsetX, RANDOM.nextInt(3) - 1, (int)offsetZ);
            zombie.field_70170_p.func_184133_a(null, soundPos, SoundEvents.field_187899_gZ, SoundCategory.HOSTILE, 0.8f + RANDOM.nextFloat() * 0.4f, 0.8f + RANDOM.nextFloat() * 0.4f);
            LAST_FAKE_SOUND.put(playerId, currentTime);
            SmartZombiesMod.LOGGER.debug("Created fake zombie sound behind player at {}", (Object)soundPos);
        }
    }

    private void handleScout(ZombieEntity scout) {
        int cooldown = scout.getPersistentData().func_74762_e("ScoutCooldown");
        if (cooldown > 0) {
            scout.getPersistentData().func_74768_a("ScoutCooldown", cooldown - 1);
            return;
        }
        List players = scout.field_70170_p.func_175647_a(PlayerEntity.class, scout.func_174813_aQ().func_186662_g(50.0), p -> !p.func_184812_l_() && !p.func_175149_v());
        if (!players.isEmpty()) {
            PlayerEntity target = (PlayerEntity)players.get(0);
            BlockPos playerPos = target.func_233580_cy_();
            PLAYER_LOCATIONS.put(target.func_110124_au(), new PlayerLocationInfo(playerPos, scout.func_110124_au()));
            List nearbyZombies = scout.field_70170_p.func_175647_a(ZombieEntity.class, scout.func_174813_aQ().func_186662_g(200.0), z -> z != scout && !z.getPersistentData().func_74767_n("IsScout"));
            for (ZombieEntity zombie : nearbyZombies) {
                if (zombie.func_70638_az() != null) continue;
                zombie.func_70624_b((LivingEntity)target);
                zombie.getPersistentData().func_74768_a("LastKnownX", playerPos.func_177958_n());
                zombie.getPersistentData().func_74768_a("LastKnownY", playerPos.func_177956_o());
                zombie.getPersistentData().func_74768_a("LastKnownZ", playerPos.func_177952_p());
                zombie.getPersistentData().func_74772_a("LastKnownTime", System.currentTimeMillis());
            }
            SmartZombiesMod.LOGGER.info("Scout found player {} at {} and alerted {} zombies!", (Object)target.func_200200_C_().getString(), (Object)playerPos, (Object)nearbyZombies.size());
            double distance = scout.func_70032_d((Entity)target);
            if (distance < 15.0) {
                scout.func_70661_as().func_75499_g();
                double dx = scout.func_226277_ct_() - target.func_226277_ct_();
                double dz = scout.func_226281_cx_() - target.func_226281_cx_();
                double len = Math.sqrt(dx * dx + dz * dz);
                scout.func_70661_as().func_75492_a(scout.func_226277_ct_() + dx / len * 5.0, scout.func_226278_cu_(), scout.func_226281_cx_() + dz / len * 5.0, 1.5);
            } else if (distance > 25.0) {
                scout.func_70661_as().func_75497_a((Entity)target, 1.2);
            }
            scout.getPersistentData().func_74768_a("ScoutCooldown", 40);
        }
    }

    private void handleHealer(ZombieEntity healer) {
        int healCooldown = healer.getPersistentData().func_74762_e("HealCooldown");
        if (healCooldown > 0) {
            healer.getPersistentData().func_74768_a("HealCooldown", healCooldown - 1);
            return;
        }
        List nearbyZombies = healer.field_70170_p.func_175647_a(ZombieEntity.class, healer.func_174813_aQ().func_186662_g(10.0), z -> z != healer && z.func_110143_aJ() < z.func_110138_aP());
        if (!nearbyZombies.isEmpty()) {
            ZombieEntity target = (ZombieEntity)nearbyZombies.get(0);
            float healAmount = 2.0f;
            target.func_70606_j(Math.min(target.func_110143_aJ() + healAmount, target.func_110138_aP()));
            SmartZombiesMod.LOGGER.debug("Healer zombie healed nearby zombie");
            healer.getPersistentData().func_74768_a("HealCooldown", 100);
        }
    }

    @SubscribeEvent
    public void onZombieDeath(LivingDeathEvent event) {
        ZombieEntity zombie;
        if (event.getEntityLiving() instanceof ZombieEntity && (zombie = (ZombieEntity)event.getEntityLiving()).getPersistentData().func_74767_n("IsExplosive")) {
            zombie.field_70170_p.func_217385_a((Entity)zombie, zombie.func_226277_ct_(), zombie.func_226278_cu_(), zombie.func_226281_cx_(), 2.0f, Explosion.Mode.BREAK);
            SmartZombiesMod.LOGGER.info("Explosive zombie detonated!");
        }
    }

    private static class PlayerLocationInfo {
        BlockPos position;
        long timestamp;
        UUID scoutId;

        PlayerLocationInfo(BlockPos pos, UUID scout) {
            this.position = pos;
            this.timestamp = System.currentTimeMillis();
            this.scoutId = scout;
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 10000L;
        }
    }
}

