/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.gayy;

import com.yourname.gayy.ModConfig;
import com.yourname.gayy.SmartZombiesMod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ZombieTrapHandler {
    private static final Random RANDOM = new Random();
    private static final Map<UUID, Long> TRAP_COOLDOWNS = new HashMap<UUID, Long>();
    private static final Set<BlockPos> PLACED_TRAPS = new HashSet<BlockPos>();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!ModConfig.ENABLE_TRAPPER_ZOMBIES) {
            return;
        }
        List trappers = event.world.func_175647_a(ZombieEntity.class, event.world.func_175723_af().func_222521_a().func_197752_a(), zombie -> zombie.getPersistentData().func_74767_n("IsTrapper"));
        for (ZombieEntity trapper : trappers) {
            this.handleTrapperBehavior(trapper);
        }
        if (event.world.func_82737_E() % 6000L == 0L) {
            this.cleanupOldTraps(event.world);
        }
    }

    private void handleTrapperBehavior(ZombieEntity trapper) {
        long lastTrap;
        UUID trapperId = trapper.func_110124_au();
        long currentTime = System.currentTimeMillis();
        if (TRAP_COOLDOWNS.containsKey(trapperId) && currentTime - (lastTrap = TRAP_COOLDOWNS.get(trapperId).longValue()) < (long)(ModConfig.TRAP_PLACE_COOLDOWN * 50)) {
            return;
        }
        int searchInterval = trapper.getPersistentData().func_74762_e("TrapSearchTimer");
        trapper.getPersistentData().func_74768_a("TrapSearchTimer", ++searchInterval);
        if (searchInterval < ModConfig.TRAP_SEARCH_INTERVAL) {
            return;
        }
        trapper.getPersistentData().func_74768_a("TrapSearchTimer", 0);
        PlayerEntity nearestPlayer = trapper.field_70170_p.func_217362_a((Entity)trapper, ModConfig.TRAP_PLACE_RANGE);
        if (nearestPlayer != null && !nearestPlayer.func_184812_l_() && !nearestPlayer.func_175149_v() && this.tryPlaceTrap(trapper, nearestPlayer)) {
            TRAP_COOLDOWNS.put(trapperId, currentTime);
            trapper.func_184185_a(SoundEvents.field_187576_at, 0.5f, 1.5f);
            SmartZombiesMod.LOGGER.info("Trapper zombie placed a trap near player {}", (Object)nearestPlayer.func_200200_C_().getString());
        }
    }

    private boolean tryPlaceTrap(ZombieEntity trapper, PlayerEntity player) {
        World world = trapper.field_70170_p;
        BlockPos playerPos = player.func_233580_cy_();
        BlockPos trapPos = this.findTrapPosition(world, playerPos, player);
        if (trapPos == null) {
            return false;
        }
        for (BlockPos existingTrap : PLACED_TRAPS) {
            if (!(existingTrap.func_177951_i((Vector3i)trapPos) < 25.0)) continue;
            return false;
        }
        TrapType trapType = this.selectTrapType();
        boolean success = this.placeTrap(world, trapPos, trapType, trapper);
        if (success) {
            PLACED_TRAPS.add(trapPos);
            world.func_217379_c(2001, trapPos, Block.func_196246_j((BlockState)Blocks.field_150451_bX.func_176223_P()));
        }
        return success;
    }

    private BlockPos findTrapPosition(World world, BlockPos playerPos, PlayerEntity player) {
        double length;
        double motionX = player.func_213322_ci().field_72450_a;
        double motionZ = player.func_213322_ci().field_72449_c;
        if (Math.abs(motionX) < 0.01 && Math.abs(motionZ) < 0.01) {
            motionX = -Math.sin(Math.toRadians(player.field_70177_z));
            motionZ = Math.cos(Math.toRadians(player.field_70177_z));
        }
        if ((length = Math.sqrt(motionX * motionX + motionZ * motionZ)) > 0.0) {
            motionX /= length;
            motionZ /= length;
        }
        for (int distance = 3; distance <= 7; ++distance) {
            BlockPos testPos = playerPos.func_177982_a((int)(motionX * (double)distance), 0, (int)(motionZ * (double)distance));
            if (this.isValidTrapPosition(world, testPos)) {
                return testPos;
            }
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                    BlockPos offset = testPos.func_177982_a(offsetX, 0, offsetZ);
                    if (!this.isValidTrapPosition(world, offset)) continue;
                    return offset;
                }
            }
        }
        return null;
    }

    private boolean isValidTrapPosition(World world, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        if (!world.func_180495_p(below).func_185904_a().func_76220_a()) {
            return false;
        }
        if (!world.func_180495_p(pos).func_185904_a().func_76222_j()) {
            return false;
        }
        BlockPos above = pos.func_177984_a();
        return world.func_180495_p(above).func_185904_a().func_76222_j() || world.func_175623_d(above);
    }

    private TrapType selectTrapType() {
        double random = RANDOM.nextDouble();
        double cumulative = 0.0;
        if (random < (cumulative += ModConfig.TRAP_TNT_CHANCE)) {
            return TrapType.TNT;
        }
        if (random < (cumulative += ModConfig.TRAP_WEB_CHANCE)) {
            return TrapType.WEB;
        }
        if (random < (cumulative += ModConfig.TRAP_PIT_CHANCE)) {
            return TrapType.PIT;
        }
        if (random < (cumulative += ModConfig.TRAP_LAVA_CHANCE)) {
            return TrapType.LAVA;
        }
        if (random < (cumulative += ModConfig.TRAP_PRESSURE_PLATE_CHANCE)) {
            return TrapType.PRESSURE_PLATE;
        }
        return TrapType.WEB;
    }

    private boolean placeTrap(World world, BlockPos pos, TrapType type, ZombieEntity trapper) {
        switch (type) {
            case TNT: {
                return this.placeTNTTrap(world, pos);
            }
            case WEB: {
                return this.placeWebTrap(world, pos);
            }
            case PIT: {
                return this.placePitTrap(world, pos);
            }
            case LAVA: {
                return this.placeLavaTrap(world, pos);
            }
            case PRESSURE_PLATE: {
                return this.placePressurePlateTrap(world, pos);
            }
        }
        return false;
    }

    private boolean placeTNTTrap(World world, BlockPos pos) {
        BlockPos above;
        world.func_180501_a(pos, Blocks.field_150335_W.func_176223_P(), 3);
        if (ModConfig.TRAP_HIDE_PLATES && RANDOM.nextBoolean() && world.func_175623_d(above = pos.func_177984_a())) {
            Block[] carpets = new Block[]{Blocks.field_196751_fV, Blocks.field_196749_fU, Blocks.field_196747_fT, Blocks.field_196737_fO, Blocks.field_196753_fW};
            world.func_180501_a(above, carpets[RANDOM.nextInt(carpets.length)].func_176223_P(), 3);
        }
        return true;
    }

    private boolean placeWebTrap(World world, BlockPos pos) {
        int layers = 2 + RANDOM.nextInt(2);
        for (int i = 0; i < layers; ++i) {
            BlockPos webPos = pos.func_177981_b(i);
            if (!world.func_175623_d(webPos) && !world.func_180495_p(webPos).func_185904_a().func_76222_j()) continue;
            world.func_180501_a(webPos, Blocks.field_196553_aF.func_176223_P(), 3);
        }
        if (RANDOM.nextBoolean()) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos sidePos;
                    if (x == 0 && z == 0 || !world.func_175623_d(sidePos = pos.func_177982_a(x, 0, z)) || !RANDOM.nextBoolean()) continue;
                    world.func_180501_a(sidePos, Blocks.field_196553_aF.func_176223_P(), 3);
                }
            }
        }
        return true;
    }

    private boolean placePitTrap(World world, BlockPos pos) {
        BlockPos digPos;
        Block block;
        int depth = ModConfig.TRAP_PIT_DEPTH;
        for (int y = 0; y < depth && (block = world.func_180495_p(digPos = pos.func_177979_c(y)).func_177230_c()) != Blocks.field_150357_h && block != Blocks.field_150378_br; ++y) {
            world.func_175655_b(digPos, false);
        }
        BlockPos bottom = pos.func_177979_c(depth - 1);
        if (RANDOM.nextBoolean()) {
            world.func_180501_a(bottom, Blocks.field_196814_hQ.func_176223_P(), 3);
        } else if (RANDOM.nextFloat() < 0.3f) {
            world.func_180501_a(bottom, Blocks.field_150353_l.func_176223_P(), 3);
        }
        if (ModConfig.TRAP_HIDE_PLATES) {
            Block[] carpets = new Block[]{Blocks.field_196749_fU, Blocks.field_196747_fT, Blocks.field_196737_fO};
            world.func_180501_a(pos, carpets[RANDOM.nextInt(carpets.length)].func_176223_P(), 3);
        }
        return true;
    }

    private boolean placeLavaTrap(World world, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        world.func_175655_b(below, false);
        world.func_180501_a(below, Blocks.field_150353_l.func_176223_P(), 3);
        if (ModConfig.TRAP_HIDE_PLATES) {
            Block[] carpets = new Block[]{Blocks.field_196725_fI, Blocks.field_196751_fV, Blocks.field_196731_fL};
            world.func_180501_a(pos, carpets[RANDOM.nextInt(carpets.length)].func_176223_P(), 3);
        }
        return true;
    }

    private boolean placePressurePlateTrap(World world, BlockPos pos) {
        BlockPos below = pos.func_177977_b();
        world.func_180501_a(below, Blocks.field_150335_W.func_176223_P(), 3);
        world.func_180501_a(pos, Blocks.field_150456_au.func_176223_P(), 3);
        BlockPos redstonePos = pos.func_177984_a();
        if (world.func_175623_d(redstonePos)) {
            world.func_180501_a(redstonePos, Blocks.field_150488_af.func_176223_P(), 3);
        }
        return true;
    }

    private void cleanupOldTraps(World world) {
        PLACED_TRAPS.removeIf(pos -> {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block != Blocks.field_150335_W && block != Blocks.field_196553_aF && block != Blocks.field_150353_l && !(block instanceof CarpetBlock) && !(block instanceof PressurePlateBlock);
        });
        SmartZombiesMod.LOGGER.debug("Cleaned up traps. Remaining: {}", (Object)PLACED_TRAPS.size());
    }

    public static void clearAllTraps() {
        PLACED_TRAPS.clear();
        TRAP_COOLDOWNS.clear();
        SmartZombiesMod.LOGGER.info("All traps cleared!");
    }

    public static int getTrapCount() {
        return PLACED_TRAPS.size();
    }

    private static enum TrapType {
        TNT,
        WEB,
        PIT,
        LAVA,
        PRESSURE_PLATE;

    }
}

