/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.blocks.entity;

import com.google.common.collect.Maps;
import com.moigferdsrte.sandwichable.blocks.extra.BasinContent;
import com.moigferdsrte.sandwichable.blocks.extra.BasinContentType;
import com.moigferdsrte.sandwichable.blocks.extra.SyncedBlockEntity;
import com.moigferdsrte.sandwichable.items.CheeseCultureItem;
import com.moigferdsrte.sandwichable.items.CheeseItem;
import com.moigferdsrte.sandwichable.items.extra.CheeseType;
import com.moigferdsrte.sandwichable.registry.BlocksRegistry;
import com.moigferdsrte.sandwichable.registry.ItemsRegistry;
import com.moigferdsrte.sandwichable.util.CheeseRegistry;
import com.moigferdsrte.sandwichable.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BasinBlockEntity
extends class_2586
implements class_1278,
SyncedBlockEntity {
    private int fermentProgress = 0;
    public static final int fermentTime = 3600;
    private BasinContent content = BasinContent.AIR;
    @Nullable
    private class_1799 transferStack = null;
    private final class_5819 rng = class_5819.method_43047();

    public BasinBlockEntity(class_2338 pos, class_2680 state) {
        super(BlocksRegistry.BASIN_BLOCKENTITY, pos, state);
    }

    public static Map<CheeseType, class_1792> cheeseTypeToItem() {
        HashMap map = Maps.newHashMap();
        map.put(CheeseType.REGULAR, ItemsRegistry.CHEESE_WHEEL_REGULAR);
        map.put(CheeseType.CREAMY, ItemsRegistry.CHEESE_WHEEL_CREAMY);
        map.put(CheeseType.INTOXICATING, ItemsRegistry.CHEESE_WHEEL_INTOXICATING);
        map.put(CheeseType.SOUR, ItemsRegistry.CHEESE_WHEEL_SOUR);
        map.put(CheeseType.CANDESCENT, ItemsRegistry.CHEESE_WHEEL_CANDESCENT);
        map.put(CheeseType.WARPED_BLEU, ItemsRegistry.CHEESE_WHEEL_WARPED_BLEU);
        return map;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.fermentProgress = nbt.method_10550("fermentProgress");
        this.content = CheeseRegistry.INSTANCE.basinContentFromString(nbt.method_10558("basinContent") == null ? "air" : nbt.method_10558("basinContent"));
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("fermentProgress", this.fermentProgress);
        nbt.method_10582("basinContent", this.getContent() == null ? "air" : this.getContent().toString());
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return this.getPacket();
    }

    public class_1269 onBlockUse(class_1657 player, class_1268 hand) {
        class_1799 playerStack = player.method_5998(hand);
        BasinContent content = this.getContent();
        if (content.getContentType() == BasinContentType.CHEESE) {
            class_1542 cheese = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, new class_1799((class_1935)BasinBlockEntity.cheeseTypeToItem().get((Object)content.getCheeseType()), 1));
            this.field_11863.method_8649((class_1297)cheese);
            this.content = BasinContent.AIR;
            this.update();
            return class_1269.field_5812;
        }
        if (content == BasinContent.MILK && playerStack.method_7909() instanceof CheeseCultureItem) {
            class_1799 s = this.addCheeseCulture(playerStack);
            if (!player.method_7337()) {
                player.method_6122(hand, s);
            }
            this.update();
            return class_1269.field_5812;
        }
        if (content == BasinContent.AIR && playerStack.method_7909() instanceof CheeseItem && !((CheeseItem)playerStack.method_7909()).isSlice()) {
            this.insertCheese(playerStack.method_7972());
            if (!player.method_7337()) {
                playerStack.method_7934(1);
            }
            this.update();
            return class_1269.field_5812;
        }
        if ((playerStack.method_7909() == class_1802.field_8103 || playerStack.method_7909() == ItemsRegistry.FERMENTING_MILK_BUCKET) && content == BasinContent.AIR) {
            class_1799 result = this.insertMilk(playerStack);
            if (result.equals(playerStack)) {
                return class_1269.field_5811;
            }
            if (!player.method_7337()) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550, 1));
            }
            this.update();
            return class_1269.field_5812;
        }
        if (playerStack.method_7909() == class_1802.field_8550 && this.getContent().getContentType().isLiquid) {
            class_1799 result = this.extractMilk();
            this.update();
            if (!result.method_7960()) {
                playerStack.method_7934(1);
                player.method_7270(result);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        this.update();
        return class_1269.field_5811;
    }

    public int getFermentProgress() {
        return this.fermentProgress;
    }

    public BasinContent getContent() {
        if (this.transferStack != null && this.transferStack.method_7960()) {
            this.content = BasinContent.AIR;
        }
        return this.content;
    }

    public void startFermenting(CheeseType type) {
        if (this.getContent() == BasinContent.MILK) {
            this.content = CheeseRegistry.INSTANCE.fermentingMilkFromCheeseType(type);
            this.fermentProgress = 0;
        }
        this.update();
        this.method_5431();
    }

    public void finishFermenting() {
        if (this.getContent().getContentType() == BasinContentType.FERMENTING_MILK) {
            this.fermentProgress = 0;
            this.content = CheeseRegistry.INSTANCE.cheeseFromCheeseType(this.getContent().getCheeseType());
        }
        this.update();
        this.method_5431();
    }

    public class_1799 insertMilk(class_1799 milk) {
        class_1799 r = milk;
        if (milk.method_7909() == class_1802.field_8103) {
            this.content = BasinContent.MILK;
            r = new class_1799((class_1935)class_1802.field_8550);
        } else if (milk.method_7909() == ItemsRegistry.FERMENTING_MILK_BUCKET) {
            if (milk.method_57826(class_9334.field_49628) && ((class_9279)milk.method_57824(class_9334.field_49628)).method_57461().method_10562("bucketData") != null) {
                class_2487 tag = ((class_9279)milk.method_57824(class_9334.field_49628)).method_57461().method_10562("bucketData");
                this.content = CheeseRegistry.INSTANCE.basinContentFromString(tag.method_10558("basinContent"));
                this.fermentProgress = tag.method_10550("fermentProgressActual");
            }
            r = new class_1799((class_1935)class_1802.field_8550);
        }
        this.update();
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14834, class_3419.field_15245, 0.8f, 1.0f);
        return r;
    }

    public class_1799 extractMilk() {
        BasinContent content = this.getContent();
        if (content == BasinContent.MILK) {
            this.emptyBasin();
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15126, class_3419.field_15245, 0.8f, 1.0f);
            this.update();
            return new class_1799((class_1935)class_1802.field_8103);
        }
        if (content.getContentType() == BasinContentType.FERMENTING_MILK) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15126, class_3419.field_15245, 0.8f, 1.0f);
            class_1799 stack = new class_1799((class_1935)ItemsRegistry.FERMENTING_MILK_BUCKET);
            class_2487 tag = new class_2487();
            tag.method_10569("fermentProgressActual", this.fermentProgress);
            float a = (float)this.fermentProgress / 3600.0f;
            int x = Math.round(a *= 100.0f);
            tag.method_10569("percentFermented", x);
            tag.method_10582("basinContent", content.toString());
            if (stack.method_57826(class_9334.field_49628)) {
                class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, nbt -> nbt.method_10566("bucketData", (class_2520)tag));
            } else {
                class_2487 nbt2 = new class_2487();
                nbt2.method_10566("bucketData", (class_2520)tag);
                class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)stack, (class_2487)nbt2);
            }
            this.emptyBasin();
            this.update();
            return stack;
        }
        return class_1799.field_8037;
    }

    public class_1799 addCheeseCulture(class_1799 stack) {
        class_1792 class_17922;
        if (this.getContent().getContentType() == BasinContentType.MILK && (class_17922 = stack.method_7909()) instanceof CheeseCultureItem) {
            CheeseCultureItem culture = (CheeseCultureItem)class_17922;
            this.startFermenting(culture.getCheeseType());
            BasinBlockEntity.createCheeseParticle(this.field_11863, this.field_11867, this.rng, 8, this.getContent().getCheeseType().getParticleColorRGB());
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14826, class_3419.field_15245, 0.82f, 1.0f);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_20615, class_3419.field_15245, 1.0f, 1.5f);
            return culture.deplete(stack, 1);
        }
        return stack;
    }

    public void insertCheese(class_1799 cheese) {
        if (cheese.method_7909() instanceof CheeseItem && !((CheeseItem)cheese.method_7909()).isSlice()) {
            this.content = CheeseRegistry.INSTANCE.cheeseFromCheeseType(((CheeseItem)cheese.method_7909()).getType());
            cheese.method_7934(1);
        }
        this.update();
    }

    public void emptyBasin() {
        this.content = BasinContent.AIR;
        this.fermentProgress = 0;
        this.transferStack = null;
        this.update();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BasinBlockEntity self) {
        if (self.getContent() != null && self.getContent().getContentType() == BasinContentType.FERMENTING_MILK) {
            ++self.fermentProgress;
        }
        if (self.fermentProgress >= 3600) {
            self.finishFermenting();
        }
    }

    public void update() {
        this.field_11863.method_8455(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
        Util.sync(this);
        this.method_5431();
    }

    public static void createCheeseParticle(class_1937 world, class_2338 pos, class_5819 random, int count, float[] color) {
        for (int i = 0; i < count; ++i) {
            double ox = (double)random.method_43048(10) / 16.0;
            double oz = (double)random.method_43048(10) / 16.0;
            world.method_8406((class_2394)new class_2390(new Vector3f(color[0], color[1], color[2]), 1.0f), (double)pos.method_10263() + ox + 0.2, (double)pos.method_10264() + 0.4, (double)pos.method_10260() + oz + 0.2, 0.0, 0.09, 0.0);
        }
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return this.method_5442() && stack.method_7909() instanceof CheeseItem && !((CheeseItem)stack.method_7909()).isSlice();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return this.getContent() == BasinContent.AIR;
    }

    public class_1799 method_5438(int slot) {
        BasinContent content = this.getContent();
        if (this.transferStack == null) {
            if (content.getContentType() == BasinContentType.CHEESE) {
                this.transferStack = new class_1799((class_1935)BasinBlockEntity.cheeseTypeToItem().get((Object)content.getCheeseType()));
                return this.transferStack;
            }
            return class_1799.field_8037;
        }
        return this.transferStack;
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.method_5441(slot);
    }

    public class_1799 method_5441(int slot) {
        class_1799 r = this.method_5438(slot);
        this.emptyBasin();
        this.update();
        return r;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (stack.method_7909() instanceof CheeseItem && !((CheeseItem)stack.method_7909()).isSlice()) {
            this.insertCheese(stack);
        }
        this.update();
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
        this.emptyBasin();
        this.update();
    }
}

