/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.blocks.entity;

import com.google.common.base.Objects;
import com.moigferdsrte.sandwichable.blocks.extra.SyncedBlockEntity;
import com.moigferdsrte.sandwichable.config.SandwichableConfig;
import com.moigferdsrte.sandwichable.items.KitchenKnifeItem;
import com.moigferdsrte.sandwichable.network.payload.CuttingBoardParticlesPayload;
import com.moigferdsrte.sandwichable.recipe.CuttingRecipe;
import com.moigferdsrte.sandwichable.registry.BlocksRegistry;
import com.moigferdsrte.sandwichable.registry.ItemsRegistry;
import com.moigferdsrte.sandwichable.util.Util;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8786;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class CuttingBoardBlockEntity
extends class_2586
implements SyncedBlockEntity,
class_1278 {
    private class_1799 item = class_1799.field_8037;
    private class_1799 knife = class_1799.field_8037;
    private int knifeAnimationTicks = 0;
    private int lastItemCount = 0;

    public CuttingBoardBlockEntity(class_2338 pos, class_2680 state) {
        super(BlocksRegistry.CUTTINGBOARD_BLOCKENTITY, pos, state);
    }

    public class_1799 getItem() {
        return this.item;
    }

    public class_1799 getKnife() {
        return this.knife;
    }

    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean hasItem;
        int cut = 0;
        class_1268 knifeHand = null;
        class_1268 itemHand = hand == null ? class_1268.field_5808 : hand;
        SandwichableConfig cfg = Util.getConfig();
        for (SandwichableConfig.KitchenKnifeOption opt : cfg.itemOptions.knives) {
            class_2960 id = class_2960.method_12829((String)opt.itemId);
            if (id == null) continue;
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            if (player.method_5998(class_1268.field_5808).method_7909() != item && player.method_5998(class_1268.field_5810).method_7909() != item) continue;
            knifeHand = player.method_5998(class_1268.field_5808).method_7909() == item ? class_1268.field_5808 : class_1268.field_5810;
            itemHand = knifeHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
            cut = KitchenKnifeItem.getItemCutAmount(player.method_5998(knifeHand));
        }
        class_1799 iStack = player.method_5998(itemHand);
        boolean hasKnife = knifeHand != null;
        boolean bl = hasItem = !iStack.method_7960();
        if (hasItem && this.getItem().method_7947() < this.getItem().method_7914() && (!hasKnife || this.getItem().method_7947() < cut) && (this.getItem().method_7960() || class_1799.method_7984((class_1799)this.getItem(), (class_1799)iStack) && Objects.equal((Object)((class_9279)this.getItem().method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461(), (Object)((class_9279)iStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461()))) {
            if (!this.getItem().method_7960()) {
                this.getItem().method_7939(this.getItem().method_7947() + 1);
                if (!player.method_7337()) {
                    iStack.method_7934(1);
                }
            } else if (player.method_7337()) {
                this.item = iStack.method_7972();
                this.item.method_7939(1);
            } else {
                this.item = iStack.method_7971(1);
            }
            if (itemHand == class_1268.field_5810) {
                player.method_6104(class_1268.field_5810);
            }
            return class_1269.method_29236((itemHand == class_1268.field_5808 && world.method_8608() ? 1 : 0) != 0);
        }
        if (hasKnife && !this.item.method_7960() && this.knife.method_7960()) {
            this.slice(cut);
            if (cut <= 0 || player instanceof class_3222) {
                // empty if block
            }
            if (!player.method_7337()) {
                KitchenKnifeItem.processCut(player.method_5998(knifeHand), cut);
            }
            if (knifeHand == class_1268.field_5810) {
                player.method_6104(knifeHand);
            }
            return class_1269.method_29236((knifeHand != class_1268.field_5810 && world.method_8608() ? 1 : 0) != 0);
        }
        if (hasKnife && this.knife.method_7960()) {
            this.knife = player.method_5998(knifeHand).method_7971(1);
            player.method_5998(knifeHand).method_7934(1);
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (!this.getItem().method_7960() && this.knife.method_7960()) {
            class_1542 entity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.3, (double)pos.method_10260() + 0.5, player.method_5715() ? this.getItem() : this.getItem().method_7971(1));
            if (player.method_5715()) {
                this.item = class_1799.field_8037;
            }
            if (!player.method_7337()) {
                entity.method_6988();
                world.method_8649((class_1297)entity);
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (!this.knife.method_7960()) {
            player.method_31548().method_7398(this.getKnife());
            this.knife = class_1799.field_8037;
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return class_1269.field_5811;
    }

    private static class_1268 isHolding(class_1657 player, class_1792 item) {
        return player.method_5998(class_1268.field_5808).method_7909() == item ? class_1268.field_5808 : (player.method_5998(class_1268.field_5810).method_7909() == item ? class_1268.field_5810 : null);
    }

    public void update() {
        Util.sync(this);
        this.field_11863.method_8455(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204());
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 c;
        super.method_11014(nbt, registryLookup);
        if (nbt.method_10545("Items")) {
            class_2371 list = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)nbt, (class_2371)list, (class_7225.class_7874)registryLookup);
            this.item = (class_1799)list.get(0);
        } else if (nbt.method_10573("Item", 10) && !(c = nbt.method_10562("Item")).method_10558("id").equals("minecraft:air")) {
            this.item = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Item")).orElse(class_1802.field_8229.method_7854());
        }
        if (nbt.method_10573("Knife", 10)) {
            c = nbt.method_10562("Knife");
            if (!c.method_10558("id").equals("minecraft:air")) {
                this.knife = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Knife")).orElse(ItemsRegistry.IRON_KITCHEN_KNIFE.method_7854());
            }
            this.knifeAnimationTicks = nbt.method_10550("knifeAnim");
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11007(tag, registryLookup);
        tag.method_10566("Item", (class_2520)this.writeItemNbt(new class_2487(), this.item));
        tag.method_10566("Knife", (class_2520)this.writeItemNbt(new class_2487(), this.knife));
        tag.method_10569("knifeAnim", this.knifeAnimationTicks);
    }

    public class_2487 writeItemNbt(class_2487 nbt, class_1799 item) {
        class_2960 identifier = class_7923.field_41178.method_10221((Object)item.method_7909());
        nbt.method_10582("id", identifier.toString());
        nbt.method_10567("Count", (byte)item.method_7947());
        if (item.method_57826(class_9334.field_49628)) {
            nbt.method_10566("tag", (class_2520)((class_9279)item.method_57824(class_9334.field_49628)).method_57461());
        }
        return nbt;
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return this.getPacket();
    }

    public void trySliceWithKnife() {
        if (!this.knife.method_7960()) {
            this.knifeAnimationTicks = 10;
            int cut = 0;
            SandwichableConfig cfg = Util.getConfig();
            SandwichableConfig.KitchenKnifeOption opt = cfg.getKnifeOption(this.knife.method_7909());
            if (opt != null) {
                cut = KitchenKnifeItem.getItemCutAmount(this.knife);
                KitchenKnifeItem.processCut(this.knife, cut);
            }
            this.slice(cut);
            this.update();
        }
    }

    private void slice(int amount) {
        amount = Math.min(amount, this.getItem().method_7947());
        class_9696 inv = new class_9696(this.getItem());
        Optional match = this.field_11863.method_8433().method_8132((class_3956)CuttingRecipe.Type.INSTANCE, (class_9695)inv, this.field_11863);
        if (match.isPresent()) {
            class_1799 output = ((CuttingRecipe)((class_8786)match.get()).comp_1933()).craft(inv, (class_7225.class_7874)this.field_11863.method_30349()).method_7972();
            int nc = output.method_7947() * amount;
            int maxCount = output.method_7909().method_7882();
            int i = 0;
            while ((double)i < Math.ceil((float)nc / (float)maxCount)) {
                class_1799 result = output.method_7972();
                result.method_7939(Math.min(maxCount, (nc - i * maxCount) % maxCount));
                class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.3, (double)this.field_11867.method_10260() + 0.5, result);
                class_2338 dir = class_2338.field_10980.method_10093(((class_2350)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)class_2741.field_12481)).method_10153());
                entity.method_18800((double)dir.method_10263() * 0.15 + (this.field_11863.field_9229.method_43058() - 0.5) * 0.08, 0.17, (double)dir.method_10260() * 0.15 + (this.field_11863.field_9229.method_43058() - 0.5) * 0.08);
                entity.method_6988();
                this.field_11863.method_8649((class_1297)entity);
                ++i;
            }
            this.particles(output, amount);
            this.getItem().method_7934(amount);
            if (amount > 0) {
                this.field_11863.method_43128(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.3, (double)this.field_11867.method_10260() + 0.5, class_3417.field_14619, class_3419.field_15245, 0.7f, 0.8f);
            }
        }
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return stack.method_7909() != ItemsRegistry.SANDWICH && Util.getConfig().getKnifeOption(stack.method_7909()) == null;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return this.knife.method_7960();
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return this.item.method_7960();
    }

    public class_1799 method_5438(int slot) {
        return this.item;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 r = this.method_5438(slot).method_7971(amount);
        this.update();
        return r;
    }

    public class_1799 method_5441(int slot) {
        return this.method_5434(slot, this.method_5438(slot).method_7947());
    }

    public void method_5447(int slot, class_1799 stack) {
        this.item = stack;
        this.update();
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.item = class_1799.field_8037;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CuttingBoardBlockEntity self) {
        if (self.item.method_7947() != self.lastItemCount) {
            self.update();
        }
        self.lastItemCount = self.item.method_7947();
        if (self.knifeAnimationTicks > 0) {
            --self.knifeAnimationTicks;
        }
    }

    public int getKnifeAnimationTicks() {
        return this.knifeAnimationTicks;
    }

    private void particles(class_1799 stack, int depth) {
        if (!this.field_11863.method_8608()) {
            for (class_1657 player : this.field_11863.method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_243 class_2432 = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
                if (!(player.method_19538().method_1022(class_2432) < 100.0)) continue;
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)new CuttingBoardParticlesPayload(stack, depth, this.field_11867));
            }
        }
    }
}

