/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.DirtTexturedBackground;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleInputOption;
import dev.lambdaurora.spruceui.option.SpruceFloatInputOption;
import dev.lambdaurora.spruceui.option.SpruceIntegerInputOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceToggleBooleanOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.util.RenderUtil;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigInABarrel {
    private static final Logger LOG = LogManager.getLogger((String)"ConfigInABarrel (Included)");
    private static final Map<Class<?>, Config> CONFIGS = new HashMap();
    private static final Gson GSON = new Gson();

    private static Config load(Class<? extends ConfigInABarrel> cls, Config config) {
        if (!Files.exists(config.path, new LinkOption[0])) {
            ConfigInABarrel.save(cls, config);
        } else {
            try (BufferedReader reader = Files.newBufferedReader(config.path);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                config.config = (ConfigInABarrel)GSON.fromJson((JsonElement)json, cls);
                config.config.loadExtraData(json);
            }
            catch (IOException e) {
                LOG.error("Failed to load config \"" + config.name + "\"", (Throwable)e);
            }
        }
        config.config.afterLoad();
        return config;
    }

    private static void save(Class<?> cls, Config config) {
        try (JsonWriter writer = GSON.newJsonWriter((Writer)Files.newBufferedWriter(config.path, new OpenOption[0]));){
            writer.setIndent("    ");
            JsonElement elem = GSON.toJsonTree((Object)config.config, cls);
            if (elem instanceof JsonObject) {
                config.config.saveExtraData((JsonObject)elem);
            }
            GSON.toJson(elem, writer);
        }
        catch (IOException e) {
            LOG.error("Failed to save config \"" + config.name + "\"", (Throwable)e);
        }
    }

    public static <T extends ConfigInABarrel> T config(String name, Class<T> cls, Supplier<T> cfg) {
        if (!CONFIGS.containsKey(cls)) {
            ConfigInABarrel cfgObj = (ConfigInABarrel)cfg.get();
            CONFIGS.put(cls, ConfigInABarrel.load(cls, new Config(name, cfgObj)));
            return (T)cfgObj;
        }
        return (T)ConfigInABarrel.CONFIGS.get(cls).config;
    }

    @Environment(value=EnvType.CLIENT)
    public static <T extends ConfigInABarrel> class_437 screen(Class<T> cls, class_437 parent) {
        return new ConfigScreen(parent, cls, CONFIGS.get(cls));
    }

    protected void afterLoad() {
    }

    protected void saveExtraData(JsonObject file) {
    }

    protected void loadExtraData(JsonObject file) {
    }

    @Environment(value=EnvType.CLIENT)
    protected Background background() {
        return DirtTexturedBackground.DARKENED;
    }

    private static class Config {
        ConfigInABarrel config;
        final String name;
        final Path path;

        Config(String name, ConfigInABarrel config) {
            this.config = config;
            this.name = name;
            this.path = FabricLoader.getInstance().getConfigDir().toAbsolutePath().resolve(name + ".json");
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConfigScreen
    extends SpruceScreen {
        private final class_437 parent;
        private final Class<? extends ConfigInABarrel> cfgCls;
        private final Config config;
        private SpruceOptionListWidget optionsWidget;

        protected <T extends ConfigInABarrel> ConfigScreen(class_437 parent, Class<T> cls, Config config) {
            super((class_2561)class_2561.method_43471((String)("cfgbarrel." + config.name + ".screen")));
            this.cfgCls = cls;
            this.config = config;
            this.parent = parent;
        }

        private void addFields(String namespace, @Nullable List<String> parents, Class<?> cls, Object obj) {
            String pKey = "cfgbarrel." + namespace + ".option";
            if (parents != null) {
                pKey = pKey + "." + parents.stream().reduce((a, b) -> a + "." + b).orElse("error");
            }
            for (Field field : cls.getDeclaredFields()) {
                Class<?> fc = field.getType();
                String key = pKey + "." + field.getName();
                int min = 0;
                int max = 0;
                boolean gui = true;
                for (Annotation ann : field.getAnnotations()) {
                    if (!(ann instanceof Value)) continue;
                    Value v = (Value)ann;
                    min = v.min();
                    max = v.max();
                    gui = v.gui();
                }
                if (!gui) continue;
                if (fc.equals(Integer.TYPE)) {
                    int fmn = min;
                    int fmx = max;
                    this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceIntegerInputOption(key, () -> {
                        try {
                            return (Integer)field.get(obj);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            return 0;
                        }
                    }, i -> {
                        try {
                            field.set(obj, fmn - fmx == 0 ? i : class_3532.method_15340((int)i, (int)fmn, (int)fmx));
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }, null));
                    continue;
                }
                if (fc.equals(Float.TYPE)) {
                    this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceFloatInputOption(key, () -> {
                        try {
                            return (Float)field.get(obj);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            return Float.valueOf(0.0f);
                        }
                    }, f -> {
                        try {
                            field.set(obj, f);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }, null));
                    continue;
                }
                if (fc.equals(Double.TYPE)) {
                    this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceDoubleInputOption(key, () -> {
                        try {
                            return (Double)field.get(obj);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            return 0.0;
                        }
                    }, d -> {
                        try {
                            field.set(obj, d);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }, null));
                    continue;
                }
                if (fc.equals(Boolean.TYPE)) {
                    this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceToggleBooleanOption(key, () -> {
                        try {
                            return (Boolean)field.get(obj);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            return false;
                        }
                    }, b -> {
                        try {
                            field.set(obj, b);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }, null));
                    continue;
                }
                if (fc.isEnum()) {
                    this.optionsWidget.addOptionEntry((SpruceOption)new LabelOption(key), (SpruceOption)new SpruceCyclingOption(key, i -> {
                        try {
                            int s = fc.getEnumConstants().length;
                            field.set(obj, fc.getEnumConstants()[Math.floorMod(((Enum)field.get(obj)).ordinal() + 1, s)]);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }, opt -> {
                        try {
                            return class_2561.method_43471((String)("cfgbarrel." + namespace + ".enum." + ((Enum)field.get(obj)).name()));
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            return class_2561.method_43473();
                        }
                    }, null));
                    continue;
                }
                this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(key, true, null));
                ArrayList<String> nParents = new ArrayList<String>();
                if (parents != null) {
                    nParents.addAll(parents);
                }
                nParents.add(field.getName());
                try {
                    this.addFields(namespace, nParents, fc, field.get(obj));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                this.optionsWidget.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption("cfgbarrel.empty", false, null));
            }
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_25394(context, mouseX, mouseY, delta);
            context.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, 8, 0xFFFFFF);
        }

        public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
            RenderUtil.renderBackgroundTexture((int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (float)0.0f, (int)64, (int)64, (int)64, (int)255);
        }

        public void method_25419() {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }

        protected void method_25426() {
            super.method_25426();
            this.optionsWidget = new SpruceOptionListWidget(Position.of((int)0, (int)22), this.field_22789, this.field_22790 - 57);
            this.optionsWidget.setBackground(this.config.config.background());
            this.addFields(this.config.name, null, this.cfgCls, this.config.config);
            this.method_37063((class_364)this.optionsWidget);
            int bottomCenter = this.field_22789 / 2 - 65;
            this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)(bottomCenter - 69), (int)(this.field_22790 - 27)), 130, 20, class_5244.field_24335, button -> this.method_25419()));
            this.method_37063((class_364)new SpruceButtonWidget(Position.of((int)(bottomCenter + 69), (int)(this.field_22790 - 27)), 130, 20, class_5244.field_24334, button -> {
                ConfigInABarrel.save(this.cfgCls, this.config);
                this.method_25419();
            }));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Value {
        public int min() default 0;

        public int max() default 0;

        public boolean gui() default true;
    }

    @Environment(value=EnvType.CLIENT)
    private static class LabelOption
    extends SpruceOption {
        public LabelOption(String key) {
            super(key);
        }

        public SpruceWidget createWidget(Position position, int width) {
            return new SpruceLabelWidget(position, (class_2561)class_2561.method_43471((String)this.key), width, w -> {}, false);
        }
    }
}

