/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.items;

import com.moigferdsrte.sandwichable.components.SandwichableDataComponent;
import com.moigferdsrte.sandwichable.config.SandwichableConfig;
import com.moigferdsrte.sandwichable.items.extra.AbstractKnifeItem;
import com.moigferdsrte.sandwichable.util.Util;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class KitchenKnifeItem
extends AbstractKnifeItem {
    public static final int[] COLORS = new int[]{4939342, 4549457, 4489825, 0x449477, 4438682, 4452557};

    public KitchenKnifeItem(class_1832 material, class_1792.class_1793 settings) {
        super(material, settings);
    }

    public static int getSharpness(class_1799 knife) {
        SandwichableConfig.KitchenKnifeOption opt;
        if (!(knife.method_7909() instanceof KitchenKnifeItem)) {
            return 0;
        }
        SharpnessData kData = (SharpnessData)knife.method_57825(SandwichableDataComponent.KITCHEN_KNIFE_SHARPNESS, (Object)SharpnessData.DEFAULT);
        if (kData.sharpnessNotSet() && (opt = Util.getConfig().getKnifeOption(knife.method_7909())) != null) {
            knife.method_57379(SandwichableDataComponent.KITCHEN_KNIFE_SHARPNESS, (Object)new SharpnessData(opt.sharpness, kData.maxSharpness));
            return opt.sharpness;
        }
        return kData.sharpness;
    }

    public static int getMaxSharpness(class_1799 knife) {
        SandwichableConfig.KitchenKnifeOption opt;
        if (!(knife.method_7909() instanceof KitchenKnifeItem)) {
            return 0;
        }
        SharpnessData kData = (SharpnessData)knife.method_57825(SandwichableDataComponent.KITCHEN_KNIFE_SHARPNESS, (Object)SharpnessData.DEFAULT);
        if (kData.maxSharpnessNotSet() && (opt = Util.getConfig().getKnifeOption(knife.method_7909())) != null) {
            knife.method_57379(SandwichableDataComponent.KITCHEN_KNIFE_SHARPNESS, (Object)new SharpnessData(kData.sharpness, opt.sharpness));
            return opt.sharpness;
        }
        return kData.maxSharpness;
    }

    public static void setSharpness(class_1799 knife, int amount) {
        if (!(knife.method_7909() instanceof KitchenKnifeItem)) {
            return;
        }
        SharpnessData kData = (SharpnessData)knife.method_57825(SandwichableDataComponent.KITCHEN_KNIFE_SHARPNESS, (Object)SharpnessData.DEFAULT);
        SandwichableConfig.KitchenKnifeOption opt = Util.getConfig().getKnifeOption(knife.method_7909());
        if (opt != null) {
            knife.method_57379(SandwichableDataComponent.KITCHEN_KNIFE_SHARPNESS, (Object)new SharpnessData(class_3532.method_15340((int)amount, (int)0, (int)KitchenKnifeItem.getMaxSharpness(knife)), kData.maxSharpness));
        }
    }

    public static float getSharpnessF(class_1799 knife) {
        return (float)KitchenKnifeItem.getSharpness(knife) / (float)KitchenKnifeItem.getMaxSharpness(knife);
    }

    public static int getItemCutAmount(class_1799 knife) {
        SandwichableConfig.KitchenKnifeOption opt = Util.getConfig().getKnifeOption(knife.method_7909());
        if (opt == null) {
            return 0;
        }
        if (!(knife.method_7909() instanceof KitchenKnifeItem)) {
            return opt.value;
        }
        return KitchenKnifeItem.itemCutAmountFrom(KitchenKnifeItem.getSharpnessF(knife), opt.value);
    }

    private static int itemCutAmountFrom(float sharpness, int knifeValue) {
        return (int)Math.ceil(sharpness * (float)knifeValue);
    }

    public static void processCut(class_1799 knife, int items) {
        if (!(knife.method_7909() instanceof KitchenKnifeItem)) {
            return;
        }
        int decrement = (int)Math.ceil((double)items * 0.7);
        KitchenKnifeItem.setSharpness(knife, KitchenKnifeItem.getSharpness(knife) - decrement);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        SandwichableConfig.KitchenKnifeOption opt = Util.getConfig().getKnifeOption(stack.method_7909());
        if (opt != null) {
            float sharpness = KitchenKnifeItem.getSharpnessF(stack);
            tooltip.add((class_2561)class_2561.method_43469((String)"kitchen_knife.tooltip.sharpness", (Object[])new Object[]{Math.round(sharpness * 100.0f)}).method_27692(class_124.field_1063));
            int itemsCut = KitchenKnifeItem.itemCutAmountFrom(sharpness, opt.value);
            tooltip.add((class_2561)class_2561.method_43469((String)("kitchen_knife.tooltip.items_cut" + (itemsCut == 1 ? "_singular" : "")), (Object[])new Object[]{itemsCut}).method_27692(class_124.field_1063));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public class_1799 method_7854() {
        class_1799 stack = super.method_7854();
        KitchenKnifeItem.getSharpness(stack);
        return stack;
    }

    public void method_54465(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_54465(stack, world, player);
        KitchenKnifeItem.getSharpness(stack);
    }

    public int method_31569(class_1799 stack) {
        return (int)(14.0f * KitchenKnifeItem.getSharpnessF(stack));
    }

    public int method_31571(class_1799 stack) {
        return COLORS[Math.round(KitchenKnifeItem.getSharpnessF(stack) * (float)(COLORS.length - 1))];
    }

    public boolean method_31567(class_1799 stack) {
        return KitchenKnifeItem.getSharpnessF(stack) < 1.0f;
    }

    public record SharpnessData(int sharpness, int maxSharpness) {
        public static final SharpnessData DEFAULT = new SharpnessData(0, 0);
        public static final Codec<SharpnessData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("sharpness").forGetter(SharpnessData::sharpness), (App)Codec.INT.fieldOf("maxSharpness").forGetter(SharpnessData::maxSharpness)).apply((Applicative)instance, SharpnessData::new));
        public static final class_9139<class_9129, SharpnessData> PACKET_CODEC = new class_9139<class_9129, SharpnessData>(){

            public SharpnessData decode(class_9129 buf) {
                int sharpness = buf.method_10816();
                int maxSharpness = buf.method_10816();
                return new SharpnessData(sharpness, maxSharpness);
            }

            public void encode(class_9129 buf, SharpnessData value) {
                buf.method_10804(value.sharpness);
                buf.method_10804(value.maxSharpness);
            }
        };

        public boolean sharpnessNotSet() {
            return this.sharpness == 0;
        }

        public boolean maxSharpnessNotSet() {
            return this.maxSharpness == 0;
        }
    }
}

