/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.util;

import com.moigferdsrte.sandwichable.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.minecraft.class_1959;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public record AncientGrainType(int color, int breadColor, int food, float saturation) {
    public static final AncientGrainType DEFAULT = new AncientGrainType(13939293, 16759403, 5, 0.65f);
    private static final Map<class_6880<class_1959>, AncientGrainType> CACHE = new HashMap<class_6880<class_1959>, AncientGrainType>();

    public static AncientGrainType from(class_6880<class_1959> entry) {
        class_1959 biome = (class_1959)entry.comp_349();
        class_5819 random = class_5819.method_43049((long)((long)(biome.method_8712() * -1.0f) << 32 | (long)(biome.field_26393.comp_846() * -1.0f)));
        float magicFoodNumber = random.method_43057();
        return new AncientGrainType(AncientGrainType.createColor(biome), AncientGrainType.createBreadColor(biome), (int)Math.floor(5.0 + (double)magicFoodNumber * 4.2), 0.95f - magicFoodNumber * 0.3f * (0.8f + random.method_43057() * 0.2f));
    }

    private static int createColor(class_1959 biome) {
        return AncientGrainType.createColor(biome.method_8712(), biome.field_26393.comp_846(), biome.method_8711(0.0, 0.0));
    }

    private static int createBreadColor(class_1959 biome) {
        return AncientGrainType.createBreadColor(biome.method_8712(), biome.field_26393.comp_846());
    }

    private static int createColor(float temperature, float precipitation, int grassColor) {
        temperature = 1.0f - temperature * 0.5f;
        float x = 0.85f * precipitation + 0.15f;
        float y = 0.75f * temperature + 0.15f;
        x = (float)((double)x + 0.2 * Math.sin(13.0f * precipitation));
        y = (float)((double)y + 0.15 * Math.sin(17.0f * temperature));
        float avg = 0.5f * (x + y);
        float sum = x + y;
        float dif = x - y;
        float mul = (float)(0.5 * (0.9 + 0.2 * Math.sin(sum * 90.0f))) * 255.0f;
        float grassR = (float)(Util.getRed(grassColor) + 200) / 500.0f;
        float grassG = (float)(Util.getGreen(grassColor) + 255) / 500.0f;
        float grassB = (float)(Util.getBlue(grassColor) + 60) / 365.0f;
        int r = (int)((Math.cos((double)avg - 0.2) + (double)grassR) * (double)mul);
        int g = (int)((Math.sin((double)avg + 0.15) + (double)grassG) * (double)mul);
        int b = (int)((0.3 + 0.75 * Math.sin(dif) + (double)grassB) * (double)mul);
        return Util.getColor(Math.min(r, 255), Math.min(g, 255), Math.min(b, 255));
    }

    private static int createBreadColor(float temperature, float precipitation) {
        temperature = 1.0f - temperature * 0.5f;
        float r = 1.0f - 0.2f * temperature;
        float g = 0.3f + 0.2f * (precipitation + temperature);
        float b = 0.3f * temperature - 0.1f;
        float mul = 0.1f + (float)(0.05 * Math.sin((temperature + precipitation) * 120.0f));
        r = (r + 1.0f) * 0.5f + mul;
        g = (g + 0.95f) * 0.5f + mul;
        b = (b + 0.8f) * 0.5f + mul;
        return Util.getColor(Math.min((int)(r * 255.0f), 255), Math.min((int)(g * 255.0f), 255), Math.min((int)(b * 255.0f), 255));
    }

    public static AncientGrainType get(class_6880<class_1959> biome) {
        if (biome != null && !CACHE.containsKey(biome)) {
            CACHE.put(biome, AncientGrainType.from(biome));
        }
        return CACHE.getOrDefault(biome, DEFAULT);
    }

    public static void reset() {
        CACHE.clear();
    }

    public static void init() {
        DynamicRegistrySetupCallback.EVENT.register(manager -> AncientGrainType.reset());
    }
}

