/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.util;

import com.google.common.collect.Maps;
import com.moigferdsrte.sandwichable.Sandwichable;
import com.moigferdsrte.sandwichable.blocks.extra.BasinContent;
import com.moigferdsrte.sandwichable.blocks.extra.BasinContentType;
import com.moigferdsrte.sandwichable.items.extra.CheeseType;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class CheeseRegistry {
    public static final CheeseRegistry INSTANCE = new CheeseRegistry();
    private final Map<String, CheeseType> cheeseTypes = Maps.newHashMap();
    private final Map<String, BasinContent> basinContents = Maps.newHashMap();
    private final Map<CheeseType, BasinContent> typeToCheese = Maps.newHashMap();
    private final Map<CheeseType, BasinContent> typeToFermentingMilk = Maps.newHashMap();
    private final Map<CheeseType, class_1792> typeToCheeseItem = Maps.newHashMap();

    private CheeseRegistry() {
        this.typeToCheeseItem.put(CheeseType.REGULAR, class_1802.field_8550);
        this.typeToCheeseItem.put(CheeseType.CREAMY, class_1802.field_8550);
        this.typeToCheeseItem.put(CheeseType.INTOXICATING, class_1802.field_8550);
        this.typeToCheeseItem.put(CheeseType.SOUR, class_1802.field_8550);
        this.typeToCheeseItem.put(CheeseType.CANDESCENT, class_1802.field_8550);
        this.typeToCheeseItem.put(CheeseType.WARPED_BLEU, class_1802.field_8550);
    }

    public void register(CheeseType type) {
        this.cheeseTypes.put(type.toString(), type);
    }

    public void register(BasinContent type) {
        this.basinContents.put(type.toString(), type);
        if (type.getContentType() == BasinContentType.CHEESE) {
            this.typeToCheese.put(type.getCheeseType(), type);
        } else if (type.getContentType() == BasinContentType.FERMENTING_MILK) {
            this.typeToFermentingMilk.put(type.getCheeseType(), type);
        }
    }

    public BasinContent basinContentFromString(String id) {
        return this.basinContents.get(id);
    }

    public CheeseType cheeseTypeFromString(String id) {
        return this.cheeseTypes.get(id);
    }

    public BasinContent cheeseFromCheeseType(CheeseType type) {
        return this.typeToCheese.get((Object)type);
    }

    public class_1799 cheeseItemFromCheeseType(CheeseType type) {
        if (type == null) {
            Sandwichable.LOGGER.error("NULL CheeseType");
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)this.typeToCheeseItem.get((Object)type));
    }

    public BasinContent fermentingMilkFromCheeseType(CheeseType type) {
        return this.typeToFermentingMilk.get((Object)type);
    }
}

