/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.util;

import com.moigferdsrte.sandwichable.Sandwichable;
import com.moigferdsrte.sandwichable.items.SpreadItem;
import com.moigferdsrte.sandwichable.items.spread.SpreadType;
import com.moigferdsrte.sandwichable.registry.BlocksRegistry;
import com.moigferdsrte.sandwichable.util.RenderFlags;
import com.moigferdsrte.sandwichable.util.SpreadRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4174;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class Sandwich {
    private final ArrayList<class_1799> foods = new ArrayList();

    public boolean addFood(class_1657 player, class_1799 stack) {
        int maxSize = player.method_37908().method_8450().method_8356(Sandwichable.SANDWICH_SIZE_RULE);
        if (stack.method_7909() == BlocksRegistry.SANDWICH.method_8389()) {
            return false;
        }
        if (maxSize >= 0 && this.getSize() >= maxSize && Sandwich.canAdd(stack)) {
            player.method_7353((class_2561)class_2561.method_43469((String)"message.sandwichtable.maxSize", (Object[])new Object[]{maxSize}).method_27692(class_124.field_1061), true);
            return false;
        }
        class_1799 g = this.addTopFoodFrom(player.method_7337() ? stack.method_7972() : stack);
        if (g == null) {
            return false;
        }
        if (!g.method_7960() && !player.method_7337()) {
            player.method_7270(g);
        }
        return true;
    }

    public static boolean canAdd(class_1799 stack) {
        return stack.method_57826(class_9334.field_50075) || SpreadRegistry.INSTANCE.itemHasSpread((class_1935)stack.method_7909());
    }

    public class_1799 tryAddTopFoodFrom(class_1937 world, class_1799 stack) {
        int maxSize = world.method_8450().method_8356(Sandwichable.SANDWICH_SIZE_RULE);
        if (maxSize >= 0 && this.getSize() >= maxSize && Sandwich.canAdd(stack)) {
            return null;
        }
        return this.addTopFoodFrom(stack);
    }

    public class_1799 addTopFoodFrom(class_1799 stack) {
        if (stack.method_7909() == BlocksRegistry.SANDWICH.method_8389()) {
            return stack;
        }
        if (SpreadRegistry.INSTANCE.itemHasSpread((class_1935)stack.method_7909())) {
            SpreadType spreadType = SpreadRegistry.INSTANCE.getSpreadFromItem((class_1935)stack.method_7909());
            class_1799 spread = new class_1799((class_1935)SpreadRegistry.INSTANCE.getItem(spreadType), 1);
            class_2487 nbtCompound = new class_2487();
            spreadType.onPour(stack, spread, nbtCompound);
            nbtCompound.method_10582("spreadType", SpreadRegistry.INSTANCE.asString(spreadType));
            class_9279.method_57453((class_9331)class_9334.field_49628, (class_1799)spread, (class_2487)nbtCompound);
            if (!this.foods.isEmpty()) {
                class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)spread, nbt -> nbt.method_10556("onLoaf", this.foods.get(0).method_31573(Sandwichable.BREAD_LOAVES)));
            }
            this.foods.add(spread);
            class_1799 r = spreadType.getResultItem();
            stack.method_7934(1);
            return r;
        }
        if (stack.method_57826(class_9334.field_50075)) {
            this.foods.add(stack.method_7971(1));
            return class_1799.field_8037;
        }
        return null;
    }

    public class_1799 removeTopFood() {
        if (!this.foods.isEmpty()) {
            return this.fixForEject(this.foods.remove(this.foods.size() - 1));
        }
        return class_1799.field_8037;
    }

    public class_1799 getTopFood() {
        return !this.foods.isEmpty() ? this.foods.get(this.foods.size() - 1) : class_1799.field_8037;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_1799> getFoodList() {
        ArrayList<class_1799> arrayList = this.foods;
        synchronized (arrayList) {
            return new ArrayList<class_1799>(this.foods);
        }
    }

    public void setFoodList(List<class_1799> list) {
        this.foods.clear();
        this.foods.addAll(list);
    }

    public void clearFoodList() {
        this.foods.clear();
    }

    public int getSize() {
        return this.foods.size();
    }

    public void putDisplayValues(class_2487 tag) {
        class_2487 displayValues = new class_2487();
        int h = 0;
        float s = 0.0f;
        for (class_1799 item : this.foods) {
            if (!item.method_57826(class_9334.field_50075)) continue;
            h += ((class_4174)item.method_57824(class_9334.field_50075)).comp_2491();
            s += ((class_4174)item.method_57824(class_9334.field_50075)).comp_2492();
        }
        displayValues.method_10569("hunger", h);
        displayValues.method_10548("saturation", s /= (float)Math.max(this.foods.size(), 1));
        tag.method_10566("DisplayValues", (class_2520)displayValues);
    }

    public static DisplayValues getDisplayValues(class_2487 displayValuesTag) {
        return new DisplayValues(displayValuesTag.method_10550("hunger"), displayValuesTag.method_10583("saturation"));
    }

    public class_2487 writeToNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (class_1799 stack : this.foods) {
            if (stack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            class_2960 identifier = class_7923.field_41178.method_10221((Object)stack.method_7909());
            nbtCompound.method_10582("id", identifier.toString());
            nbtCompound.method_10567("Count", (byte)stack.method_7947());
            if (stack.method_57826(class_9334.field_49628)) {
                nbtCompound.method_10566("tag", (class_2520)((class_9279)stack.method_57824(class_9334.field_49628)).method_57461());
            }
            list.add((Object)nbtCompound);
        }
        nbt.method_10566("Items", (class_2520)list);
        nbt.method_10582("id", "Contents");
        return nbt;
    }

    public void setFromNbt(class_2487 nbt, class_7225.class_7874 registries) {
        this.clearFoodList();
        this.addFromNbt(nbt, registries);
    }

    public void addFromNbt(class_2487 nbt, class_7225.class_7874 registries) {
        class_2499 list = nbt.method_10554("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 stackTag = list.method_10602(i);
            class_1799 stack = class_1799.method_57360((class_7225.class_7874)registries, (class_2520)stackTag).orElse(new class_1799((class_1935)class_1802.field_8229));
            if (stackTag.method_10545("tag")) {
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)stackTag.method_10562("tag")));
            }
            if (stack.method_7909() == BlocksRegistry.SANDWICH.method_8389()) continue;
            this.foods.add(stack);
        }
    }

    private class_1799 fixForEject(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49628) && ((class_9279)stack.method_57824(class_9334.field_49628)).method_57461().method_10545("s")) {
            class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, nbtCompound -> nbtCompound.method_10551("s"));
        }
        return stack;
    }

    public boolean isEmpty() {
        return this.foods.isEmpty();
    }

    public boolean isComplete() {
        return this.hasBreadBottom() && this.hasBreadTop() && this.getSize() >= 2;
    }

    public boolean hasBreadBottom() {
        return this.getSize() > 0 && Sandwichable.isBread(this.foods.get(0));
    }

    public boolean hasBreadTop() {
        return Sandwichable.isBread(this.getTopFood());
    }

    public class_1799 createSandwich() {
        if (this.isComplete()) {
            class_1799 item = new class_1799((class_1935)BlocksRegistry.SANDWICH);
            class_2487 tag = this.writeToNbt(new class_2487());
            this.putDisplayValues(tag);
            if (!tag.method_33133()) {
                item.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)tag));
            }
            return item;
        }
        return class_1799.field_8037;
    }

    public void ejectSandwich(class_1937 world, class_243 pos) {
        if (this.getSize() > 0) {
            if (this.isComplete()) {
                class_1799 item = this.createSandwich();
                class_1542 itemEntity = new class_1542(world, pos.method_10216(), pos.method_10214() + 1.2, pos.method_10215(), item);
                itemEntity.method_6988();
                this.clearFoodList();
                world.method_8649((class_1297)itemEntity);
            } else {
                for (class_1799 stack : this.foods) {
                    if (stack.method_7960() || stack.method_7909() instanceof SpreadItem) continue;
                    class_1542 item = new class_1542(world, pos.method_10216(), pos.method_10214() + 1.2, pos.method_10215(), this.fixForEject(stack));
                    item.method_6988();
                    world.method_8649((class_1297)item);
                }
                this.clearFoodList();
            }
        }
    }

    public void ejectTopFood(class_1937 world, class_243 pos) {
        class_1542 item = new class_1542(world, pos.method_10216(), pos.method_10214() + 1.2, pos.method_10215(), this.removeTopFood());
        item.method_6988();
        world.method_8649((class_1297)item);
    }

    public void interact(class_1937 world, class_243 pos, class_1657 player, class_1268 hand, boolean intendsRemoval, class_7225.class_7874 registries) {
        class_1799 stack = player.method_5998(hand);
        int maxSize = world.method_8450().method_8356(Sandwichable.SANDWICH_SIZE_RULE);
        if (stack.method_7909().equals(BlocksRegistry.SANDWICH.method_8389())) {
            if (stack.method_57826(class_9334.field_49611)) {
                class_2487 tag = ((class_9279)stack.method_57824(class_9334.field_49611)).method_57461();
                if (maxSize >= 0) {
                    Sandwich toAdd = new Sandwich();
                    toAdd.addFromNbt(tag, registries);
                    if (toAdd.getSize() + this.getSize() > maxSize) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"message.sandwichtable.maxSize", (Object[])new Object[]{maxSize}).method_27692(class_124.field_1061), true);
                        return;
                    }
                }
                this.addFromNbt(tag, registries);
                stack.method_7934(1);
            }
        } else if (!this.hasBreadBottom() && !Sandwichable.isBread(stack)) {
            if (stack.method_57826(class_9334.field_50075)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.sandwichtable.bottombread"), true);
            }
        } else if (!this.addFood(player, stack) && stack.method_7960()) {
            if (intendsRemoval) {
                if (this.isComplete()) {
                    this.ejectSandwich(world, pos);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.sandwichtable.topbread"), true);
                }
            } else if (!this.isEmpty()) {
                if (!player.method_7337()) {
                    this.ejectTopFood(world, pos);
                } else {
                    this.removeTopFood();
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        int i = 0;
        for (class_1799 food : this.foods) {
            RenderFlags.RENDERING_SANDWICH_ITEM = i % 3 + 1;
            class_310.method_1551().method_1480().method_23178(food, class_811.field_4318, light, overlay, matrices, vertexConsumers, null, Objects.hash(i));
            matrices.method_22904(0.0, 0.0, -0.03124);
            ++i;
        }
        RenderFlags.RENDERING_SANDWICH_ITEM = 0;
    }

    public record DisplayValues(int hunger, float saturation) {
    }
}

