/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.worldgen;

import com.google.common.collect.Lists;
import com.moigferdsrte.sandwichable.util.Util;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3785;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VillagerHouses {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)Util.MOD_ID);
    private static final class_2960 PLAINS = class_2960.method_12829((String)"minecraft:village/plains/houses");
    private static final class_2960 SNOWY = class_2960.method_12829((String)"minecraft:village/snowy/houses");
    private static final class_2960 SAVANNA = class_2960.method_12829((String)"minecraft:village/savanna/houses");
    private static final class_2960 DESERT = class_2960.method_12829((String)"minecraft:village/desert/houses");
    private static final class_2960 TAIGA = class_2960.method_12829((String)"minecraft:village/taiga/houses");
    private static boolean initializationSuccessful = false;
    private static boolean initializationAttempted = false;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            class_5455.class_6890 registryAccess = minecraftServer.method_30611();
            VillagerHouses.addBuildingToPool((class_5455)registryAccess, PLAINS, "village/plains/houses/plains_sandwich_stand", 4);
            VillagerHouses.addBuildingToPool((class_5455)registryAccess, SNOWY, "village/snowy/houses/snowy_sandwich_stand", 4);
            VillagerHouses.addBuildingToPool((class_5455)registryAccess, SAVANNA, "village/savanna/houses/savanna_sandwich_stand", 4);
            VillagerHouses.addBuildingToPool((class_5455)registryAccess, DESERT, "village/desert/houses/desert_sandwich_stand", 4);
            VillagerHouses.addBuildingToPool((class_5455)registryAccess, TAIGA, "village/taiga/houses/taiga_sandwich_stand", 4);
        });
    }

    public static void addBuildingToPool(class_5455 registryAccess, class_2960 poolId, String structId, int weight) {
        if (initializationAttempted && !initializationSuccessful) {
            return;
        }
        try {
            Optional templatePools = registryAccess.method_33310(class_7924.field_41249);
            if (templatePools.isEmpty()) {
                LOGGER.warn("Template pools registry is empty for pool: {}", (Object)poolId);
                return;
            }
            Optional processorLists = registryAccess.method_33310(class_7924.field_41247);
            if (processorLists.isEmpty()) {
                LOGGER.warn("Processor lists registry is empty for pool: {}", (Object)poolId);
                return;
            }
            class_3785 pool = (class_3785)((class_2378)templatePools.get()).method_10223(poolId);
            if (pool == null) {
                LOGGER.warn("Structure pool not found: {}", (Object)poolId);
                return;
            }
            ArrayList newRawTemplates = Lists.newArrayList((Iterable)pool.field_16864);
            CharSequence[] possibleFieldNames = new String[]{"rawTemplates", "field_16864", "elementCounts"};
            boolean fieldFound = false;
            for (String string : possibleFieldNames) {
                try {
                    Field rawTemplatesField = class_3785.class.getDeclaredField(string);
                    rawTemplatesField.setAccessible(true);
                    rawTemplatesField.set(pool, newRawTemplates);
                    fieldFound = true;
                    LOGGER.debug("Successfully updated field '{}' for pool: {}", (Object)string, (Object)poolId);
                    initializationSuccessful = true;
                    break;
                }
                catch (NoSuchFieldException e) {
                    LOGGER.debug("Field '{}' not found, trying next possible field name", (Object)string);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to set field '{}' for pool {}: {}", new Object[]{string, poolId, e.getMessage()});
                }
            }
            if (!fieldFound) {
                LOGGER.error("Failed to find any valid field for rawTemplates in StructureTemplatePool. Tried: {}", (Object)String.join((CharSequence)", ", possibleFieldNames));
                initializationSuccessful = false;
                initializationAttempted = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to add village structure to pool {}: {}", (Object)poolId, (Object)e.getMessage());
            throw new RuntimeException("Failed to add village structure", e);
        }
    }
}

