/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.sandwichable.blocks.entity;

import com.moigferdsrte.sandwichable.Sandwichable;
import com.moigferdsrte.sandwichable.blocks.DesalinatorBlock;
import com.moigferdsrte.sandwichable.blocks.entity.screen.DesalinatorScreenHandler;
import com.moigferdsrte.sandwichable.blocks.entity.screen.data.DesalinatorPos;
import com.moigferdsrte.sandwichable.blocks.extra.FluidType;
import com.moigferdsrte.sandwichable.blocks.extra.SyncedBlockEntity;
import com.moigferdsrte.sandwichable.config.SandwichableConfig;
import com.moigferdsrte.sandwichable.registry.BlocksRegistry;
import com.moigferdsrte.sandwichable.util.Util;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DesalinatorBlockEntity
extends class_2624
implements ExtendedScreenHandlerFactory<DesalinatorPos>,
class_1278,
SyncedBlockEntity {
    private class_2371<class_1799> inventory;
    private int fluidAmount = 0;
    private int evaporateProgress = 0;
    private int fuelBurnProgress = 0;
    private boolean isPickleBrine = false;
    private boolean burning = false;
    private boolean evaporating;
    private boolean wasEvaporating = this.evaporating = false;
    public static final int maxFluidAmount = 4;
    public static final int evaporateTime = 185;
    public static final int fuelBurnTime = 990;

    public DesalinatorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlocksRegistry.DESALINATOR_BLOCKENTITY, pos, state);
        this.inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        this.fluidAmount = nbt.method_10550("waterAmount");
        this.evaporateProgress = nbt.method_10550("evaporateProgress");
        this.fuelBurnProgress = nbt.method_10550("fuelBurnProgress");
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("waterAmount", this.fluidAmount);
        nbt.method_10569("evaporateProgress", this.evaporateProgress);
        nbt.method_10569("fuelBurnProgress", this.fuelBurnProgress);
    }

    private void finishEvaporating() {
        --this.fluidAmount;
        if (this.isWaterSaline()) {
            if (((class_1799)this.inventory.get(1)).method_7960()) {
                SandwichableConfig config = Util.getConfig();
                this.inventory.set(1, (Object)config.itemOptions.saltItemGetter.get().method_7972());
            } else {
                ((class_1799)this.inventory.get(1)).method_7933(1);
            }
        }
        this.evaporateProgress = 0;
        this.evaporating = false;
        this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)DesalinatorBlock.ON, (Comparable)Boolean.valueOf(false)));
        this.method_5431();
    }

    private void stopBurning() {
        this.burning = false;
        this.fuelBurnProgress = 0;
        this.method_5431();
    }

    private void startBurning() {
        this.burning = true;
        this.method_5431();
    }

    private void startEvaporating() {
        class_1799 salt = Util.getConfig().itemOptions.saltItemGetter.get();
        class_1799 invStack = (class_1799)this.inventory.get(1);
        if (invStack.method_7960() || class_1799.method_7984((class_1799)invStack, (class_1799)salt) && invStack.method_7947() < salt.method_7909().method_7882()) {
            this.evaporating = true;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)DesalinatorBlock.ON, (Comparable)Boolean.valueOf(true)));
            this.method_5431();
        }
    }

    private void tryUpdateStateToOff() {
        if (((Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)DesalinatorBlock.ON)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)DesalinatorBlock.ON, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DesalinatorBlockEntity self) {
        if (world.method_8320(pos).method_26204() == BlocksRegistry.DESALINATOR) {
            FluidType fluid;
            if (((class_1799)self.inventory.get(0)).method_7947() > 0 && self.fluidAmount > 0) {
                if (!self.burning) {
                    ((class_1799)self.inventory.get(0)).method_7934(1);
                    self.startBurning();
                }
                self.method_5431();
            }
            if (self.burning) {
                ++self.fuelBurnProgress;
                if (self.fuelBurnProgress == 990) {
                    self.stopBurning();
                }
                if (self.fluidAmount > 0 && !self.evaporating && ((class_1799)self.inventory.get(1)).method_7947() < 64) {
                    self.startEvaporating();
                }
                self.method_5431();
            }
            if (self.evaporating && self.burning) {
                self.evaporateProgress = self.evaporateProgress + (self.isPickleBrine ? 1 : 2);
                if (self.evaporateProgress >= 185) {
                    self.finishEvaporating();
                }
                world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 0.0, 0.07, 0.0);
            }
            if (self.evaporating && !self.burning) {
                self.evaporating = false;
                self.tryUpdateStateToOff();
            }
            if (!self.evaporating && self.evaporateProgress > 0) {
                --self.evaporateProgress;
            }
            if ((fluid = (FluidType)((Object)world.method_8320(pos).method_11654(DesalinatorBlock.FLUID))) != FluidType.NONE && self.fluidAmount < 4 && (fluid == FluidType.PICKLE_BRINE == self.isPickleBrine || self.fluidAmount == 0)) {
                self.isPickleBrine = fluid == FluidType.PICKLE_BRINE;
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657(DesalinatorBlock.FLUID, (Comparable)((Object)FluidType.NONE)));
                ++self.fluidAmount;
                world.method_8408(pos, world.method_8320(pos).method_26204());
            }
        }
        if (self.evaporateProgress % 6 == 0 || self.evaporating != self.wasEvaporating) {
            class_3414 sound = null;
            if (self.evaporating && !self.wasEvaporating) {
                sound = Sandwichable.DESALINATOR_START;
            } else if (!self.evaporating && self.wasEvaporating) {
                sound = Sandwichable.DESALINATOR_STOP;
            } else if (self.evaporating) {
                sound = Sandwichable.DESALINATOR_RUN;
            }
            if (sound != null) {
                world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, sound, class_3419.field_15245, 0.4f, 1.0f, false);
            }
        }
        self.wasEvaporating = self.evaporating;
    }

    public int getEvaporateProgress() {
        return this.evaporateProgress;
    }

    public int getFuelBurnProgress() {
        return this.fuelBurnProgress;
    }

    public int getWaterAmount() {
        return this.fluidAmount;
    }

    public boolean isBurning() {
        return this.burning;
    }

    public boolean isPickleBrine() {
        return this.isPickleBrine;
    }

    public boolean isWaterSaline() {
        return this.isPickleBrine || this.field_11863.method_23753(this.field_11867).method_40220(Sandwichable.SALT_WATER_BODIES) || this.field_11863.method_8320(this.field_11867.method_10074()).method_26164(Sandwichable.SALT_PRODUCING_BLOCKS);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.sandwichable.desalinator");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new DesalinatorScreenHandler(syncId, playerInventory, (class_1263)this);
    }

    public int method_5439() {
        return 2;
    }

    public boolean method_5442() {
        return ((class_1799)this.inventory.get(0)).method_7960() && ((class_1799)this.inventory.get(1)).method_7960();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5441(int slot) {
        this.method_5431();
        return (class_1799)this.inventory.remove(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        this.method_5431();
        return ((class_1799)this.inventory.get(slot)).method_7971(amount);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0 && stack.method_7909() == class_1802.field_8725) {
            this.inventory.set(slot, (Object)stack);
        }
        this.method_5431();
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        if (slot == 0) {
            return stack.method_7909() == class_1802.field_8725;
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return this.getPacket();
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public DesalinatorPos getScreenOpeningData(class_3222 player) {
        return new DesalinatorPos(this.field_11867);
    }
}

