/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelkhoirin<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"modelkhoirin"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart left_wing;
    public final ModelPart right_wing;

    public Modelkhoirin(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.left_wing = root.getChild("left_wing");
        this.right_wing = root.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 24).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 4).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)6.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 1.0f, -7.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(-1.0f, 0.0f, -7.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(31, 35).addBox(-3.0f, -2.0f, -5.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)-6.0f));
        PartDefinition left_wing = partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 12).addBox(5.6868f, -1.6211f, -6.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offset((float)3.0f, (float)18.0f, (float)-3.0f));
        PartDefinition cube_r2 = left_wing.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -6.0f, 6.0f, 0.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition right_wing = partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(-17.6868f, -1.6211f, -6.0f, 12.0f, 0.0f, 12.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offset((float)-3.0f, (float)18.0f, (float)-3.0f));
        PartDefinition cube_r3 = right_wing.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-6.0f, 0.0f, -6.0f, 6.0f, 0.0f, 12.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_wing.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_wing.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_wing.yRot = Mth.sin((float)(ageInTicks * 0.6f)) * 0.6f;
        this.left_wing.yRot = Mth.sin((float)(ageInTicks * 0.6f + 3.0f)) * 0.6f;
    }
}

