/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.entity;

import net.eternal_tales.entity.AlbinoTarkoEntity;
import net.eternal_tales.entity.CrimsonTarkoEntity;
import net.eternal_tales.entity.CyanTarkoEntity;
import net.eternal_tales.entity.GreenTarkoEntity;
import net.eternal_tales.init.EternalTalesModEntities;
import net.eternal_tales.init.EternalTalesModItems;
import net.eternal_tales.procedures.RaccoonModelVisualScaleProcedure;
import net.eternal_tales.procedures.RayanaRockhopperPenguinOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class RayanaRockhopperPenguinEntity
extends Animal {
    public RayanaRockhopperPenguinEntity(EntityType<RayanaRockhopperPenguinEntity> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AlbinoTarkoEntity.class, 16.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CrimsonTarkoEntity.class, 16.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, CyanTarkoEntity.class, 16.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, GreenTarkoEntity.class, 16.0f, 1.0, 1.2));
        this.goalSelector.addGoal(5, (Goal)new PanicGoal((PathfinderMob)this, 1.8));
        this.goalSelector.addGoal(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void baseTick() {
        super.baseTick();
        RayanaRockhopperPenguinOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        RayanaRockhopperPenguinEntity retval = (RayanaRockhopperPenguinEntity)((EntityType)EternalTalesModEntities.RAYANA_ROCKHOPPER_PENGUIN.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.CATFISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.CREEPER_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.GOLDFISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.SANDFISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.ILLUMINATI_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.RAINBOW_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.PRISMATIC_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.NETHER_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.WARPED_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.SALT_FISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.COOKED_CATFISH.get())}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COD)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.SALMON)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.TROPICAL_FISH)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COOKED_COD)}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COOKED_SALMON)}), Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"forge:fish")))}).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        RayanaRockhopperPenguinEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)RaccoonModelVisualScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)EternalTalesModEntities.RAYANA_ROCKHOPPER_PENGUIN.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 2.3);
        return builder;
    }
}

