/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.fluid;

import net.eternal_tales.init.EternalTalesModBlocks;
import net.eternal_tales.init.EternalTalesModFluidTypes;
import net.eternal_tales.init.EternalTalesModFluids;
import net.eternal_tales.init.EternalTalesModItems;
import net.eternal_tales.init.EternalTalesModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class BlackWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)EternalTalesModFluidTypes.BLACK_WATER_TYPE.get(), () -> (Fluid)EternalTalesModFluids.BLACK_WATER.get(), () -> (Fluid)EternalTalesModFluids.FLOWING_BLACK_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)EternalTalesModItems.BLACK_WATER_BUCKET.get()).block(() -> (LiquidBlock)EternalTalesModBlocks.BLACK_WATER.get());

    private BlackWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)EternalTalesModParticleTypes.BLACK_WATER_DRIP_PARTICLE.get();
    }

    public static class Flowing
    extends BlackWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends BlackWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

