/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.eternal_tales.init.EternalTalesModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class EternalTalesModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry levelStemTypeRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().registryOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            NoiseBasedChunkGenerator noiseGenerator;
            Object parameters;
            MultiNoiseBiomeSource noiseSource;
            ChunkGenerator chunkGenerator;
            Holder dimensionType = levelStem.type();
            if (dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) {
                chunkGenerator = levelStem.generator();
                BiomeSource biomeSource = chunkGenerator.getBiomeSource();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    parameters = new ArrayList(noiseSource.parameters().values());
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.45f, (float)0.2f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.span((float)-0.19f, (float)0.1f), Climate.Parameter.span((float)0.55f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_beach")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.45f, (float)0.2f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.span((float)-0.19f, (float)0.1f), Climate.Parameter.span((float)0.55f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_beach")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)-0.3f, (float)0.2f), Climate.Parameter.span((float)-1.05f, (float)-0.455f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_abyss")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)-0.3f, (float)0.2f), Climate.Parameter.span((float)-1.05f, (float)-0.455f), Climate.Parameter.span((float)-1.0f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_abyss")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)0.3f, (float)2.0f), Climate.Parameter.span((float)-0.7799f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_cliffs")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)0.3f, (float)2.0f), Climate.Parameter.span((float)-0.7799f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_cliffs")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.018f, (float)0.5f), Climate.Parameter.span((float)-0.014f, (float)0.1f), Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)0.1f, (float)0.9f), Climate.Parameter.span((float)0.2f, (float)0.9f), Climate.Parameter.span((float)-0.865767f, (float)-0.5f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_caves")))));
                    EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)1.0f), Climate.Parameter.span((float)0.45f, (float)0.47f), Climate.Parameter.span((float)-2.0f, (float)0.0f), Climate.Parameter.span((float)-1.0f, (float)-0.5f), Climate.Parameter.span((float)0.2f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"geobstractsite_biome")))));
                    chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList((List)parameters));
                    chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
                }
                if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                    noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                    ((EternalTalesModNoiseGeneratorSettings)noiseGenerator.settings.value()).seteternal_talesDimensionTypeReference((Holder<DimensionType>)dimensionType);
                }
            }
            if (!dimensionType.is(BuiltinDimensionTypes.NETHER)) continue;
            chunkGenerator = levelStem.generator();
            parameters = chunkGenerator.getBiomeSource();
            if (parameters instanceof MultiNoiseBiomeSource) {
                noiseSource = (MultiNoiseBiomeSource)parameters;
                parameters = new ArrayList(noiseSource.parameters().values());
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.8f, (float)0.8001f), Climate.Parameter.span((float)-1.0f, (float)0.2f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"bleeding_caverns")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.8f, (float)0.8001f), Climate.Parameter.span((float)-1.0f, (float)0.2f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"bleeding_caverns")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.5002f), Climate.Parameter.span((float)0.2f, (float)0.201f), Climate.Parameter.span((float)0.3002f, (float)1.0002f), Climate.Parameter.span((float)-0.4998f, (float)0.5002f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.9998f, (float)1.0002f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"blazing_wastes")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.5002f), Climate.Parameter.span((float)0.2f, (float)0.201f), Climate.Parameter.span((float)0.3002f, (float)1.0002f), Climate.Parameter.span((float)-0.4998f, (float)0.5002f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.9998f, (float)1.0002f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"blazing_wastes")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.4998f), Climate.Parameter.span((float)-0.5f, (float)0.0f), Climate.Parameter.span((float)0.2998f, (float)0.9998f), Climate.Parameter.span((float)-0.5002f, (float)0.4998f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0002f, (float)0.9998f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"profaned_forest")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.4998f), Climate.Parameter.span((float)-0.5f, (float)0.0f), Climate.Parameter.span((float)0.2998f, (float)0.9998f), Climate.Parameter.span((float)-0.5002f, (float)0.4998f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0002f, (float)0.9998f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"profaned_forest")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)-0.4999f), Climate.Parameter.span((float)0.001f, (float)0.002f), Climate.Parameter.span((float)0.18f, (float)1.0002f), Climate.Parameter.span((float)-0.5003f, (float)0.5003f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0003f, (float)1.0003f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"nether_ferboterum")))));
                EternalTalesModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)-0.4999f), Climate.Parameter.span((float)0.001f, (float)0.002f), Climate.Parameter.span((float)0.18f, (float)1.0002f), Climate.Parameter.span((float)-0.5003f, (float)0.5003f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0003f, (float)1.0003f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"nether_ferboterum")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList((List)parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            ((EternalTalesModNoiseGeneratorSettings)noiseGenerator.settings.value()).seteternal_talesDimensionTypeReference((Holder<DimensionType>)dimensionType);
        }
    }

    public static SurfaceRules.RuleSource adaptSurfaceRule(SurfaceRules.RuleSource currentRuleSource, Holder<DimensionType> dimensionType) {
        if (dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) {
            return EternalTalesModBiomes.injectOverworldSurfaceRules(currentRuleSource);
        }
        if (dimensionType.is(BuiltinDimensionTypes.NETHER)) {
            return EternalTalesModBiomes.injectNetherSurfaceRules(currentRuleSource);
        }
        return currentRuleSource;
    }

    private static SurfaceRules.RuleSource injectOverworldSurfaceRules(SurfaceRules.RuleSource currentRuleSource) {
        ArrayList<SurfaceRules.RuleSource> customSurfaceRules = new ArrayList<SurfaceRules.RuleSource>();
        customSurfaceRules.add(EternalTalesModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_caves")), ((Block)EternalTalesModBlocks.MUCUNFECTIO_STONE.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_STONE.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_GRAVEL.get()).defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"geobstractsite_biome")), ((Block)EternalTalesModBlocks.GEOBSTRACTSITE.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.GEOBSTRACTSITE.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.GEOBSTRACTSITE.get()).defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_beach")), ((Block)EternalTalesModBlocks.MUCUNFECTIO_SAND.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_SAND.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_GRAVEL.get()).defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_abyss")), ((Block)EternalTalesModBlocks.MUCUNFECTIO_SAND.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_STONE.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_STONE.get()).defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"mucunfectio_cliffs")), ((Block)EternalTalesModBlocks.MUCUNFECTIO_SAND.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_STONE.get()).defaultBlockState(), ((Block)EternalTalesModBlocks.MUCUNFECTIO_GRAVEL.get()).defaultBlockState()));
        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            customSurfaceRules.addAll(sequenceRuleSource.sequence());
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
        }
        customSurfaceRules.add(currentRuleSource);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource injectNetherSurfaceRules(SurfaceRules.RuleSource currentRuleSource) {
        ArrayList<SurfaceRules.RuleSource> customSurfaceRules = new ArrayList<SurfaceRules.RuleSource>();
        customSurfaceRules.add(EternalTalesModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"bleeding_caverns")), ((Block)EternalTalesModBlocks.BLEED_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"blazing_wastes")), ((Block)EternalTalesModBlocks.BLAZING_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"profaned_forest")), ((Block)EternalTalesModBlocks.PROFANED_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
        customSurfaceRules.add(EternalTalesModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"nether_ferboterum")), ((Block)EternalTalesModBlocks.FERBALIC_GROUND.get()).defaultBlockState(), Blocks.SOUL_SOIL.defaultBlockState(), Blocks.SOUL_SOIL.defaultBlockState()));
        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            customSurfaceRules.addAll(sequenceRuleSource.sequence());
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
        }
        customSurfaceRules.add(currentRuleSource);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.aboveBottom((int)5), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}))));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    public static interface EternalTalesModNoiseGeneratorSettings {
        public void seteternal_talesDimensionTypeReference(Holder<DimensionType> var1);
    }
}

