/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.item;

import java.util.List;
import net.eternal_tales.init.EternalTalesModItems;
import net.eternal_tales.procedures.BattleTorchRightClickedOnBlockProcedure;
import net.eternal_tales.procedures.SoulBattleTorchLivingEntityIsHitWithToolProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SoulBattleTorchItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 500;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_STONE_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)EternalTalesModItems.SOUL_FRAGMENT.get())});
        }
    };

    public SoulBattleTorchItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)5.0f, (float)-3.0f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        SoulBattleTorchLivingEntityIsHitWithToolProcedure.execute((Entity)entity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.eternal_tales.soul_battle_torch.description_0"));
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        BattleTorchRightClickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ());
        return InteractionResult.SUCCESS;
    }
}

