/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.item;

import java.util.List;
import net.eternal_tales.procedures.PlayerHavePurpurArrowProcedure;
import net.eternal_tales.procedures.StickyTriangleOnPlayerStoppedUsingProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StickyTriangleItem
extends Item {
    public StickyTriangleItem() {
        super(new Item.Properties().durability(2000));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_0"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_1"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_2"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_3"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_4"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_5"));
        list.add((Component)Component.translatable((String)"item.eternal_tales.sticky_triangle.description_6"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        PlayerHavePurpurArrowProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        StickyTriangleOnPlayerStoppedUsingProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
    }
}

