/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.jei_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ArchaeologyExcavationRecipeRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public ArchaeologyExcavationRecipeRecipe(ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return false;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider holder) {
        return this.output;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Type
    implements RecipeType<ArchaeologyExcavationRecipeRecipe> {
        public static final RecipeType<ArchaeologyExcavationRecipeRecipe> INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<ArchaeologyExcavationRecipeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<ArchaeologyExcavationRecipeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.STRICT_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] aingredient = (Ingredient[])ingredients.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients found in custom recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.recipeItems)).apply((Applicative)builder, ArchaeologyExcavationRecipeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ArchaeologyExcavationRecipeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ArchaeologyExcavationRecipeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ArchaeologyExcavationRecipeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ArchaeologyExcavationRecipeRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.withSize((int)buf.readVarInt(), (Object)Ingredient.EMPTY);
            inputs.replaceAll(ingredients -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            return new ArchaeologyExcavationRecipeRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), (NonNullList<Ingredient>)inputs);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buf, ArchaeologyExcavationRecipeRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ing : recipe.getIngredients()) {
                if (ing.getItems()[0].getItem() == Items.AIR) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)Ingredient.EMPTY);
                    continue;
                }
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ing);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getResultItem(null));
        }
    }
}

