/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.network;

import net.eternal_tales.EternalTalesMod;
import net.eternal_tales.procedures.Bank1TradeProcedure;
import net.eternal_tales.procedures.Bank2TradeProcedure;
import net.eternal_tales.procedures.Bank3TradeProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record Bank1ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<Bank1ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"bank_1_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Bank1ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new Bank1ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<Bank1ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(Bank1ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> Bank1ButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 1) {
            Bank1TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Bank1TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Bank2TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Bank2TradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Bank3TradeProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EternalTalesMod.addNetworkMessage(TYPE, STREAM_CODEC, Bank1ButtonMessage::handleData);
    }
}

