/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.network;

import net.eternal_tales.EternalTalesMod;
import net.eternal_tales.procedures.CollectorArchaeologyTextbookProcedure;
import net.eternal_tales.procedures.CollectorBuyAncientCoinForBlueprintProcedure;
import net.eternal_tales.procedures.CollectorBuyArchaeologyPotionProcedure;
import net.eternal_tales.procedures.CollectorBuyAtimitesCrossbowProcedure;
import net.eternal_tales.procedures.CollectorBuyMixcohuatlsWeaponProcedure;
import net.eternal_tales.procedures.CollectorBuyMuseumShowcaseProcedure;
import net.eternal_tales.procedures.CollectorBuyTotemBaseProcedure;
import net.eternal_tales.procedures.CollectorSpeechTextbookProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record CollectorGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CollectorGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"collector_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectorGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new CollectorGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<CollectorGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(CollectorGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> CollectorGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CollectorBuyAtimitesCrossbowProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            CollectorBuyMixcohuatlsWeaponProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            CollectorBuyTotemBaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            CollectorBuyArchaeologyPotionProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            CollectorBuyAncientCoinForBlueprintProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            CollectorBuyMuseumShowcaseProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            CollectorSpeechTextbookProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            CollectorArchaeologyTextbookProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EternalTalesMod.addNetworkMessage(TYPE, STREAM_CODEC, CollectorGUIButtonMessage::handleData);
    }
}

