/*
 * Decompiled with CFR 0.152.
 */
package net.eternal_tales.network;

import net.eternal_tales.EternalTalesMod;
import net.eternal_tales.procedures.MessiahTrade1Procedure;
import net.eternal_tales.procedures.MessiahTrade2Procedure;
import net.eternal_tales.procedures.MessiahTrade3NewProcedure;
import net.eternal_tales.procedures.MessiahTrade4Procedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record MessiahTradeGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessiahTradeGUIButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"eternal_tales", (String)"messiah_trade_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessiahTradeGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new MessiahTradeGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<MessiahTradeGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(MessiahTradeGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> MessiahTradeGUIButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MessiahTrade1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            MessiahTrade2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            MessiahTrade3NewProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MessiahTrade4Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        EternalTalesMod.addNetworkMessage(TYPE, STREAM_CODEC, MessiahTradeGUIButtonMessage::handleData);
    }
}

