/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;

public class CookingPotRenderer
implements BlockEntityRenderer<CookingPotBlockEntity> {
    private final BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();

    public CookingPotRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CookingPotBlockEntity blockEntity, float partialTick, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        Level level;
        BlockState state = blockEntity.getBlockState();
        if (!(state.getBlock() instanceof CookingPotBlock)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)CookingPotBlock.FACING);
        float y = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.EAST -> 90.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 270.0f;
            default -> 0.0f;
        };
        String color = blockEntity.getPersistentData().getString("color");
        CookingPotSupport support = (CookingPotSupport)state.getValue((Property)CookingPotBlock.SUPPORT);
        String modelPath = switch (support) {
            case CookingPotSupport.TRAY -> "_tray";
            case CookingPotSupport.HANDLE -> "_handle";
            default -> "";
        };
        String fd = "vanilladelight";
        String path = "block/cooking_pot_default" + modelPath;
        if (!color.isEmpty()) {
            path = "block/cooking_pot_" + color + modelPath;
        }
        if ((level = blockEntity.getLevel()) == null) {
            return;
        }
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)fd, (String)path)));
        pose.pushPose();
        pose.translate(0.5, 0.0, 0.5);
        pose.mulPose(Axis.YP.rotationDegrees(y));
        pose.translate(-0.5, 0.0, -0.5);
        long seed = state.getSeed(blockEntity.getBlockPos());
        this.dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, model, state, blockEntity.getBlockPos(), pose, buf.getBuffer(RenderType.cutout()), false, level.random, seed, overlay);
        pose.popPose();
    }
}

