/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.chaolux.vanilladelight.common.block.CommonCuttingBoard;
import net.chaolux.vanilladelight.registry.block.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

@EventBusSubscriber(modid="vanilladelight", bus=EventBusSubscriber.Bus.MOD)
public class CommonCuttingBoardBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final RecipeManager.CachedCheck<CuttingBoardRecipeInput, CuttingBoardRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipeTypes.CUTTING.get()));
    private ResourceLocation lastRecipeID;
    private boolean isItemCarvingBoard = false;

    public CommonCuttingBoardBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.COMMON_CUTTING_BOARD.get(), pos, state);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.COMMON_CUTTING_BOARD.get(), (be, context) -> be.getInventory());
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.isItemCarvingBoard = compound.getBoolean("IsItemCarved");
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putBoolean("IsItemCarved", this.isItemCarvingBoard);
    }

    public boolean processStoredItemUsingTool(ItemStack toolStack, @Nullable Player player) {
        if (this.level == null) {
            return false;
        }
        if (this.isItemCarvingBoard) {
            return false;
        }
        Optional<RecipeHolder<CuttingBoardRecipe>> matchingRecipe = this.getMatchingRecipe(toolStack, player);
        matchingRecipe.ifPresent(recipe -> {
            for (ItemStack resultStack : ((CuttingBoardRecipe)recipe.value()).rollResults(this.level.random, EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)this.level.holder(Enchantments.FORTUNE).get()), (ItemStack)toolStack))) {
                Direction direction = ((Direction)this.getBlockState().getValue((Property)CommonCuttingBoard.FACING)).getCounterClockWise();
                ItemUtils.spawnItemEntity((Level)this.level, (ItemStack)resultStack.copy(), (double)((double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.2), (double)((double)this.worldPosition.getY() + 0.2), (double)((double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.2), (double)((float)direction.getStepX() * 0.2f), (double)0.0, (double)((float)direction.getStepZ() * 0.2f));
            }
            if (!this.level.isClientSide) {
                toolStack.hurtAndBreak(1, (ServerLevel)this.level, (LivingEntity)player, item -> {});
            }
            this.playProcessingSound(((CuttingBoardRecipe)recipe.value()).getSoundEvent().orElse(null), toolStack, this.getStoredItem());
            this.removeItem();
            if (player instanceof ServerPlayer) {
                ((CuttingBoardTrigger)ModAdvancements.USE_CUTTING_BOARD.get()).trigger((ServerPlayer)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<RecipeHolder<CuttingBoardRecipe>> getMatchingRecipe(ItemStack toolStack, @Nullable Player player) {
        if (this.level == null) {
            return Optional.empty();
        }
        Optional recipe = this.quickCheck.getRecipeFor((RecipeInput)new CuttingBoardRecipeInput(this.getStoredItem(), toolStack), this.level);
        if (recipe.isPresent()) {
            if (((CuttingBoardRecipe)((RecipeHolder)recipe.get()).value()).getTool().test(toolStack)) {
                return recipe;
            }
            if (player != null) {
                player.displayClientMessage((Component)TextUtils.getTranslation((String)"block.cutting_board.invalid_tool", (Object[])new Object[0]), true);
            }
        } else if (player != null) {
            player.displayClientMessage((Component)TextUtils.getTranslation((String)"block.cutting_board.invalid_item", (Object[])new Object[0]), true);
        }
        return Optional.empty();
    }

    public void playProcessingSound(@Nullable SoundEvent sound, ItemStack tool, ItemStack boardItem) {
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.is(Tags.Items.TOOLS_SHEAR)) {
            this.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
        } else if (tool.is(CommonTags.TOOLS_KNIFE)) {
            this.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else {
            Item item = boardItem.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                SoundType soundType = block.defaultBlockState().getSoundType();
                this.playSound(soundType.getBreakSound(), 1.0f, 0.8f);
            } else {
                this.playSound(SoundEvents.WOOD_BREAK, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.level != null) {
            this.level.playSound((Player)null, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.inventory.setStackInSlot(0, itemStack.split(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack item = this.getStoredItem().split(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.EMPTY;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                CommonCuttingBoardBlockEntity.this.inventoryChanged();
            }
        };
    }
}

