/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.item;

import java.util.List;
import net.chaolux.vanilladelight.common.utility.VDTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.EventHooks;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CookedRedMushroomItem
extends ConsumableItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;

    public CookedRedMushroomItem(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = true;
        this.hasCustomTooltip = true;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        MobEffectInstance selectedEffect = consumer.getEffect(MobEffects.WITHER);
        if (selectedEffect != null && !EventHooks.onEffectRemoved((LivingEntity)consumer, (MobEffectInstance)selectedEffect, (EffectCure)EffectCures.MILK)) {
            consumer.removeEffect(MobEffects.WITHER);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + BuiltInRegistries.ITEM.getKey((Object)this).getPath(), new Object[0]);
                tooltip.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
            }
        }
    }
}

