/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class PufferfishStewItem
extends ConsumableItem {
    public PufferfishStewItem(Item.Properties properties) {
        super(properties);
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        if (level.isClientSide) {
            return;
        }
        if (level.random.nextBoolean()) {
            consumer.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 3));
            level.playSound(null, consumer.blockPosition(), SoundEvents.PUFFER_FISH_BLOW_UP, SoundSource.PLAYERS, 0.8f, 0.8f);
        } else {
            consumer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 3));
            level.playSound(null, consumer.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            MobEffectInstance regen = new MobEffectInstance(MobEffects.REGENERATION, 200, 3);
            MobEffectInstance poison = new MobEffectInstance(MobEffects.POISON, 200, 3);
            MutableComponent regenText = PufferfishStewItem.effectText(regen).withStyle(ChatFormatting.BLUE);
            MutableComponent poisonText = PufferfishStewItem.effectText(poison).withStyle(ChatFormatting.RED);
            MutableComponent orText = Component.translatable((String)"vanilladelight.tooltip.or").withStyle(ChatFormatting.GOLD);
            tooltip.add((Component)Component.empty().append((Component)poisonText).append((Component)Component.literal((String)" ").append((Component)orText).append(" ").append((Component)regenText)));
        }
    }

    private static MutableComponent effectText(MobEffectInstance instance) {
        MutableComponent component = Component.translatable((String)instance.getDescriptionId());
        if (instance.getAmplifier() > 0) {
            component = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
        }
        if (instance.getDuration() > 20) {
            component = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{component, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)20.0f)});
        }
        return component;
    }
}

