/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.item;

import java.util.List;
import net.chaolux.vanilladelight.common.utility.VDTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SweetBerriesJamItem
extends DrinkableItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;

    public SweetBerriesJamItem(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = true;
        this.hasCustomTooltip = true;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        if (level.isClientSide) {
            return;
        }
        double radius = 25.0;
        List mobs = level.getEntitiesOfClass(LivingEntity.class, consumer.getBoundingBox().inflate(radius), entity -> entity != consumer && entity.isAlive() && entity instanceof Monster);
        for (LivingEntity livingEntity : mobs) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0, false, false));
        }
        if (consumer instanceof Player) {
            Player player = (Player)consumer;
            level.playSound(null, player.blockPosition(), SoundEvents.SWEET_BERRY_BUSH_PLACE, SoundSource.PLAYERS, 0.8f, 1.0f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + BuiltInRegistries.ITEM.getKey((Object)this).getPath(), new Object[0]);
                tooltip.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
            }
        }
    }
}

