/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.item;

import java.util.List;
import net.chaolux.vanilladelight.common.utility.VDTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SweetBerryCustard
extends DrinkableItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;

    public SweetBerryCustard(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = true;
        this.hasCustomTooltip = true;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        if (level.isClientSide) {
            return;
        }
        double radius = 3.0;
        List mobs = level.getEntitiesOfClass(LivingEntity.class, consumer.getBoundingBox().inflate(radius), entity -> entity != consumer && entity.isAlive() && !(entity instanceof Player));
        for (LivingEntity entity2 : mobs) {
            entity2.hurt(entity2.damageSources().thorns((Entity)consumer), 2.0f);
            Vec3 direction = entity2.position().subtract(consumer.position()).normalize().scale(0.4);
            entity2.push(direction.x, 0.1, direction.z);
        }
        level.levelEvent(2001, consumer.blockPosition(), Block.getId((BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState()));
        level.playSound(null, consumer.blockPosition(), SoundEvents.PLAYER_HURT_SWEET_BERRY_BUSH, SoundSource.PLAYERS, 0.8f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + BuiltInRegistries.ITEM.getKey((Object)this).getPath(), new Object[0]);
                tooltip.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
            }
        }
    }
}

