/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.vanilladelight.common.item;

import java.util.List;
import net.chaolux.vanilladelight.common.utility.VDTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SweetFishSoupItem
extends ConsumableItem {
    private final boolean hasFoodEffectTooltip;
    private final boolean hasCustomTooltip;

    public SweetFishSoupItem(Item.Properties properties) {
        super(properties);
        this.hasFoodEffectTooltip = true;
        this.hasCustomTooltip = true;
    }

    public void affectConsumer(ItemStack stack, Level level, LivingEntity consumer) {
        if (level.isClientSide || !(consumer instanceof Player)) {
            return;
        }
        Player player = (Player)consumer;
        double radius = 8.0;
        List cats = level.getEntitiesOfClass(Cat.class, consumer.getBoundingBox().inflate(radius), cat -> true);
        for (Cat cat2 : cats) {
            if (cat2.isOrderedToSit()) {
                cat2.setInSittingPose(false);
            }
            cat2.getLookControl().setLookAt((Entity)player, 30.0f, 30.0f);
            PathNavigation navigation = cat2.getNavigation();
            if (navigation == null) continue;
            navigation.moveTo((Entity)player, 2.0);
        }
        level.playSound(null, player.blockPosition(), SoundEvents.CAT_PURR, SoundSource.PLAYERS, 0.9f, 1.0f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (this.hasCustomTooltip) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + BuiltInRegistries.ITEM.getKey((Object)this).getPath(), new Object[0]);
                tooltip.add((Component)textEmpty.withStyle(ChatFormatting.BLUE));
            }
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
            }
        }
    }
}

