/*
 * Decompiled with CFR 0.152.
 */
package com.j2k.MobsPrank;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Snowball;

public class PrankSnowballGoal
extends Goal {
    private final PathfinderMob mob;
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private final int attackInterval;
    private final float attackRadius;
    private final double STOP_DISTANCE = 8.0;
    private final double BACKOFF_DISTANCE = 5.0;

    public PrankSnowballGoal(PathfinderMob mob, double speed, int attackInterval, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speed;
        this.attackInterval = attackInterval;
        this.attackRadius = attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return true;
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
        this.attackTime = -1;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        double distSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean canSee = this.mob.m_21574_().m_148306_((Entity)this.target);
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (distSqr > 64.0) {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        } else if (distSqr < 25.0) {
            double backX = this.mob.m_20185_() + (this.mob.m_20185_() - this.target.m_20185_());
            double backZ = this.mob.m_20189_() + (this.mob.m_20189_() - this.target.m_20189_());
            this.mob.m_21573_().m_26519_(backX, this.mob.m_20186_(), backZ, this.speedModifier);
        } else {
            this.mob.m_21573_().m_26573_();
        }
        if (--this.attackTime == 0) {
            if (!canSee) {
                return;
            }
            if (distSqr <= (double)(this.attackRadius * this.attackRadius)) {
                this.performSnowballAttack(this.target);
                this.attackTime = this.attackInterval;
            }
        } else if (this.attackTime < 0) {
            this.attackTime = this.attackInterval;
        }
    }

    private void performSnowballAttack(LivingEntity target) {
        Snowball snowball = new Snowball(this.mob.m_9236_(), (LivingEntity)this.mob);
        double d0 = target.m_20185_() - this.mob.m_20185_();
        double d1 = target.m_20188_() - 1.1 - snowball.m_20186_();
        double d2 = target.m_20189_() - this.mob.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * 0.2;
        snowball.m_6686_(d0, d1 + d3, d2, 1.6f, 12.0f);
        this.mob.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.mob.m_9236_().m_7967_((Entity)snowball);
    }
}

