/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerafix;

import com.example.camerafix.CameraSettings;
import com.example.camerafix.client.CameraSettingsScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_5498;

public class CameraFixClient
implements ClientModInitializer {
    public static class_304 openSettings;
    private static boolean appliedHudHidden;
    private static boolean autoFirstPerson;
    private static class_5498 savedPerspective;
    public static double lastThirdPersonLen;
    private static int caveHoldTicks;
    private static int collapseHoldTicks;

    public void onInitializeClient() {
        CameraSettings.load();
        openSettings = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.camerafix.open", class_3675.class_307.field_1668, 79, "category.camerafix"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!appliedHudHidden && client.field_1690 != null) {
                client.field_1690.field_1842 = CameraSettings.hideGui;
                appliedHudHidden = true;
            }
            while (openSettings.method_1436()) {
                if (client.field_1755 != null) continue;
                client.method_1507((class_437)new CameraSettingsScreen());
            }
            if (client.field_1687 != null && client.field_1724 != null && client.field_1690 != null) {
                boolean should;
                boolean collapsedNow;
                class_5498 current = client.field_1690.method_31044();
                class_4184 cam = client.field_1773.method_19418();
                boolean extremeUp = cam != null && cam.method_19329() <= -89.5f;
                boolean cameraVerge = current != class_5498.field_26664 && CameraFixClient.cameraNearEnteringPlayer(client, (class_1657)client.field_1724);
                boolean undergroundNow = CameraFixClient.isUndergroundOrCave((class_1937)client.field_1687, (class_1657)client.field_1724);
                if (undergroundNow) {
                    caveHoldTicks = 12;
                } else if (caveHoldTicks > 0) {
                    --caveHoldTicks;
                }
                boolean underground = caveHoldTicks > 0;
                double collapseThreshold = Math.max(0.4, CameraSettings.collisionMargin * 2.0);
                boolean bl = collapsedNow = current != class_5498.field_26664 && lastThirdPersonLen > 0.0 && lastThirdPersonLen <= collapseThreshold;
                if (collapsedNow) {
                    collapseHoldTicks = 3;
                } else if (collapseHoldTicks > 0) {
                    --collapseHoldTicks;
                }
                boolean bl2 = should = CameraFixClient.shouldForceFirstPerson((class_1937)client.field_1687, (class_1657)client.field_1724) || cameraVerge || underground;
                if (!should && collapseHoldTicks > 0) {
                    should = true;
                }
                if (!should && current != class_5498.field_26664 && extremeUp) {
                    should = true;
                }
                if (should) {
                    if (!autoFirstPerson) {
                        savedPerspective = current != class_5498.field_26664 ? current : null;
                    }
                    client.field_1690.method_31043(class_5498.field_26664);
                    autoFirstPerson = true;
                } else {
                    boolean hold;
                    boolean bl3 = hold = autoFirstPerson && (CameraFixClient.predictiveHeadRisk((class_1937)client.field_1687, (class_1657)client.field_1724) || cameraVerge || caveHoldTicks > 0 || collapseHoldTicks > 0 || extremeUp);
                    if (!hold) {
                        if (autoFirstPerson && savedPerspective != null) {
                            boolean can = CameraFixClient.hasSpaceForThirdPerson(client, (class_1657)client.field_1724);
                            if (can) {
                                client.field_1690.method_31043(savedPerspective);
                                autoFirstPerson = false;
                                savedPerspective = null;
                            } else {
                                client.field_1690.method_31043(class_5498.field_26664);
                                autoFirstPerson = true;
                            }
                        } else {
                            autoFirstPerson = false;
                            savedPerspective = null;
                        }
                    }
                }
            }
        });
    }

    private static boolean shouldForceFirstPerson(class_1937 world, class_1657 player) {
        class_238 box = player.method_5829();
        double torsoY = (box.field_1322 + box.field_1325) * 0.5;
        double headY = box.field_1325 - 0.2;
        class_2338 torsoPos = class_2338.method_49637((double)player.method_23317(), (double)torsoY, (double)player.method_23321());
        class_2338 headPos = class_2338.method_49637((double)player.method_23317(), (double)headY, (double)player.method_23321());
        boolean torsoOpp = CameraFixClient.hasOppositeBlockers(world, torsoPos);
        boolean headOpp = CameraFixClient.hasOppositeBlockers(world, headPos);
        boolean torsoAny = CameraFixClient.hasAnyBlocker(world, torsoPos);
        boolean headAny = CameraFixClient.hasAnyBlocker(world, headPos);
        boolean headTop = CameraFixClient.isSolid(world, headPos.method_10084());
        if (torsoOpp && headOpp) {
            return true;
        }
        if (torsoOpp && headAny) {
            return true;
        }
        return torsoAny && headAny && headTop;
    }

    private static boolean isUndergroundOrCave(class_1937 world, class_1657 player) {
        class_238 box = player.method_5829();
        double headY = box.field_1325 - 0.2;
        class_2338 headPos = class_2338.method_49637((double)player.method_23317(), (double)headY, (double)player.method_23321());
        int solidAbove = 0;
        class_2338 p = headPos.method_10084();
        for (int i = 0; i < 24 && CameraFixClient.isSolid(world, p); ++i) {
            ++solidAbove;
            p = p.method_10084();
        }
        boolean aboveCovered = solidAbove >= 5;
        boolean lateralBlocked = CameraFixClient.isOccluded(world, headPos) || CameraFixClient.isOccluded(world, headPos.method_10084());
        boolean skyOpen = false;
        class_2338 q = headPos.method_10084();
        int airRun = 0;
        for (int i = 0; i < 24 && !CameraFixClient.isSolid(world, q); ++i) {
            ++airRun;
            q = q.method_10084();
        }
        skyOpen = airRun >= 12;
        boolean belowSea = player.method_23318() < (double)world.method_8615() - 4.0;
        return aboveCovered && lateralBlocked && !skyOpen && belowSea;
    }

    private static boolean cameraNearEnteringPlayer(class_310 client, class_1657 player) {
        double dy;
        double dx;
        double m;
        class_4184 cam = client.field_1773.method_19418();
        if (cam == null) {
            return false;
        }
        class_243 p = cam.method_19326();
        class_238 box = player.method_5829();
        class_238 expanded = box.method_1014(m = Math.max(0.05, CameraSettings.collisionMargin));
        if (expanded.method_1006(p)) {
            return true;
        }
        double d = p.field_1352 < expanded.field_1323 ? expanded.field_1323 - p.field_1352 : (dx = p.field_1352 > expanded.field_1320 ? p.field_1352 - expanded.field_1320 : 0.0);
        double d2 = p.field_1351 < expanded.field_1322 ? expanded.field_1322 - p.field_1351 : (dy = p.field_1351 > expanded.field_1325 ? p.field_1351 - expanded.field_1325 : 0.0);
        double dz = p.field_1350 < expanded.field_1321 ? expanded.field_1321 - p.field_1350 : (p.field_1350 > expanded.field_1324 ? p.field_1350 - expanded.field_1324 : 0.0);
        double distSq = dx * dx + dy * dy + dz * dz;
        return distSq <= m * m;
    }

    private static boolean hasSpaceForThirdPerson(class_310 client, class_1657 player) {
        class_4184 cam = client.field_1773.method_19418();
        if (cam == null) {
            return false;
        }
        class_243 eyePos = player.method_5836(1.0f);
        class_243 forward = class_243.method_1030((float)cam.method_19329(), (float)cam.method_19330()).method_1029();
        class_243 offset = CameraSettings.computeOffset(cam.method_19330(), cam.method_19329());
        double baseLen = lastThirdPersonLen > 0.0 ? lastThirdPersonLen : 3.5;
        class_243 desired = eyePos.method_1019(forward.method_1021(-baseLen)).method_1019(offset);
        class_243 dir = desired.method_1020(eyePos);
        double len = dir.method_1033();
        if (len <= 1.0E-6) {
            return false;
        }
        class_243 dirN = dir.method_1029();
        double margin = Math.max(0.02, CameraSettings.collisionMargin);
        double epsilon = Math.max(0.1, margin * 0.75);
        int ring = 8;
        class_243 worldUp = new class_243(0.0, 1.0, 0.0);
        class_243 right = dirN.method_1036(worldUp).method_1029();
        if (right.method_1027() < 1.0E-6) {
            right = new class_243(1.0, 0.0, 0.0);
        }
        class_243 up = worldUp;
        for (int i = 0; i < ring; ++i) {
            double a = Math.PI * 2 * ((double)i / (double)ring);
            class_243 o = right.method_1021(Math.cos(a)).method_1019(up.method_1021(Math.sin(a))).method_1029();
            class_243 s1 = o.method_1021(epsilon);
            class_243 s2 = o.method_1021(epsilon * 2.0);
            class_3965 h1 = client.field_1687.method_17742(new class_3959(eyePos.method_1019(s1), desired.method_1019(s1), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            class_3965 h2 = client.field_1687.method_17742(new class_3959(eyePos.method_1019(s2), desired.method_1019(s2), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
            if (h1.method_17783() != class_239.class_240.field_1332 && h2.method_17783() != class_239.class_240.field_1332) continue;
            return false;
        }
        double r = Math.max(0.06, epsilon * 0.75);
        class_238 b = new class_238(desired.field_1352 - r, desired.field_1351 - r, desired.field_1350 - r, desired.field_1352 + r, desired.field_1351 + r, desired.field_1350 + r);
        boolean coll = client.field_1687.method_20812((class_1297)player, b).iterator().hasNext();
        return !coll;
    }

    private static boolean isOccluded(class_1937 world, class_2338 center) {
        boolean eDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11034);
        boolean wDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11039);
        boolean nDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11043);
        boolean sDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11035);
        boolean eGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11034);
        boolean wGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11039);
        boolean nGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11043);
        boolean sGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11035);
        int directCount = 0;
        if (eDirect) {
            ++directCount;
        }
        if (wDirect) {
            ++directCount;
        }
        if (nDirect) {
            ++directCount;
        }
        if (sDirect) {
            ++directCount;
        }
        if (directCount >= 3) {
            return true;
        }
        if (CameraFixClient.pairBlocked(eDirect, wDirect, eGap, wGap)) {
            return true;
        }
        return CameraFixClient.pairBlocked(nDirect, sDirect, nGap, sGap);
    }

    private static boolean hasOppositeBlockers(class_1937 world, class_2338 center) {
        boolean eDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11034);
        boolean wDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11039);
        boolean nDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11043);
        boolean sDirect = CameraFixClient.isDirectSolid(world, center, class_2350.field_11035);
        boolean eGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11034);
        boolean wGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11039);
        boolean nGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11043);
        boolean sGap = CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11035);
        if (CameraFixClient.pairBlocked(eDirect, wDirect, eGap, wGap)) {
            return true;
        }
        return CameraFixClient.pairBlocked(nDirect, sDirect, nGap, sGap);
    }

    private static boolean hasAnyBlocker(class_1937 world, class_2338 center) {
        if (CameraFixClient.isDirectSolid(world, center, class_2350.field_11034)) {
            return true;
        }
        if (CameraFixClient.isDirectSolid(world, center, class_2350.field_11039)) {
            return true;
        }
        if (CameraFixClient.isDirectSolid(world, center, class_2350.field_11043)) {
            return true;
        }
        if (CameraFixClient.isDirectSolid(world, center, class_2350.field_11035)) {
            return true;
        }
        if (CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11034)) {
            return true;
        }
        if (CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11039)) {
            return true;
        }
        if (CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11043)) {
            return true;
        }
        return CameraFixClient.isOneGapThenSolid(world, center, class_2350.field_11035);
    }

    private static boolean pairBlocked(boolean aDirect, boolean bDirect, boolean aGap, boolean bGap) {
        if (aDirect && bDirect) {
            return true;
        }
        return aDirect && bGap || bDirect && aGap;
    }

    private static boolean isDirectSolid(class_1937 world, class_2338 center, class_2350 dir) {
        class_2338 p1 = center.method_10093(dir);
        return CameraFixClient.isSolid(world, p1);
    }

    private static boolean isOneGapThenSolid(class_1937 world, class_2338 center, class_2350 dir) {
        class_2338 p1 = center.method_10093(dir);
        class_2338 p2 = p1.method_10093(dir);
        if (CameraFixClient.isSolid(world, p1)) {
            return false;
        }
        return CameraFixClient.isSolid(world, p2);
    }

    private static boolean isSolid(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        return !state.method_26220((class_1922)world, pos).method_1110();
    }

    private static boolean predictiveHeadRisk(class_1937 world, class_1657 player) {
        class_238 box = player.method_5829();
        double headY = box.field_1325 - 0.2;
        double x = player.method_23317();
        double z = player.method_23321();
        class_238 headCollider = new class_238(x - 0.5, headY - 0.5, z - 0.5, x + 0.5, headY + 0.5, z + 0.5);
        boolean nearCollision = world.method_20812((class_1297)player, headCollider).iterator().hasNext();
        class_2338 headPos = class_2338.method_49637((double)x, (double)headY, (double)z);
        boolean soonOccluded = CameraFixClient.isOccluded(world, headPos.method_10084());
        return nearCollision || soonOccluded;
    }
}

