/*
 * Decompiled with CFR 0.152.
 */
package com.example.camerafix;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class CameraSettings {
    public static double offsetX = 0.0;
    public static double offsetY = 0.0;
    public static double offsetZ = 0.0;
    public static boolean invert = false;
    public static boolean hideGui = false;
    public static double xRotationDegrees = 0.0;
    public static double collisionMargin = 0.1;

    public static void reset() {
        offsetX = 0.0;
        offsetY = 0.0;
        offsetZ = 0.0;
        invert = false;
        hideGui = false;
        xRotationDegrees = 0.0;
        collisionMargin = 0.1;
        CameraSettings.save();
    }

    public static class_243 computeOffset(float yaw, float pitch) {
        class_243 forward = class_243.method_1030((float)pitch, (float)yaw).method_1029();
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 right = forward.method_1036(up).method_1029();
        if (invert) {
            right = right.method_1021(-1.0);
        }
        class_243 v = forward.method_1021(-offsetX).method_1019(up.method_1021(offsetY)).method_1019(right.method_1021(offsetZ));
        if (xRotationDegrees != 0.0) {
            v = v.method_1037((float)Math.toRadians(xRotationDegrees));
        }
        return v;
    }

    public static void load() {
        class_310 mc = class_310.method_1551();
        Path p = mc.field_1697.toPath().resolve("config").resolve("camera_collision_fix.json");
        if (!Files.exists(p, new LinkOption[0])) {
            return;
        }
        try {
            String s = Files.readString(p, StandardCharsets.UTF_8);
            JsonObject o = JsonParser.parseString((String)s).getAsJsonObject();
            if (o.has("offsetX")) {
                offsetX = o.get("offsetX").getAsDouble();
            }
            if (o.has("offsetY")) {
                offsetY = o.get("offsetY").getAsDouble();
            }
            if (o.has("offsetZ")) {
                offsetZ = o.get("offsetZ").getAsDouble();
            }
            if (o.has("invert")) {
                invert = o.get("invert").getAsBoolean();
            }
            if (o.has("hideGui")) {
                hideGui = o.get("hideGui").getAsBoolean();
            }
            if (o.has("xRotationDegrees")) {
                xRotationDegrees = o.get("xRotationDegrees").getAsDouble();
            }
            if (o.has("collisionMargin")) {
                collisionMargin = o.get("collisionMargin").getAsDouble();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        class_310 mc = class_310.method_1551();
        Path dir = mc.field_1697.toPath().resolve("config");
        Path p = dir.resolve("camera_collision_fix.json");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            Gson gson = new Gson();
            JsonObject o = new JsonObject();
            o.addProperty("offsetX", (Number)offsetX);
            o.addProperty("offsetY", (Number)offsetY);
            o.addProperty("offsetZ", (Number)offsetZ);
            o.addProperty("invert", Boolean.valueOf(invert));
            o.addProperty("hideGui", Boolean.valueOf(hideGui));
            o.addProperty("xRotationDegrees", (Number)xRotationDegrees);
            o.addProperty("collisionMargin", (Number)collisionMargin);
            String s = gson.toJson((JsonElement)o);
            Files.writeString(p, (CharSequence)s, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

